/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.figure;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.theplumteam.block.PopBlockColor;
import com.theplumteam.figure.FigureType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class FigureDefinition {
    private final String id;
    private final String name;
    private final class_2960 modelPath;
    private final class_2960 texturePath;
    private final class_2960 animationPath;
    private final FigureType type;
    private final UUID playerUUID;
    private final List<AlternativeSkin> alternatives;
    private final PopBlockColor favoriteColor;

    public FigureDefinition(String id, String name, class_2960 modelPath, class_2960 texturePath, class_2960 animationPath) {
        this(id, name, modelPath, texturePath, animationPath, Collections.emptyList());
    }

    public FigureDefinition(String id, String name, class_2960 modelPath, class_2960 texturePath, class_2960 animationPath, List<AlternativeSkin> alternatives) {
        this.id = id;
        this.name = name;
        this.modelPath = modelPath;
        this.texturePath = texturePath;
        this.animationPath = animationPath;
        this.type = FigureType.STATIC;
        this.playerUUID = null;
        this.alternatives = new ArrayList<AlternativeSkin>(alternatives);
        this.favoriteColor = null;
    }

    public FigureDefinition(String id, String name, class_2960 modelPath, class_2960 animationPath, UUID playerUUID, PopBlockColor favoriteColor) {
        this.id = id;
        this.name = name;
        this.modelPath = modelPath;
        this.texturePath = null;
        this.animationPath = animationPath;
        this.type = FigureType.PLAYER;
        this.playerUUID = playerUUID;
        this.alternatives = Collections.emptyList();
        this.favoriteColor = favoriteColor;
    }

    public static FigureDefinition fromJson(JsonObject json) {
        String type;
        String id = json.get("id").getAsString();
        String name = json.get("name").getAsString();
        class_2960 modelPath = class_2960.method_12829((String)json.get("model").getAsString());
        class_2960 animationPath = class_2960.method_12829((String)json.get("animation").getAsString());
        String string = type = json.has("type") ? json.get("type").getAsString() : "static";
        if ("player".equals(type)) {
            UUID playerUUID = json.has("player_uuid") ? UUID.fromString(json.get("player_uuid").getAsString()) : null;
            PopBlockColor favoriteColor = null;
            if (json.has("favorite_color")) {
                try {
                    favoriteColor = PopBlockColor.valueOf(json.get("favorite_color").getAsString().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    favoriteColor = PopBlockColor.ORIGINAL;
                }
            }
            return new FigureDefinition(id, name, modelPath, animationPath, playerUUID, favoriteColor);
        }
        class_2960 texturePath = class_2960.method_12829((String)json.get("texture").getAsString());
        ArrayList<AlternativeSkin> alternatives = new ArrayList<AlternativeSkin>();
        if (json.has("alternatives")) {
            JsonArray alternativesArray = json.getAsJsonArray("alternatives");
            for (int i = 0; i < alternativesArray.size(); ++i) {
                JsonObject altJson = alternativesArray.get(i).getAsJsonObject();
                alternatives.add(AlternativeSkin.fromJson(altJson));
            }
        }
        return new FigureDefinition(id, name, modelPath, texturePath, animationPath, alternatives);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getModelPath() {
        return this.modelPath;
    }

    public class_2960 getTexturePath() {
        return this.texturePath;
    }

    public class_2960 getAnimationPath() {
        return this.animationPath;
    }

    public FigureType getType() {
        return this.type;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public List<AlternativeSkin> getAlternatives() {
        return Collections.unmodifiableList(this.alternatives);
    }

    public boolean hasAlternatives() {
        return !this.alternatives.isEmpty();
    }

    @Nullable
    public PopBlockColor getFavoriteColor() {
        return this.favoriteColor;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("model", this.modelPath.toString());
        json.addProperty("animation", this.animationPath.toString());
        if (this.type == FigureType.PLAYER) {
            json.addProperty("type", "player");
            if (this.playerUUID != null) {
                json.addProperty("player_uuid", this.playerUUID.toString());
            }
            if (this.favoriteColor != null) {
                json.addProperty("favorite_color", this.favoriteColor.method_15434());
            }
        } else {
            json.addProperty("type", "static");
            if (this.texturePath != null) {
                json.addProperty("texture", this.texturePath.toString());
            }
            if (!this.alternatives.isEmpty()) {
                JsonArray alternativesArray = new JsonArray();
                for (AlternativeSkin alt : this.alternatives) {
                    JsonObject altJson = new JsonObject();
                    altJson.addProperty("name", alt.name());
                    altJson.addProperty("texture", alt.texture().toString());
                    alternativesArray.add((JsonElement)altJson);
                }
                json.add("alternatives", (JsonElement)alternativesArray);
            }
        }
        return json;
    }

    public String toString() {
        return "FigureDefinition{id='" + this.id + "', name='" + this.name + "', type=" + String.valueOf((Object)this.type) + "}";
    }

    public record AlternativeSkin(String name, class_2960 texture) {
        public static AlternativeSkin fromJson(JsonObject json) {
            String name = json.get("name").getAsString();
            class_2960 texture = class_2960.method_12829((String)json.get("texture").getAsString());
            return new AlternativeSkin(name, texture);
        }
    }
}

