/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.theplumteam.figure.CollectionRegistry;
import com.theplumteam.figure.FigureCollection;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDynamicCollectionsPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncDynamicCollectionsPacket.class);
    private static final Gson GSON = new Gson();
    public static final class_2960 ID = new class_2960("blockpops", "sync_dynamic_collections");
    private final List<String> collectionsJson;

    public SyncDynamicCollectionsPacket(List<FigureCollection> collections) {
        this.collectionsJson = new ArrayList<String>();
        for (FigureCollection collection : collections) {
            JsonObject json = collection.toJson();
            this.collectionsJson.add(GSON.toJson((JsonElement)json));
        }
    }

    private SyncDynamicCollectionsPacket(ArrayList<String> collectionsJson) {
        this.collectionsJson = collectionsJson;
    }

    public class_2540 encode() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(this.collectionsJson.size());
        for (String json : this.collectionsJson) {
            buffer.method_10788(json, 0x100000);
        }
        return buffer;
    }

    public static SyncDynamicCollectionsPacket decode(class_2540 buffer) {
        int size = buffer.readInt();
        ArrayList<String> collectionsJson = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            collectionsJson.add(buffer.method_10800(0x100000));
        }
        return new SyncDynamicCollectionsPacket(collectionsJson);
    }

    public static void handleClient(class_2540 buf, NetworkManager.PacketContext context) {
        SyncDynamicCollectionsPacket packet = SyncDynamicCollectionsPacket.decode(buf);
        context.queue(() -> {
            LOGGER.info("Received {} dynamic collections from server", (Object)packet.collectionsJson.size());
            for (String json : packet.collectionsJson) {
                try {
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
                    FigureCollection collection = FigureCollection.fromJson(jsonObject);
                    CollectionRegistry.registerDynamicCollection(collection);
                    LOGGER.info("Registered dynamic collection: {} with {} figures", (Object)collection.getName(), (Object)collection.getFigures().size());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to deserialize dynamic collection", (Throwable)e);
                }
            }
        });
    }

    public static void sendToPlayer(class_3222 player, List<FigureCollection> collections) {
        SyncDynamicCollectionsPacket packet = new SyncDynamicCollectionsPacket(collections);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)ID, (class_2540)packet.encode());
    }

    public static void sendToAllPlayers(MinecraftServer server, List<FigureCollection> collections) {
        SyncDynamicCollectionsPacket packet = new SyncDynamicCollectionsPacket(collections);
        for (class_3222 player : server.method_3760().method_14571()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)ID, (class_2540)packet.encode());
        }
    }

    public List<String> getCollectionsJson() {
        return this.collectionsJson;
    }
}

