/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.network;

import com.theplumteam.data.IPlayerDiscovery;
import com.theplumteam.data.PlayerDataManager;
import com.theplumteam.network.SyncTokenDataPacket;
import com.theplumteam.server.ServerTickHandler;
import com.theplumteam.server.config.ServerConfig;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateGuaranteedResetHourPacket {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateGuaranteedResetHourPacket.class);
    public static final class_2960 ID = new class_2960("blockpops", "update_guaranteed_reset_hour");
    private final int resetHour;

    public UpdateGuaranteedResetHourPacket(int resetHour) {
        this.resetHour = resetHour;
    }

    public class_2540 encode() {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(this.resetHour);
        return buffer;
    }

    public static UpdateGuaranteedResetHourPacket decode(class_2540 buffer) {
        return new UpdateGuaranteedResetHourPacket(buffer.readInt());
    }

    public static void handleServer(class_2540 buf, NetworkManager.PacketContext context) {
        UpdateGuaranteedResetHourPacket packet = UpdateGuaranteedResetHourPacket.decode(buf);
        context.queue(() -> {
            class_1657 patt0$temp = context.getPlayer();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                if (player.method_5687(2)) {
                    ServerConfig.getInstance().setGuaranteedTokenResetHour(packet.resetHour);
                    LOGGER.info("Player {} updated guaranteed token reset hour to {} UTC", (Object)player.method_5477().getString(), (Object)packet.resetHour);
                    UpdateGuaranteedResetHourPacket.syncTokenData(player);
                } else {
                    LOGGER.warn("Player {} tried to update reset hour without permission", (Object)player.method_5477().getString());
                }
            }
        });
    }

    private static void syncTokenData(class_3222 player) {
        IPlayerDiscovery discovery = PlayerDataManager.getDiscovery((class_1657)player);
        long gameTime = player.method_51469().method_8510();
        long nextRegularTime = discovery.getNextRegularTokenTime();
        long ticksUntilNext = Math.max(0L, nextRegularTime - gameTime);
        long millisUntilReset = ServerTickHandler.calculateMillisUntilNextReset();
        SyncTokenDataPacket.sendToPlayer(player, discovery.getRegularTokens(), ticksUntilNext, !discovery.hasUsedTodaySpecialToken(), millisUntilReset);
    }

    public void sendToServer() {
        NetworkManager.sendToServer((class_2960)ID, (class_2540)this.encode());
    }
}

