/*
 * Decompiled with CFR 0.152.
 */
package com.theplumteam.util;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_640;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinModelDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkinModelDetector.class);
    private static final ConcurrentHashMap<class_2960, SkinModel> DETECTION_CACHE = new ConcurrentHashMap();

    public static void clearCache() {
        DETECTION_CACHE.clear();
        LOGGER.info("Skin model detection cache cleared");
    }

    public static SkinModel detectSkinModel(class_2960 textureLocation) {
        SkinModel cached = DETECTION_CACHE.get(textureLocation);
        if (cached != null) {
            return cached;
        }
        LOGGER.debug("Attempting to detect skin model for texture: {}", (Object)textureLocation);
        try {
            class_1060 textureManager;
            class_1044 abstractTexture;
            if (class_310.method_1551().method_1562() != null) {
                Collection playerListEntries = class_310.method_1551().method_1562().method_2880();
                for (class_640 playerInfo : playerListEntries) {
                    if (!playerInfo.method_2968().equals((Object)textureLocation)) continue;
                    String modelName = playerInfo.method_2977();
                    SkinModel model = "slim".equals(modelName) ? SkinModel.SLIM : SkinModel.CLASSIC;
                    LOGGER.info("Detected {} skin from PlayerInfo for texture: {}", (Object)model, (Object)textureLocation);
                    DETECTION_CACHE.put(textureLocation, model);
                    return model;
                }
            }
            if ((abstractTexture = (textureManager = class_310.method_1551().method_1531()).method_4619(textureLocation)) instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)abstractTexture;
                class_1011 image = dynamicTexture.method_4525();
                if (image != null) {
                    SkinModel model = SkinModelDetector.detectSkinModel(image);
                    LOGGER.info("Detected {} skin from DynamicTexture for texture: {}", (Object)model, (Object)textureLocation);
                    DETECTION_CACHE.put(textureLocation, model);
                    return model;
                }
            } else if (abstractTexture instanceof class_1046) {
                class_1046 httpTexture = (class_1046)abstractTexture;
                try {
                    Field textureImageField = class_1046.class.getDeclaredField("textureImage");
                    textureImageField.setAccessible(true);
                    class_1011 image = (class_1011)textureImageField.get(httpTexture);
                    if (image != null) {
                        SkinModel model = SkinModelDetector.detectSkinModel(image);
                        LOGGER.info("Detected {} skin from HttpTexture for texture: {}", (Object)model, (Object)textureLocation);
                        DETECTION_CACHE.put(textureLocation, model);
                        return model;
                    }
                }
                catch (Exception reflectionEx) {
                    LOGGER.debug("Could not access HttpTexture image via reflection: {}", (Object)reflectionEx.getMessage());
                }
            }
            try {
                InputStream inputStream = ((class_3298)class_310.method_1551().method_1478().method_14486(textureLocation).orElseThrow()).method_14482();
                class_1011 image = class_1011.method_4309((InputStream)inputStream);
                SkinModel model = SkinModelDetector.detectSkinModel(image);
                image.close();
                inputStream.close();
                LOGGER.info("Detected {} skin for texture: {}", (Object)model, (Object)textureLocation);
                DETECTION_CACHE.put(textureLocation, model);
                return model;
            }
            catch (Exception resourceException) {
                LOGGER.warn("Could not load texture from resource manager: {}", (Object)resourceException.getMessage());
                LOGGER.warn("Could not detect skin model, defaulting to CLASSIC");
                DETECTION_CACHE.put(textureLocation, SkinModel.CLASSIC);
                return SkinModel.CLASSIC;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to detect skin model from texture: {}", (Object)textureLocation, (Object)e);
            DETECTION_CACHE.put(textureLocation, SkinModel.CLASSIC);
            return SkinModel.CLASSIC;
        }
    }

    public static SkinModel detectSkinModel(class_1011 image) {
        int red;
        int green;
        int blue;
        int alpha;
        int rgba;
        int x;
        int y;
        int scale;
        int height;
        if (image == null) {
            return SkinModel.CLASSIC;
        }
        int width = image.method_4307();
        SkinResolution resolution = SkinResolution.fromDimensions(width, height = image.method_4323());
        int n = scale = resolution != null ? resolution.getScale() : 1;
        if (resolution == SkinResolution.LEGACY) {
            return SkinModel.CLASSIC;
        }
        int rightArmX = 54 * scale;
        int rightArmEndX = 56 * scale;
        int rightArmStartY = 20 * scale;
        int rightArmEndY = 32 * scale;
        int leftArmX = 46 * scale;
        int leftArmEndX = 48 * scale;
        int leftArmStartY = 52 * scale;
        int leftArmEndY = 64 * scale;
        int totalPixels = 0;
        int transparentPixels = 0;
        for (y = rightArmStartY; y < rightArmEndY && y < height; ++y) {
            for (x = rightArmX; x < rightArmEndX && x < width; ++x) {
                ++totalPixels;
                rgba = image.method_4315(x, y);
                alpha = rgba >> 24 & 0xFF;
                blue = rgba >> 16 & 0xFF;
                green = rgba >> 8 & 0xFF;
                red = rgba & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        for (y = leftArmStartY; y < leftArmEndY && y < height; ++y) {
            for (x = leftArmX; x < leftArmEndX && x < width; ++x) {
                ++totalPixels;
                rgba = image.method_4315(x, y);
                alpha = rgba >> 24 & 0xFF;
                blue = rgba >> 16 & 0xFF;
                green = rgba >> 8 & 0xFF;
                red = rgba & 0xFF;
                if (alpha >= 10 && (red != 0 || green != 0 || blue != 0)) continue;
                ++transparentPixels;
            }
        }
        if (totalPixels > 0) {
            float transparentRatio = (float)transparentPixels / (float)totalPixels;
            boolean isSlim = transparentRatio > 0.5f;
            LOGGER.debug("Skin model detection: {}% transparent pixels -> {}", (Object)((int)(transparentRatio * 100.0f)), (Object)(isSlim ? "slim" : "classic"));
            return isSlim ? SkinModel.SLIM : SkinModel.CLASSIC;
        }
        return SkinModel.CLASSIC;
    }

    public static enum SkinModel {
        CLASSIC,
        SLIM;

    }

    public static enum SkinResolution {
        LEGACY(64, 32, 1),
        STANDARD(64, 64, 1),
        HD_128(128, 64, 2),
        HD_256(256, 128, 4),
        HD_512(512, 256, 8),
        HD_1024(1024, 512, 16),
        HD_2048(2048, 1024, 32);

        private final int width;
        private final int height;
        private final int scale;

        private SkinResolution(int width, int height, int scale) {
            this.width = width;
            this.height = height;
            this.scale = scale;
        }

        public int getScale() {
            return this.scale;
        }

        public static SkinResolution fromDimensions(int width, int height) {
            for (SkinResolution res : SkinResolution.values()) {
                if (res.width != width || res.height != height) continue;
                return res;
            }
            return null;
        }
    }
}

