/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.crafting;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.capsawimtacticalgearrework.crafting.CraftingRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArmorRecipes {
    private static final List<CraftingRecipe> ALL_RECIPES = new ArrayList<CraftingRecipe>();
    private static final Map<String, List<CraftingRecipe>> RECIPE_CATEGORIES = new LinkedHashMap<String, List<CraftingRecipe>>();

    private static void initCategories() {
        RECIPE_CATEGORIES.put("kbs_strelok", new ArrayList());
        RECIPE_CATEGORIES.put("kz1_strelok", new ArrayList());
        RECIPE_CATEGORIES.put("morpeh", new ArrayList());
        RECIPE_CATEGORIES.put("multicam", new ArrayList());
        RECIPE_CATEGORIES.put("modules", new ArrayList());
        RECIPE_CATEGORIES.put("glasses", new ArrayList());
        RECIPE_CATEGORIES.put("balaclavas", new ArrayList());
        RECIPE_CATEGORIES.put("backpacks", new ArrayList());
        RECIPE_CATEGORIES.put("uniforms", new ArrayList());
        RECIPE_CATEGORIES.put("tarkov", new ArrayList());
        RECIPE_CATEGORIES.put("caps", new ArrayList());
    }

    private static void initRecipes() {
        ArmorRecipes.addRecipe("kbs_strelok", CraftingRecipe.createRecipe("svdartwostrelok_helmet", new ItemStack((ItemLike)Items.f_42401_), 16, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42415_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("kbs_strelok", CraftingRecipe.createRecipe("ak_1strelokfull_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("kbs_strelok", CraftingRecipe.createRecipe("ak_1strelokfull_leggings", new ItemStack((ItemLike)Items.f_42401_), 24, new ItemStack((ItemLike)Items.f_41870_), 3, new ItemStack((ItemLike)Items.f_42415_), 3, new ItemStack((ItemLike)Items.f_42416_), 36, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("kz1_strelok", CraftingRecipe.createRecipe("kzonesvdartwokbsstrelok_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("kz1_strelok", CraftingRecipe.createRecipe("kzoneakonestrelok_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("kz1_strelok", CraftingRecipe.createRecipe("kzoneakonestrelok_leggings", new ItemStack((ItemLike)Items.f_42401_), 12, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 18, new ItemStack((ItemLike)Items.f_42413_), 9, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("morpeh", CraftingRecipe.createRecipe("monemorpeh_helmet", new ItemStack((ItemLike)Items.f_42401_), 16, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42415_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("morpeh", CraftingRecipe.createRecipe("morpehakone_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("morpeh", CraftingRecipe.createRecipe("morpehakone_leggings", new ItemStack((ItemLike)Items.f_41870_), 3, new ItemStack((ItemLike)Items.f_42415_), 3, new ItemStack((ItemLike)Items.f_42416_), 36, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("multicam", CraftingRecipe.createRecipe("kzonemulticamsvdartwo_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("multicam", CraftingRecipe.createRecipe("kzonemulticamakone_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("multicam", CraftingRecipe.createRecipe("kzonemulticamakone_leggings", new ItemStack((ItemLike)Items.f_42401_), 12, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 18, new ItemStack((ItemLike)Items.f_42413_), 9, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("bootsone_boots", new ItemStack((ItemLike)Items.f_42401_), 4, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 2));
        ArmorRecipes.addRecipe("modules", CraftingRecipe.createRecipe("nvgmodule", new ItemStack((ItemLike)Items.f_42545_), 4, new ItemStack((ItemLike)Items.f_42451_), 16, new ItemStack((ItemLike)Items.f_151052_), 1, new ItemStack((ItemLike)Items.f_42416_), 4));
        ArmorRecipes.addRecipe("modules", CraftingRecipe.createRecipe("gasmaskmodule", new ItemStack((ItemLike)Items.f_41902_), 2, new ItemStack((ItemLike)Items.f_42413_), 10, new ItemStack((ItemLike)Items.f_42027_), 2, new ItemStack((ItemLike)Items.f_42416_), 6));
        ArmorRecipes.addRecipe("glasses", CraftingRecipe.createRecipe("tacticalglasses", new ItemStack((ItemLike)Items.f_42027_), 2));
        ArmorRecipes.addRecipe("glasses", CraftingRecipe.createRecipe("tacticalglasseswithoutrim", new ItemStack((ItemLike)Items.f_42027_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("atacs_balaclava", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("multicam_balaclava", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42536_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("blackbalaclava", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("blackskullbalaclava", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42490_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("whitearafatka", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1, new ItemStack((ItemLike)Items.f_42535_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("brownarafatka", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("balaclavas", CraftingRecipe.createRecipe("greenarafatka", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("greentacticalbackpack", new ItemStack((ItemLike)Items.f_42401_), 12, new ItemStack((ItemLike)Items.f_41870_), 3, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("blacktacticalbackpack", new ItemStack((ItemLike)Items.f_42401_), 12, new ItemStack((ItemLike)Items.f_41870_), 3, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("greenhikingbackpack", new ItemStack((ItemLike)Items.f_42401_), 24, new ItemStack((ItemLike)Items.f_41870_), 6, new ItemStack((ItemLike)Items.f_42416_), 2, new ItemStack((ItemLike)Items.f_42496_), 2));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("multicamhikingbackpack", new ItemStack((ItemLike)Items.f_42401_), 24, new ItemStack((ItemLike)Items.f_41870_), 6, new ItemStack((ItemLike)Items.f_42416_), 2, new ItemStack((ItemLike)Items.f_42536_), 2));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("urbanahikingbackpack", new ItemStack((ItemLike)Items.f_42401_), 24, new ItemStack((ItemLike)Items.f_41870_), 6, new ItemStack((ItemLike)Items.f_42416_), 2, new ItemStack((ItemLike)Items.f_42498_), 1, new ItemStack((ItemLike)Items.f_42535_), 1));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("blackhikingbackpack", new ItemStack((ItemLike)Items.f_42401_), 24, new ItemStack((ItemLike)Items.f_41870_), 6, new ItemStack((ItemLike)Items.f_42416_), 2, new ItemStack((ItemLike)Items.f_42498_), 2));
        ArmorRecipes.addRecipe("backpacks", CraftingRecipe.createRecipe("sportsbag", new ItemStack((ItemLike)Items.f_42401_), 12, new ItemStack((ItemLike)Items.f_41870_), 3, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("greenuniform", new ItemStack((ItemLike)Items.f_42401_), 9, new ItemStack((ItemLike)Items.f_41870_), 5, new ItemStack((ItemLike)Items.f_42496_), 4));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("atacsuniform", new ItemStack((ItemLike)Items.f_42401_), 9, new ItemStack((ItemLike)Items.f_41870_), 5, new ItemStack((ItemLike)Items.f_42496_), 2, new ItemStack((ItemLike)Items.f_42539_), 2));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("gorka_uniform", new ItemStack((ItemLike)Items.f_42401_), 9, new ItemStack((ItemLike)Items.f_41870_), 5, new ItemStack((ItemLike)Items.f_42539_), 2, new ItemStack((ItemLike)Items.f_42495_), 2));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("grayurbana", new ItemStack((ItemLike)Items.f_42401_), 9, new ItemStack((ItemLike)Items.f_41870_), 5, new ItemStack((ItemLike)Items.f_42535_), 2, new ItemStack((ItemLike)Items.f_42490_), 2));
        ArmorRecipes.addRecipe("uniforms", CraftingRecipe.createRecipe("sportsuniform", new ItemStack((ItemLike)Items.f_42401_), 9, new ItemStack((ItemLike)Items.f_41870_), 5, new ItemStack((ItemLike)Items.f_42498_), 2, new ItemStack((ItemLike)Items.f_42535_), 2));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovtree", new ItemStack((ItemLike)Items.f_42401_), 3, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovsix", new ItemStack((ItemLike)Items.f_42401_), 3, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovseven", new ItemStack((ItemLike)Items.f_42401_), 3, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovone_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovone_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovtwo_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovtwo_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovfour_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovfour_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovnine_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovten_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovten_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("fsbalpha_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("fsbalpha_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("fsbalpha_leggings", new ItemStack((ItemLike)Items.f_42401_), 6, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("goonbigpipe_chestplate", new ItemStack((ItemLike)Items.f_42401_), 18, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 12, new ItemStack((ItemLike)Items.f_42495_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("goonknight_helmet", new ItemStack((ItemLike)Items.f_42401_), 8, new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42416_), 12, new ItemStack((ItemLike)Items.f_42413_), 6, new ItemStack((ItemLike)Items.f_42495_), 1, new ItemStack((ItemLike)Items.f_42678_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("goonknight_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkov_f_ive_helmet", new ItemStack((ItemLike)Items.f_42401_), 16, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42415_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkov_f_ive_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovtwoone_helmet", new ItemStack((ItemLike)Items.f_42401_), 16, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42415_), 2, new ItemStack((ItemLike)Items.f_42416_), 24, new ItemStack((ItemLike)Items.f_42413_), 36, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkovtwoone_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("tarkoveight_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42539_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("russpecnazold_helmet", new ItemStack((ItemLike)Items.f_42401_), 16, new ItemStack((ItemLike)Items.f_41870_), 2, new ItemStack((ItemLike)Items.f_42415_), 2, new ItemStack((ItemLike)Items.f_42416_), 36, new ItemStack((ItemLike)Items.f_42413_), 42, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("tarkov", CraftingRecipe.createRecipe("russpecnazold_chestplate", new ItemStack((ItemLike)Items.f_42401_), 36, new ItemStack((ItemLike)Items.f_41870_), 4, new ItemStack((ItemLike)Items.f_42415_), 4, new ItemStack((ItemLike)Items.f_42416_), 48, new ItemStack((ItemLike)Items.f_42413_), 48, new ItemStack((ItemLike)Items.f_42496_), 1, new ItemStack((ItemLike)Items.f_42495_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("capblack_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("capblackwh_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42498_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("caphaki_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("caphakiwh_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42539_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("capolive_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
        ArmorRecipes.addRecipe("caps", CraftingRecipe.createRecipe("capolivewh_helmet", new ItemStack((ItemLike)Items.f_41870_), 1, new ItemStack((ItemLike)Items.f_42496_), 1));
    }

    private static void addRecipe(String category, CraftingRecipe recipe) {
        ALL_RECIPES.add(recipe);
        RECIPE_CATEGORIES.get(category).add(recipe);
    }

    public static List<CraftingRecipe> getAllRecipes() {
        return new ArrayList<CraftingRecipe>(ALL_RECIPES);
    }

    public static List<String> getCategories() {
        return new ArrayList<String>(RECIPE_CATEGORIES.keySet());
    }

    public static List<CraftingRecipe> getRecipesByCategory(String category) {
        return new ArrayList<CraftingRecipe>(RECIPE_CATEGORIES.getOrDefault(category, new ArrayList()));
    }

    public static CraftingRecipe findRecipeByResult(String resultId) {
        String itemId = resultId;
        if (resultId.contains(":")) {
            itemId = resultId.substring(resultId.indexOf(":") + 1);
        }
        for (CraftingRecipe recipe : ALL_RECIPES) {
            String recipeItemId = recipe.getResult().m_41720_().toString();
            if (recipeItemId.contains(":")) {
                recipeItemId = recipeItemId.substring(recipeItemId.indexOf(":") + 1);
            }
            if (!recipeItemId.equals(itemId)) continue;
            return recipe;
        }
        return null;
    }

    static {
        ArmorRecipes.initCategories();
        ArmorRecipes.initRecipes();
    }
}

