/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.network;

import java.util.function.Supplier;
import net.mcreator.capsawimtacticalgearrework.procedures.ChangeArmorStyleProcedure;
import net.mcreator.capsawimtacticalgearrework.world.inventory.ArmorCustomizationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ApplyArmorStyleMessage {
    private final BlockPos pos;
    private final int styleIndex;

    public ApplyArmorStyleMessage(BlockPos pos, int styleIndex) {
        this.pos = pos;
        this.styleIndex = styleIndex;
    }

    public static void encode(ApplyArmorStyleMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeInt(message.styleIndex);
    }

    public static ApplyArmorStyleMessage decode(FriendlyByteBuf buffer) {
        return new ApplyArmorStyleMessage(buffer.m_130135_(), buffer.readInt());
    }

    public static void handle(ApplyArmorStyleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (!context.getDirection().getReceptionSide().isServer()) {
                return;
            }
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1581$temp = player.f_36096_;
            if (patt1581$temp instanceof ArmorCustomizationMenu) {
                String protectionClass;
                String family;
                ItemStack newArmor;
                ArmorCustomizationMenu menu = (ArmorCustomizationMenu)patt1581$temp;
                if (!menu.pos.equals((Object)message.pos)) {
                    return;
                }
                ItemStack armor = menu.getArmorItem();
                if (!armor.m_41619_() && !(newArmor = ChangeArmorStyleProcedure.changeArmorStyle(armor, message.styleIndex, family = menu.getCurrentFamily(), protectionClass = menu.getCurrentProtectionClass())).m_41619_()) {
                    menu.getArmorHandler().setStackInSlot(0, newArmor);
                    String styleName = ChangeArmorStyleProcedure.getStyleName(message.styleIndex);
                    player.m_5661_((Component)Component.m_237113_((String)("\u00a7a\u0421\u0442\u0438\u043b\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430: " + styleName)), true);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

