/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.capsawimtacticalgearrework.crafting.CraftingRecipe;
import net.mcreator.capsawimtacticalgearrework.init.CapsAwimTacticalGearReworkModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ArmorCraftingMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    public final BlockPos pos;
    public final Player player;
    public final Level world;
    private ItemStackHandler resultHandler = new ItemStackHandler(1);
    private ItemStackHandler repairHandler = new ItemStackHandler(1);
    private int scrollOffset = 0;
    private CraftingRecipe selectedRecipe = null;
    private static final int RESULT_SLOT_X = 15;
    private static final int RESULT_SLOT_Y = 50;
    private static final int REPAIR_SLOT_X = 15;
    private static final int REPAIR_SLOT_Y = 86;

    private boolean isModArmor(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41720_().getCreatorModId(stack).equals("caps_awim_tactical_gear_rework");
    }

    public ArmorCraftingMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public ArmorCraftingMenu(int id, Inventory inv, BlockEntity entity) {
        super((MenuType)CapsAwimTacticalGearReworkModMenus.ARMOR_CRAFTING.get(), id);
        this.player = inv.f_35978_;
        this.world = inv.f_35978_.m_9236_();
        this.pos = entity != null ? entity.m_58899_() : BlockPos.f_121853_;
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.resultHandler, 0, 15, 50){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return ArmorCraftingMenu.this.selectedRecipe != null && ArmorCraftingMenu.this.selectedRecipe.canCraft(player.m_150109_());
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (ArmorCraftingMenu.this.selectedRecipe != null && ArmorCraftingMenu.this.selectedRecipe.canCraft(player.m_150109_())) {
                    ArmorCraftingMenu.this.selectedRecipe.consumeIngredients(player.m_150109_());
                    ArmorCraftingMenu.this.updateCraftResult();
                    ItemStack slotStack = this.m_7993_();
                    slotStack.m_41774_(1);
                    if (slotStack.m_41619_()) {
                        this.m_5852_(ItemStack.f_41583_);
                    } else {
                        this.m_5852_(slotStack);
                    }
                }
            }

            public ItemStack m_150647_(int pAmount, int pMaximum, Player player) {
                int amountToTake = Math.min(1, pAmount);
                return super.m_150647_(amountToTake, pMaximum, player);
            }

            public ItemStack m_150659_(ItemStack stack) {
                return stack;
            }

            public ItemStack m_6201_(int amount) {
                int amountToRemove = Math.min(1, amount);
                ItemStack removed = super.m_6201_(amountToRemove);
                if (ArmorCraftingMenu.this.selectedRecipe != null && ArmorCraftingMenu.this.selectedRecipe.canCraft(ArmorCraftingMenu.this.player.m_150109_()) && !removed.m_41619_()) {
                    ArmorCraftingMenu.this.selectedRecipe.consumeIngredients(ArmorCraftingMenu.this.player.m_150109_());
                    ArmorCraftingMenu.this.updateCraftResult();
                }
                return removed;
            }

            public int m_6641_() {
                return 1;
            }

            public int m_5866_(ItemStack stack) {
                return 1;
            }
        }));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.repairHandler, 0, 15, 86){

            public boolean m_5857_(ItemStack stack) {
                return ArmorCraftingMenu.this.isModArmor(stack) && stack.m_41763_();
            }

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                ArmorCraftingMenu.this.m_38946_();
            }

            public boolean m_280329_() {
                return true;
            }
        }));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18 + 50));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 192));
        }
        this.updateCraftResult();
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public void repairArmor(Player player) {
        int repairCost;
        ItemStack armorToRepair = this.repairHandler.getStackInSlot(0);
        if (!armorToRepair.m_41619_() && armorToRepair.m_41768_() && this.isModArmor(armorToRepair) && this.hasRepairResources(player, repairCost = this.calculateRepairCost(armorToRepair))) {
            this.consumeRepairResources(player, repairCost);
            armorToRepair.m_41721_(0);
            this.repairHandler.setStackInSlot(0, armorToRepair);
            this.m_38946_();
        }
    }

    private int calculateRepairCost(ItemStack armor) {
        if (armor.m_41619_() || !this.isModArmor(armor)) {
            return 0;
        }
        float damageRatio = (float)armor.m_41773_() / (float)armor.m_41776_();
        int baseCost = 5;
        int enchantmentCost = 0;
        if (EnchantmentHelper.m_44920_((ItemStack)armor)) {
            enchantmentCost += 2;
        }
        if (armor.m_41793_()) {
            enchantmentCost += armor.getAllEnchantments().size();
        }
        int totalCost = (int)Math.ceil((float)baseCost * damageRatio) + enchantmentCost;
        return Math.max(1, totalCost);
    }

    private boolean hasRepairResources(Player player, int ironNeeded) {
        Inventory inventory = player.m_150109_();
        int ironCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42416_ || (ironCount += stack.m_41613_()) < ironNeeded) continue;
            return true;
        }
        return ironCount >= ironNeeded;
    }

    private void consumeRepairResources(Player player, int ironNeeded) {
        Inventory inventory = player.m_150109_();
        int remaining = ironNeeded;
        for (int i = 0; i < inventory.m_6643_() && remaining > 0; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42416_) continue;
            int toTake = Math.min(stack.m_41613_(), remaining);
            stack.m_41774_(toTake);
            remaining -= toTake;
            if (!stack.m_41619_()) continue;
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public ItemStack getArmorToRepair() {
        return this.repairHandler.getStackInSlot(0);
    }

    public int getRepairCost() {
        ItemStack armor = this.getArmorToRepair();
        if (armor.m_41619_() || !armor.m_41768_() || !this.isModArmor(armor)) {
            return 0;
        }
        return this.calculateRepairCost(armor);
    }

    public boolean canRepair() {
        ItemStack armor = this.getArmorToRepair();
        if (armor.m_41619_() || !armor.m_41768_() || !this.isModArmor(armor)) {
            return false;
        }
        return this.hasRepairResources(this.player, this.getRepairCost());
    }

    public boolean hasIronInInventory() {
        Inventory inventory = this.player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42416_) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (this.selectedRecipe != null && this.selectedRecipe.canCraft(player.m_150109_())) {
                    this.selectedRecipe.consumeIngredients(player.m_150109_());
                    this.updateCraftResult();
                    ItemStack singleResult = this.selectedRecipe.getResult().m_41777_();
                    singleResult.m_41764_(1);
                    if (!this.m_38903_(singleResult, 2, 38, true)) {
                        return ItemStack.f_41583_;
                    }
                    itemstack1.m_41774_(1);
                    if (itemstack1.m_41619_()) {
                        slot.m_5852_(ItemStack.f_41583_);
                    } else {
                        slot.m_6654_();
                    }
                    slot.m_40234_(singleResult, itemstack);
                    return singleResult;
                }
                return ItemStack.f_41583_;
            }
            if (index == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 2 && index < 29 ? (this.isModArmor(itemstack1) && itemstack1.m_41763_() ? !this.m_38903_(itemstack1, 1, 2, false) : !this.m_38903_(itemstack1, 29, 38, false)) : index >= 29 && index < 38 && (this.isModArmor(itemstack1) && itemstack1.m_41763_() ? !this.m_38903_(itemstack1, 1, 2, false) : !this.m_38903_(itemstack1, 2, 29, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        this.updateCraftResult();
        return itemstack;
    }

    public void setScrollOffset(int offset) {
        this.scrollOffset = offset;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void selectRecipe(CraftingRecipe recipe) {
        this.selectedRecipe = recipe;
        this.updateCraftResult();
    }

    public CraftingRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    private void updateCraftResult() {
        if (this.selectedRecipe != null && this.selectedRecipe.canCraft(this.player.m_150109_())) {
            this.resultHandler.setStackInSlot(0, this.selectedRecipe.getResult().m_41777_());
        } else {
            this.resultHandler.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

