/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.capsawimtacticalgearrework.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.capsawimtacticalgearrework.block.entity.SustomizationtableTileEntity;
import net.mcreator.capsawimtacticalgearrework.init.CapsAwimTacticalGearReworkModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorCustomizationMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    public final BlockPos pos;
    public final Player player;
    public final Level world;
    private final ItemStackHandler armorHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ArmorCustomizationMenu.this.updateArmorInfo();
            ArmorCustomizationMenu.this.m_38946_();
        }
    };
    private String currentFamily = "";
    private String currentProtectionClass = "";
    private boolean needsGUIUpdate = false;
    private ItemStack lastArmorStack = ItemStack.f_41583_;

    public ArmorCustomizationMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public ArmorCustomizationMenu(int id, Inventory inv, BlockEntity entity) {
        super((MenuType)CapsAwimTacticalGearReworkModMenus.ARMOR_CUSTOMIZATION.get(), id);
        this.player = inv.f_35978_;
        this.world = inv.f_35978_.m_9236_();
        this.pos = entity != null ? entity.m_58899_() : BlockPos.f_121853_;
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.armorHandler, 0, 88, 33){

            public boolean m_5857_(ItemStack stack) {
                return ArmorCustomizationMenu.this.isCustomizableArmor(stack);
            }

            public void m_6654_() {
                super.m_6654_();
                ArmorCustomizationMenu.this.updateArmorInfo();
                ArmorCustomizationMenu.this.m_6199_(this.f_40218_);
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                ArmorCustomizationMenu.this.updateArmorInfo();
                ArmorCustomizationMenu.this.needsGUIUpdate = true;
            }

            public void m_5852_(ItemStack stack) {
                super.m_5852_(stack);
                ArmorCustomizationMenu.this.updateArmorInfo();
                ArmorCustomizationMenu.this.needsGUIUpdate = true;
            }
        }));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)inv, col, 8 + col * 18, 142));
        }
        if (entity != null) {
            this.loadArmorFromBlockEntity(entity);
        }
        this.lastArmorStack = this.armorHandler.getStackInSlot(0).m_41777_();
    }

    private void loadArmorFromBlockEntity(BlockEntity entity) {
        try {
            ItemStack savedArmor;
            if (entity.m_187482_().m_128441_("ArmorItem") && !(savedArmor = ItemStack.m_41712_((CompoundTag)entity.m_187482_().m_128469_("ArmorItem"))).m_41619_()) {
                this.armorHandler.setStackInSlot(0, savedArmor.m_41777_());
                this.updateArmorInfo();
                this.needsGUIUpdate = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateArmorInfo() {
        boolean protectionChanged;
        ItemStack armor = this.armorHandler.getStackInSlot(0);
        boolean armorChanged = !ItemStack.m_41728_((ItemStack)armor, (ItemStack)this.lastArmorStack);
        this.lastArmorStack = armor.m_41777_();
        if (armor.m_41619_()) {
            if (!this.currentFamily.isEmpty() || !this.currentProtectionClass.isEmpty()) {
                this.currentFamily = "";
                this.currentProtectionClass = "";
                this.saveArmorToBlockEntity();
                this.needsGUIUpdate = true;
            }
            return;
        }
        String itemId = ForgeRegistries.ITEMS.getKey((Object)armor.m_41720_()).toString().toLowerCase();
        String newFamily = "";
        String newProtectionClass = "";
        if (itemId.contains("strelok") || itemId.contains("gunslinger")) {
            newFamily = "strelok";
        } else if (itemId.contains("morpeh") || itemId.contains("orpeh")) {
            newFamily = "morpeh";
        } else if (itemId.contains("multicam")) {
            newFamily = "multicam";
        }
        newProtectionClass = itemId.contains("kz1") || itemId.contains("kzone") || itemId.contains("kzm") ? "kz1" : (itemId.contains("kz2") ? "kz2" : "kz2");
        boolean familyChanged = !newFamily.equals(this.currentFamily);
        boolean bl = protectionChanged = !newProtectionClass.equals(this.currentProtectionClass);
        if (armorChanged || familyChanged || protectionChanged) {
            this.currentFamily = newFamily;
            this.currentProtectionClass = newProtectionClass;
            this.saveArmorToBlockEntity();
            this.needsGUIUpdate = true;
        }
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        this.updateArmorInfo();
        this.needsGUIUpdate = true;
    }

    public boolean hasArmorChanged() {
        ItemStack current = this.armorHandler.getStackInSlot(0);
        return this.needsGUIUpdate || !ItemStack.m_41728_((ItemStack)current, (ItemStack)this.lastArmorStack);
    }

    public void markAsUpdated() {
        this.needsGUIUpdate = false;
        this.lastArmorStack = this.armorHandler.getStackInSlot(0).m_41777_();
    }

    private void saveArmorToBlockEntity() {
        BlockEntity entity;
        if (this.world != null && this.pos != null && !this.world.m_5776_() && (entity = this.world.m_7702_(this.pos)) instanceof SustomizationtableTileEntity) {
            SustomizationtableTileEntity tileEntity = (SustomizationtableTileEntity)entity;
            ItemStack armor = this.armorHandler.getStackInSlot(0);
            tileEntity.setArmorItem(armor.m_41619_() ? ItemStack.f_41583_ : armor.m_41777_());
            tileEntity.m_6596_();
        }
    }

    private boolean isCustomizableArmor(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString().toLowerCase();
        return (itemId.contains("strelok") || itemId.contains("gunslinger") || itemId.contains("morpeh") || itemId.contains("kzmo") || itemId.contains("kzmt") || itemId.contains("multicam")) && itemId.contains("chestplate");
    }

    public String getCurrentFamily() {
        return this.currentFamily;
    }

    public String getCurrentProtectionClass() {
        return this.currentProtectionClass;
    }

    public ItemStack getArmorItem() {
        return this.armorHandler.getStackInSlot(0).m_41777_();
    }

    public ItemStackHandler getArmorHandler() {
        return this.armorHandler;
    }

    public String[] getAvailableStyles() {
        if (this.currentFamily.isEmpty() || this.currentProtectionClass.isEmpty()) {
            return new String[0];
        }
        if (this.currentFamily.equals("strelok") && this.currentProtectionClass.equals("kz2")) {
            return new String[]{"AK-1", "AK-2", "M-1", "M-2", "\u0421\u0412\u0414-AR-1", "\u0421\u0412\u0414-AR-2"};
        }
        if (this.currentFamily.equals("strelok") && this.currentProtectionClass.equals("kz1")) {
            return new String[]{"AK-1", "AK-2", "\u0421\u0412\u0414-AR-1", "\u0421\u0412\u0414-AR-2", "M-1", "M-2"};
        }
        if (this.currentFamily.equals("morpeh") && this.currentProtectionClass.equals("kz2")) {
            return new String[]{"M-1", "M-2", "AK-1", "AK-2", "\u0421\u0412\u0414-AR-1", "\u0421\u0412\u0414-AR-2"};
        }
        if ((this.currentFamily.equals("morpeh") || this.currentFamily.equals("multicam")) && this.currentProtectionClass.equals("kz1")) {
            return new String[]{"M-1", "M-2", "AK-1", "AK-2", "\u0421\u0412\u0414-AR-1", "\u0421\u0412\u0414-AR-2"};
        }
        return new String[0];
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.saveArmorToBlockEntity();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (this.isCustomizableArmor(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (index < 28 ? !this.m_38903_(itemstack1, 28, 37, false) : index < 37 && !this.m_38903_(itemstack1, 1, 28, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

