/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import com.leclowndu93150.particular.utils.IrisCompat;
import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ParticularConfig {
    public static final CommonConfig COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    public static boolean waterSplash() {
        return (Boolean)ParticularConfig.COMMON.waterSplash.get();
    }

    public static boolean cascades() {
        return (Boolean)ParticularConfig.COMMON.cascades.get();
    }

    public static boolean waterfallSpray() {
        return (Boolean)ParticularConfig.COMMON.waterfallSpray.get();
    }

    public static boolean fireflies() {
        return (Boolean)ParticularConfig.COMMON.fireflies.get();
    }

    public static boolean fallingLeaves() {
        return (Boolean)ParticularConfig.COMMON.fallingLeaves.get();
    }

    public static boolean caveDust() {
        return (Boolean)ParticularConfig.COMMON.caveDust.get();
    }

    public static boolean chestBubbles() {
        return (Boolean)ParticularConfig.COMMON.chestBubbles.get();
    }

    public static boolean soulSandBubbles() {
        return (Boolean)ParticularConfig.COMMON.soulSandBubbles.get();
    }

    public static boolean barrelBubbles() {
        return (Boolean)ParticularConfig.COMMON.barrelBubbles.get();
    }

    public static boolean poppingBubbles() {
        return (Boolean)ParticularConfig.COMMON.poppingBubbles.get();
    }

    public static boolean cakeEatingParticles() {
        return (Boolean)ParticularConfig.COMMON.cakeEatingParticles.get();
    }

    public static boolean emissiveLavaDrips() {
        return (Boolean)ParticularConfig.COMMON.emissiveLavaDrips.get();
    }

    public static boolean rainRipples() {
        if (IrisCompat.areShadersEnabled()) {
            return false;
        }
        return (Boolean)ParticularConfig.COMMON.rainRipples.get();
    }

    public static boolean waterDripRipples() {
        if (IrisCompat.areShadersEnabled()) {
            return false;
        }
        return (Boolean)ParticularConfig.COMMON.waterDripRipples.get();
    }

    public static List<Identifier> getCaveDustExcludeBiomes() {
        return ((List)ParticularConfig.COMMON.caveDustExcludeBiomes.get()).stream().map(Identifier::parse).toList();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
    }

    public static class CommonConfig {
        public final ModConfigSpec.BooleanValue waterSplash;
        public final ModConfigSpec.BooleanValue cascades;
        public final ModConfigSpec.BooleanValue waterfallSpray;
        public final ModConfigSpec.BooleanValue fireflies;
        public final ModConfigSpec.BooleanValue fallingLeaves;
        public final ModConfigSpec.BooleanValue caveDust;
        public final ModConfigSpec.BooleanValue chestBubbles;
        public final ModConfigSpec.BooleanValue soulSandBubbles;
        public final ModConfigSpec.BooleanValue barrelBubbles;
        public final ModConfigSpec.BooleanValue poppingBubbles;
        public final ModConfigSpec.BooleanValue rainRipples;
        public final ModConfigSpec.BooleanValue waterDripRipples;
        public final ModConfigSpec.BooleanValue cakeEatingParticles;
        public final ModConfigSpec.BooleanValue emissiveLavaDrips;
        public final ModConfigSpec.IntValue fireflyStartTime;
        public final ModConfigSpec.IntValue fireflyEndTime;
        public final ModConfigSpec.DoubleValue fireflyMinTemp;
        public final ModConfigSpec.DoubleValue fireflyMaxTemp;
        public final ModConfigSpec.BooleanValue fireflyCanSpawnInRain;
        public final ModConfigSpec.ConfigValue<List<? extends Double>> fireflyDailyRandom;
        public final ModConfigSpec.DoubleValue fireflyGrassFrequency;
        public final ModConfigSpec.DoubleValue fireflyTallGrassFrequency;
        public final ModConfigSpec.DoubleValue fireflyFlowersFrequency;
        public final ModConfigSpec.DoubleValue fireflyTallFlowersFrequency;
        public final ModConfigSpec.IntValue fallingLeavesSpawnChance;
        public final ModConfigSpec.BooleanValue fallingLeavesSpawnRipples;
        public final ModConfigSpec.BooleanValue fallingLeavesLayFlatOnGround;
        public final ModConfigSpec.BooleanValue fallingLeavesLayFlatRightAngles;
        public final ModConfigSpec.DoubleValue waterSplashMinFallDistance;
        public final ModConfigSpec.BooleanValue waterSplashSmallDroplets;
        public final ModConfigSpec.IntValue caveDustSpawnChance;
        public final ModConfigSpec.IntValue caveDustBaseMaxAge;
        public final ModConfigSpec.IntValue caveDustColor;
        public final ModConfigSpec.IntValue caveDustFadeDuration;
        public final ModConfigSpec.DoubleValue caveDustMaxAcceleration;
        public final ModConfigSpec.IntValue caveDustAccelChangeChance;
        public final ModConfigSpec.ConfigValue<List<? extends String>> caveDustExcludeBiomes;

        CommonConfig(ModConfigSpec.Builder builder) {
            builder.comment("Particular Mod Configuration").push("general");
            builder.comment("Enable/Disable Effects").push("enabledEffects");
            this.waterSplash = builder.comment("Enable water splash particles").define("waterSplash", true);
            this.cascades = builder.comment("Enable cascade particles").define("cascades", true);
            this.waterfallSpray = builder.comment("Enable waterfall spray particles").define("waterfallSpray", true);
            this.fireflies = builder.comment("Enable firefly particles").define("fireflies", true);
            this.fallingLeaves = builder.comment("Enable falling leaves particles").define("fallingLeaves", true);
            this.caveDust = builder.comment("Enable cave dust particles").define("caveDust", true);
            this.chestBubbles = builder.comment("Enable chest bubbles").define("chestBubbles", true);
            this.soulSandBubbles = builder.comment("Enable soul sand bubbles").define("soulSandBubbles", true);
            this.barrelBubbles = builder.comment("Enable barrel bubbles").define("barrelBubbles", true);
            this.poppingBubbles = builder.comment("Enable popping bubbles").define("poppingBubbles", true);
            this.rainRipples = builder.comment("Enable rain ripples").define("rainRipples", true);
            this.waterDripRipples = builder.comment("Enable water drip ripples").define("waterDripRipples", true);
            this.cakeEatingParticles = builder.comment("Enable cake eating particles").define("cakeEatingParticles", true);
            this.emissiveLavaDrips = builder.comment("Enable emissive lava drips").define("emissiveLavaDrips", true);
            builder.pop();
            builder.comment("Advanced Particle Settings").push("advancedSettings");
            builder.push("fireflySettings");
            this.fireflyStartTime = builder.comment("Time when fireflies start spawning").defineInRange("startTime", 12000, 0, 23999);
            this.fireflyEndTime = builder.comment("Time when fireflies stop spawning").defineInRange("endTime", 23000, 0, 23999);
            this.fireflyMinTemp = builder.comment("Minimum temperature for fireflies to spawn").defineInRange("minTemp", 0.5, 0.0, 2.0);
            this.fireflyMaxTemp = builder.comment("Maximum temperature for fireflies to spawn").defineInRange("maxTemp", (double)0.99f, 0.0, 2.0);
            this.fireflyCanSpawnInRain = builder.comment("Whether fireflies can spawn in rain").define("canSpawnInRain", false);
            builder.push("frequencyModifiers");
            this.fireflyDailyRandom = builder.comment("Daily random factors for firefly spawning").defineList("dailyRandom", Arrays.asList(0.0, 0.0, 0.0, 0.33, 0.66, 1.0), entry -> entry instanceof Double);
            this.fireflyGrassFrequency = builder.comment("Frequency modifier for grass").defineInRange("grass", 0.16666666666666666, 0.0, 1.0);
            this.fireflyTallGrassFrequency = builder.comment("Frequency modifier for tall grass").defineInRange("tallGrass", 0.08333333333333333, 0.0, 1.0);
            this.fireflyFlowersFrequency = builder.comment("Frequency modifier for flowers").defineInRange("flowers", 1.0, 0.0, 1.0);
            this.fireflyTallFlowersFrequency = builder.comment("Frequency modifier for tall flowers").defineInRange("tallFlowers", 0.5, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("fallingLeavesSettings");
            this.fallingLeavesSpawnChance = builder.comment("Chance of spawning falling leaves (higher = less frequent)").defineInRange("spawnChance", 60, 1, Integer.MAX_VALUE);
            this.fallingLeavesSpawnRipples = builder.comment("Whether falling leaves create ripples when landing on water").define("spawnRipples", true);
            this.fallingLeavesLayFlatOnGround = builder.comment("Whether falling leaves lay flat on the ground").define("layFlatOnGround", true);
            this.fallingLeavesLayFlatRightAngles = builder.comment("Whether falling leaves lay at right angles").define("layFlatRightAngles", false);
            builder.pop();
            builder.push("waterSplashSettings");
            this.waterSplashMinFallDistance = builder.comment("Minimum fall distance (in blocks) required to trigger water splash particles").defineInRange("minFallDistance", 0.0, 0.0, 100.0);
            this.waterSplashSmallDroplets = builder.comment("Whether small splashes should emit water droplet particles").define("smallDroplets", false);
            builder.pop();
            builder.push("caveDustSettings");
            this.caveDustSpawnChance = builder.comment("Chance of spawning cave dust (higher = less frequent)").defineInRange("spawnChance", 700, 1, Integer.MAX_VALUE);
            this.caveDustBaseMaxAge = builder.comment("Base maximum age of cave dust particles").defineInRange("baseMaxAge", 200, 1, Integer.MAX_VALUE);
            this.caveDustColor = builder.comment("Color of cave dust particles (RGB hex)").defineInRange("color", 0x808080, 0, 0xFFFFFF);
            this.caveDustFadeDuration = builder.comment("Duration of fade effect for cave dust particles").defineInRange("fadeDuration", 20, 0, Integer.MAX_VALUE);
            this.caveDustMaxAcceleration = builder.comment("Maximum acceleration of cave dust particles").defineInRange("maxAcceleration", (double)0.03f, 0.0, 1.0);
            this.caveDustAccelChangeChance = builder.comment("Chance of changing acceleration for cave dust particles").defineInRange("accelChangeChance", 180, 1, Integer.MAX_VALUE);
            this.caveDustExcludeBiomes = builder.comment("Biomes where cave dust won't spawn").defineList("excludeBiomes", Arrays.asList("minecraft:lush_caves", "minecraft:dripstone_caves", "minecraft:deep_dark"), entry -> entry instanceof String);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

