/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.mixin;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.ParticularConfig;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.projectile.arrow.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class InjectEntity {
    @Shadow
    private Vec3 deltaMovement;
    @Shadow
    private EntityDimensions dimensions;
    @Shadow
    @Final
    protected RandomSource random;
    @Shadow
    private Level level;
    @Shadow
    private BlockPos blockPosition;
    @Shadow
    public double fallDistance;
    @Unique
    public Queue<Double> velocities = new LinkedList<Double>();
    @Unique
    private double accumulatedFallDistance = 0.0;

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract Vec3 position();

    @Shadow
    public abstract BlockPos blockPosition();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onSetVelocity(CallbackInfo ci) {
        if (!ParticularConfig.waterSplash()) {
            return;
        }
        this.velocities.offer(Math.abs(this.deltaMovement.y()));
        if (this.velocities.size() > 4) {
            this.velocities.poll();
        }
        if (this.deltaMovement.y() < 0.0) {
            this.accumulatedFallDistance += Math.abs(this.deltaMovement.y());
        } else if (this.deltaMovement.y() > 0.0) {
            this.accumulatedFallDistance = 0.0;
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="TAIL")})
    private void waterParticles(CallbackInfo ci) {
        double actualFallDistance;
        if (!ParticularConfig.waterSplash()) {
            return;
        }
        if (this instanceof Arrow || !this.level().isClientSide()) {
            return;
        }
        float baseY = Mth.floor((double)this.getY());
        boolean foundSurface = false;
        FluidState prevState = Fluids.EMPTY.defaultFluidState();
        for (int i = 0; i < 5; ++i) {
            FluidState nextState = this.level().getFluidState(this.blockPosition().offset(0, i, 0));
            if (prevState.is((Fluid)Fluids.WATER) && nextState.is(Fluids.EMPTY)) {
                baseY += (float)(i - 1);
                foundSurface = true;
                break;
            }
            prevState = nextState;
        }
        if (!foundSurface) {
            return;
        }
        double velocityValue = this.velocities.isEmpty() ? 0.0 : Collections.max(this.velocities);
        double d = actualFallDistance = this.fallDistance > 0.0 ? this.fallDistance : this.accumulatedFallDistance;
        if (actualFallDistance < (Double)ParticularConfig.COMMON.waterSplashMinFallDistance.get()) {
            this.accumulatedFallDistance = 0.0;
            return;
        }
        this.accumulatedFallDistance = 0.0;
        this.level().addParticle((ParticleOptions)Particles.WATER_SPLASH_EMITTER(), this.getX(), (double)(baseY + prevState.getOwnHeight()), this.getZ(), (double)this.dimensions.width(), velocityValue, 0.0);
    }
}

