/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class WaterRippleParticle
extends SingleQuadParticle {
    protected final SpriteSet provider;

    protected WaterRippleParticle(ClientLevel world, double x, double y, double z, SpriteSet provider) {
        super(world, x, y, z, provider.get(0, 7));
        this.lifetime = 7;
        this.alpha = 0.2f;
        this.quadSize = 0.25f;
        this.provider = provider;
        this.setSpriteFromAge(provider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.provider);
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void extract(QuadParticleRenderState renderState, Camera camera, float partialTick) {
        Vec3 vec3 = camera.position();
        float x = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        y += 0.01f;
        Quaternionf rotationTop = new Quaternionf();
        rotationTop.rotateX(1.5707964f);
        Quaternionf rotationBottom = new Quaternionf();
        rotationBottom.rotateX(-1.5707964f);
        renderState.add(this.getLayer(), x, y, z, rotationTop.x, rotationTop.y, rotationTop.z, rotationTop.w, this.getQuadSize(partialTick), this.getU0(), this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
        renderState.add(this.getLayer(), x, y, z, rotationBottom.x, rotationBottom.y, rotationBottom.z, rotationBottom.w, this.getQuadSize(partialTick), this.getU0(), this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTick));
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public Factory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velX, double velY, double velZ, RandomSource random) {
            return new WaterRippleParticle(world, x, y, z, this.provider);
        }
    }
}

