/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1163;
import net.minecraft.class_11659;
import net.minecraft.class_11938;
import net.minecraft.class_11942;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.joml.Vector3f;

public class WaterSplashParticle
extends class_703 {
    public static final class_3999 WATER_SPLASH_TYPE = new class_3999("particular:water_splash");
    protected final class_4002 provider;
    private final float width;
    private final float height;
    private final Color color;
    protected boolean colored = true;

    WaterSplashParticle(class_638 clientWorld, double x, double y, double z, float width, float height, class_4002 provider) {
        super(clientWorld, x, y, z);
        this.field_3844 = 0.0f;
        this.field_3847 = 18;
        this.width = width;
        this.height = height;
        this.provider = provider;
        this.color = new Color(class_1163.method_4961((class_1920)clientWorld, (class_2338)class_2338.method_49637((double)x, (double)y, (double)z)));
    }

    public class_3999 method_74274() {
        return WATER_SPLASH_TYPE;
    }

    public void method_3070() {
        super.method_3070();
        if (!this.field_3851.method_8316(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871)).method_15767(class_3486.field_15517)) {
            this.method_3085();
        }
    }

    private static class WaterSplashGroupRenderState
    implements class_11942 {
        private final List<WaterSplashRenderData> renderDataList;

        public WaterSplashGroupRenderState(List<WaterSplashRenderData> renderDataList) {
            this.renderDataList = renderDataList;
        }

        public void submit(class_11659 collector, class_12075 cameraState) {
            if (this.renderDataList.isEmpty()) {
                return;
            }
            class_4587 poseStack = new class_4587();
            collector.method_73483(poseStack, class_12249.method_76000((class_2960)class_1059.field_17898), (pose, consumer) -> {
                for (WaterSplashRenderData data : this.renderDataList) {
                    this.renderSide(consumer, data.corners, 0, 1, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 1, 2, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 2, 3, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                    this.renderSide(consumer, data.corners, 3, 0, data.baseY, data.height, data.u0, data.u1, data.v0, data.v1, data.color, data.light);
                }
            });
        }

        private void renderSide(class_4588 consumer, Vector3f[] corners, int a, int b, float baseY, float height, float u0, float u1, float v0, float v1, int color, int light) {
            Vector3f cornerA = corners[a];
            Vector3f cornerB = corners[b];
            float bottomAX = cornerA.x;
            float bottomAZ = cornerA.z;
            float bottomBX = cornerB.x;
            float bottomBZ = cornerB.z;
            float topAX = cornerA.x;
            float topAZ = cornerA.z;
            float topBX = cornerB.x;
            float topBZ = cornerB.z;
            float dx = bottomBX - bottomAX;
            float dz = bottomBZ - bottomAZ;
            float normalX = -dz;
            float normalY = 0.0f;
            float normalZ = dx;
            float length = (float)Math.sqrt(normalX * normalX + normalZ * normalZ);
            if (length > 0.0f) {
                normalX /= length;
                normalZ /= length;
            }
            int noOverlay = class_4608.field_21444;
            consumer.method_22912(bottomAX, baseY, bottomAZ).method_22913(u0, v1).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(normalX, normalY, normalZ);
            consumer.method_22912(bottomBX, baseY, bottomBZ).method_22913(u1, v1).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(normalX, normalY, normalZ);
            consumer.method_22912(topBX, baseY + height, topBZ).method_22913(u1, v0).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(normalX, normalY, normalZ);
            consumer.method_22912(topAX, baseY + height, topAZ).method_22913(u0, v0).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(normalX, normalY, normalZ);
            consumer.method_22912(bottomBX, baseY, bottomBZ).method_22913(u0, v1).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(-normalX, normalY, -normalZ);
            consumer.method_22912(bottomAX, baseY, bottomAZ).method_22913(u1, v1).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(-normalX, normalY, -normalZ);
            consumer.method_22912(topAX, baseY + height, topAZ).method_22913(u1, v0).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(-normalX, normalY, -normalZ);
            consumer.method_22912(topBX, baseY + height, topBZ).method_22913(u0, v0).method_39415(color).method_22922(noOverlay).method_60803(light).method_22914(-normalX, normalY, -normalZ);
        }
    }

    private record WaterSplashRenderData(Vector3f[] corners, float baseY, float height, float u0, float u1, float v0, float v1, int color, int light) {
    }

    public static class WaterSplashParticleGroup
    extends class_11938<WaterSplashParticle> {
        public WaterSplashParticleGroup(class_702 engine) {
            super(engine);
        }

        public class_11942 method_74276(class_4604 frustum, class_4184 camera, float partialTick) {
            ArrayList<WaterSplashRenderData> renderDataList = new ArrayList<WaterSplashRenderData>();
            for (WaterSplashParticle particle : this.field_62620) {
                if (!particle.method_3086()) continue;
                class_1058 sprite = particle.provider.method_18138(particle.field_3866, particle.field_3847);
                float uvWidth = sprite.method_4577() - sprite.method_4594();
                float unit = uvWidth / ((float)sprite.method_45851().method_45807() / 2.0f);
                float u0 = sprite.method_4594() + unit;
                float u1 = sprite.method_4577() - unit;
                float v0 = sprite.method_4593();
                float v1 = sprite.method_4575();
                float rCol = particle.colored ? (float)particle.color.getRed() / 255.0f : 1.0f;
                float gCol = particle.colored ? (float)particle.color.getGreen() / 255.0f : 1.0f;
                float bCol = particle.colored ? (float)particle.color.getBlue() / 255.0f : 1.0f;
                class_243 vec3 = camera.method_71156();
                float camX = (float)(class_3532.method_16436((double)partialTick, (double)particle.field_3858, (double)particle.field_3874) - vec3.method_10216());
                float camY = (float)(class_3532.method_16436((double)partialTick, (double)particle.field_3838, (double)particle.field_3854) - vec3.method_10214());
                float camZ = (float)(class_3532.method_16436((double)partialTick, (double)particle.field_3856, (double)particle.field_3871) - vec3.method_10215());
                float ageDelta = class_3532.method_16439((float)partialTick, (float)(particle.field_3866 - 1), (float)particle.field_3866);
                float progress = ageDelta / (float)particle.field_3847;
                float scale = particle.width * (0.8f + 0.2f * progress);
                Vector3f[] corners = new Vector3f[]{new Vector3f(-1.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, -1.0f)};
                for (int i = 0; i < 4; ++i) {
                    corners[i].mul(scale);
                    corners[i].add(camX, camY, camZ);
                }
                int light = particle.method_3068(partialTick);
                int argb = class_9848.method_61318((float)1.0f, (float)rCol, (float)gCol, (float)bCol);
                renderDataList.add(new WaterSplashRenderData(corners, camY, particle.height, u0, u1, v0, v1, argb, light));
            }
            return new WaterSplashGroupRenderState(renderDataList);
        }
    }

    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 provider;

        public Factory(class_4002 provider) {
            this.provider = provider;
        }

        public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double g, double h, double i, class_5819 random) {
            return new WaterSplashParticle(world, x, y, z, (float)g, (float)h, this.provider);
        }
    }
}

