/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.item.GolemHatItem;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="snowiergolems")
public final class SnowierGolems {
    public static final String MODID = "snowiergolems";
    public static final Identifier MOD_LOCATION = Identifier.fromNamespaceAndPath((String)"snowiergolems", (String)"");
    public static final Identifier GOLEM_HAT_ID = SnowierGolems.id("golem_hat");

    public static Identifier id(String path) {
        return MOD_LOCATION.withPath(path);
    }

    public SnowierGolems(IEventBus eventBus) {
        eventBus.addListener(GolemObjects::register);
        eventBus.addListener(GolemObjects::addToCreativeTabs);
        eventBus.addListener(GolemObjects::commonSetup);
        NeoForge.EVENT_BUS.addListener(event -> {
            ItemStack stack = event.getVanillaResult().output();
            if (stack.is((Item)GolemObjects.GOLEM_HAT_ITEM)) {
                GolemHatItem.setPumpkinFace(stack);
            }
        });
    }

    public static ItemEnchantments getEnchantments(ItemStack stack) {
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        return lookup == null ? stack.getTagEnchantments() : stack.getAllEnchantments(lookup);
    }

    public static boolean hasEnchantment(ItemEnchantments enchantments, ResourceKey<Enchantment> enchantment) {
        for (Holder holder : enchantments.keySet()) {
            if (!holder.is(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemEnchantments enchantments, ResourceKey<Enchantment> enchantment) {
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            if (!((Holder)entry.getKey()).is(enchantment)) continue;
            return entry.getIntValue();
        }
        return 0;
    }
}

