/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.block;

import net.anawesomguy.snowiergolems.block.GolemHatBlockEntity;
import net.anawesomguy.snowiergolems.mixin.CarvedPumpkinAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public class GolemHatBlock
extends CarvedPumpkinBlock
implements EntityBlock {
    public GolemHatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSpawnGolem(LevelReader level, BlockPos pos) {
        return ((CarvedPumpkinAccessor)((Object)this)).callGetOrCreateSnowGolemBase().find(level, pos) != null;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        ItemStack itemStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GolemHatBlockEntity) {
            GolemHatBlockEntity entity = (GolemHatBlockEntity)blockEntity;
            itemStack = entity.getAsStack();
        } else {
            itemStack = super.getCloneItemStack(level, pos, state, includeData, player);
        }
        return itemStack;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GolemHatBlockEntity(pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager auxLight = level.getAuxLightManager(pos);
        return auxLight != null ? auxLight.getLightAt(pos) : super.getLightEmission(state, level, pos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        GolemHatBlockEntity entity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof GolemHatBlockEntity) || !(entity = (GolemHatBlockEntity)blockEntity).hasEnchantment((ResourceKey<Enchantment>)Enchantments.FLAME)) {
            return;
        }
        float y = (float)pos.getY() + 0.6f;
        int x = pos.getX();
        int z = pos.getZ();
        level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x + random.nextDouble(), (double)y + random.nextDouble() * 0.5 + 0.5, (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x + random.nextDouble(), (double)y + random.nextDouble() * 0.5 + 0.5, (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x + random.nextDouble(), (double)y + random.nextDouble() * 0.5 + 0.5, (double)z + random.nextDouble(), 0.0, 0.0, 0.0);
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }
}

