/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.block;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.SnowierGolems;
import net.anawesomguy.snowiergolems.enchant.GolemEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public class GolemHatBlockEntity
extends BlockEntity
implements Nameable {
    private static final RandomSource FALLBACK_RANDOM = RandomSource.createThreadSafe();
    public static final byte NORMAL_FACE_COUNT = 4;
    public static final byte ANGRY_FACE_COUNT = 2;
    public static final byte LIT_FACE_COUNT = 2;
    public static final byte TOTAL_FACES = 11;
    public static final String ENCHANTMENTS_TAG = "enchantments";
    public static final String FACE_ID_TAG = "pumpkin_face_id";
    protected ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    @Nullable
    protected Component name;
    protected byte faceId;

    public GolemHatBlockEntity(BlockPos pos, BlockState state) {
        super(GolemObjects.GOLEM_HAT_TYPE, pos, state);
    }

    public ItemStack getAsStack() {
        ItemStack stack = new ItemStack((ItemLike)GolemObjects.GOLEM_HAT_ITEM);
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    public void update(@Nullable Level level) {
        BlockPos pos;
        AuxiliaryLightManager auxLight;
        if (level == null) {
            level = this.level;
        }
        if (level != null && (auxLight = level.getAuxLightManager(pos = this.getBlockPos())) != null) {
            if (!this.isRemoved() && this.hasEnchantment((ResourceKey<Enchantment>)Enchantments.FLAME)) {
                auxLight.setLightAt(pos, 15);
            } else {
                auxLight.removeLightAt(pos);
            }
        }
    }

    public void onLoad() {
        this.getOrCreateFaceId();
        super.onLoad();
        this.update(this.level);
    }

    public void setRemoved() {
        super.setRemoved();
        this.update(null);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (!this.enchantments.isEmpty()) {
            output.store(ENCHANTMENTS_TAG, ItemEnchantments.CODEC, (Object)this.enchantments);
        }
        output.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.name);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.read(ENCHANTMENTS_TAG, ItemEnchantments.CODEC).ifPresent(this::setEnchantments);
        this.faceId = input.getByteOr(FACE_ID_TAG, this.faceId);
        this.name = GolemHatBlockEntity.parseCustomNameSafe((ValueInput)input, (String)"CustomName");
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        ItemEnchantments enchants = (ItemEnchantments)componentGetter.get(DataComponents.ENCHANTMENTS);
        if (enchants != null && !enchants.isEmpty()) {
            this.enchantments = enchants;
        }
        this.faceId = (Byte)componentGetter.getOrDefault(GolemObjects.PUMPKIN_FACE, (Object)-1);
        this.name = (Component)componentGetter.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        components.set(GolemObjects.PUMPKIN_FACE, (Object)this.faceId);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(ENCHANTMENTS_TAG);
        output.discard(FACE_ID_TAG);
        output.discard("CustomName");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Component getName() {
        return this.name == null ? this.getBlockState().getBlock().getName() : this.name;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component customName) {
        this.name = customName;
    }

    public byte getOrCreateFaceId() {
        if (GolemHatBlockEntity.isValidFaceId(this.faceId)) {
            return this.faceId;
        }
        this.faceId = GolemHatBlockEntity.calculateFaceId(this.level == null ? null : this.level.random, this::getLevel, this::hasEnchantment);
        return this.faceId;
    }

    public static boolean isValidFaceId(byte id) {
        return id < 11 && id >= 0;
    }

    public static byte calculateFaceId(@Nullable RandomSource random, ToIntFunction<ResourceKey<Enchantment>> levelGetter, @Nullable Predicate<ResourceKey<Enchantment>> hasEnchantment) {
        if (random == null) {
            random = FALLBACK_RANDOM;
        }
        if (hasEnchantment != null) {
            float f = random.nextFloat();
            int frostLevel = levelGetter.applyAsInt(GolemEnchantments.FROST);
            if (frostLevel > 0 && f < 1.0f - 0.7f / (float)(2 + frostLevel)) {
                return 10;
            }
            boolean b = random.nextBoolean();
            int aggressiveLevel = levelGetter.applyAsInt(GolemEnchantments.AGGRESSIVE);
            if (aggressiveLevel > 0 && f < 1.0f - 0.7f / (float)(2 + aggressiveLevel)) {
                return b ? (byte)4 : 5;
            }
            boolean hasFlame = hasEnchantment.test((ResourceKey<Enchantment>)Enchantments.FLAME);
            if (hasFlame && f > 0.3f) {
                return 6;
            }
            if (random.nextFloat() > 0.35f) {
                if (hasEnchantment.test((ResourceKey<Enchantment>)Enchantments.MULTISHOT)) {
                    return (byte)(hasFlame ? 7 : 9);
                }
                if (hasEnchantment.test(GolemEnchantments.ACCURACY)) {
                    return 8;
                }
            }
        }
        return (byte)random.nextInt(4);
    }

    public static byte calculateFaceId(@Nullable RandomSource random, @Nullable ItemEnchantments enchantments) {
        return GolemHatBlockEntity.calculateFaceId(random, enchantments != null ? e -> SnowierGolems.getEnchantmentLevel(enchantments, (ResourceKey<Enchantment>)e) : __ -> 0, enchantments != null ? e -> SnowierGolems.hasEnchantment(enchantments, (ResourceKey<Enchantment>)e) : null);
    }

    public boolean hasEnchantments() {
        return !this.enchantments.isEmpty();
    }

    public boolean hasEnchantment(ResourceKey<Enchantment> enchantment) {
        if (this.level != null) {
            return this.enchantments.getLevel(Objects.requireNonNull(this.toHolder(enchantment))) > 0;
        }
        Set keySet = this.enchantments.keySet();
        for (Holder key : keySet) {
            if (!key.is(enchantment)) continue;
            return true;
        }
        return false;
    }

    public int getLevel(ResourceKey<Enchantment> enchantment) {
        Holder<Enchantment> holder = this.toHolder(enchantment);
        return holder == null ? 0 : this.enchantments.getLevel(holder);
    }

    public boolean hasEnchantment(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment) > 0;
    }

    public int getLevel(Holder<Enchantment> enchantment) {
        return this.enchantments.getLevel(enchantment);
    }

    public ItemEnchantments getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(@Nullable ItemEnchantments enchants) {
        this.enchantments = enchants == null ? ItemEnchantments.EMPTY : enchants;
        this.update(null);
    }

    @Nullable
    public Holder<Enchantment> toHolder(ResourceKey<Enchantment> key) {
        Objects.requireNonNull(key);
        if (this.level != null) {
            return this.level.registryAccess().holderOrThrow(key);
        }
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)key.registryKey());
        if (lookup != null) {
            return lookup.getOrThrow(key);
        }
        return null;
    }
}

