/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.anawesomguy.snowiergolems.block.GolemHatBlock;
import net.anawesomguy.snowiergolems.block.GolemHatBlockEntity;
import net.anawesomguy.snowiergolems.client.GolemHatRenderState;
import net.anawesomguy.snowiergolems.client.SnowierGolemsClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.jspecify.annotations.Nullable;

public class GolemHatRenderer
implements BlockEntityRenderer<GolemHatBlockEntity, GolemHatRenderState> {
    private static final Map<BlockModelPart, BlockStateModel> BLOCK_STATE_MODEL_CACHE = new IdentityHashMap<BlockModelPart, BlockStateModel>(44);
    public final ModelManager modelManager;

    public static BlockStateModel toBlockStateModel(BlockModelPart model) {
        return BLOCK_STATE_MODEL_CACHE.computeIfAbsent(model, SingleVariant::new);
    }

    public static BlockModelPart getModel(byte faceId, Direction facing, ModelManager models) {
        return Objects.requireNonNull((BlockModelPart)models.getStandaloneModel(SnowierGolemsClient.FACES_KEYS.get(Byte.toUnsignedInt(faceId)).get(facing)));
    }

    public GolemHatRenderer(BlockEntityRendererProvider.Context ctx) {
        this.modelManager = ctx.blockRenderDispatcher().getBlockModelShaper().getModelManager();
    }

    public GolemHatRenderer() {
        this.modelManager = Minecraft.getInstance().getModelManager();
    }

    public static void submit(PoseStack stack, SubmitNodeCollector collector, ModelManager modelManager, BlockState state, byte faceId, boolean foil, boolean flame, int light, int overlay, int outlineColor) {
        BlockModelPart model = GolemHatRenderer.getModel(faceId, (Direction)state.getValue((Property)GolemHatBlock.FACING), modelManager);
        BlockStateModel blockStateModel = GolemHatRenderer.toBlockStateModel(model);
        collector.submitBlockModel(stack, RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)model.getRenderType(state)), blockStateModel, 0.0f, 0.0f, 0.0f, light, overlay, outlineColor);
        if (foil) {
            collector.submitBlockModel(stack, RenderTypes.entityGlint(), blockStateModel, 0.0f, 0.0f, 0.0f, light, overlay, 0);
        }
        if (flame) {
            stack.translate(0.1f, 1.0f, 0.1f);
            stack.scale(0.8f, 0.6f, 0.8f);
            collector.submitBlock(stack, Blocks.FIRE.defaultBlockState(), 0xF000F0, OverlayTexture.NO_OVERLAY, outlineColor);
        }
    }

    public GolemHatRenderState createRenderState() {
        return new GolemHatRenderState();
    }

    public void extractRenderState(GolemHatBlockEntity golemHat, GolemHatRenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)golemHat, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        boolean flame = renderState.hasFlame = golemHat.hasEnchantment((ResourceKey<Enchantment>)Enchantments.FLAME);
        renderState.hasFoil = golemHat.hasEnchantments();
        renderState.faceId = golemHat.getOrCreateFaceId();
        renderState.lightCoords = flame || golemHat.getLevel() == null ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)golemHat.getLevel(), (BlockPos)golemHat.getBlockPos().above());
    }

    public void submit(GolemHatRenderState golemHat, PoseStack stack, SubmitNodeCollector nodeCollector, CameraRenderState camera) {
        GolemHatRenderer.submit(stack, nodeCollector, this.modelManager, golemHat.blockState, golemHat.faceId, golemHat.hasFoil, golemHat.hasFlame, golemHat.lightCoords, OverlayTexture.NO_OVERLAY, 0);
    }
}

