/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.SnowierGolems;
import net.anawesomguy.snowiergolems.client.GolemHatRenderer;
import net.anawesomguy.snowiergolems.client.SnowierGolemsClient;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class GolemHatSpecialRenderer
implements SpecialModelRenderer<DataComponentMap> {
    private final GolemHatRenderer renderer;

    private GolemHatSpecialRenderer(GolemHatRenderer renderer) {
        this.renderer = renderer;
    }

    public void submit(@Nullable DataComponentMap components, ItemDisplayContext displayContext, PoseStack stack, SubmitNodeCollector nodeCollector, int light, int overlay, boolean foil, int outline) {
        boolean flame;
        byte faceId;
        if (components == null || components.isEmpty()) {
            faceId = 0;
            flame = false;
        } else {
            faceId = (Byte)components.getOrDefault(GolemObjects.PUMPKIN_FACE, (Object)0);
            ItemEnchantments enchantments = (ItemEnchantments)components.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            if (!enchantments.isEmpty()) {
                foil = true;
                flame = SnowierGolems.hasEnchantment(enchantments, (ResourceKey<Enchantment>)Enchantments.FLAME);
                if (flame) {
                    light = 0xF000F0;
                }
            } else {
                flame = false;
            }
        }
        stack.translate(0.5f, 0.5f, 0.5f);
        SnowierGolemsClient.StandaloneGolemHatModel.TRANSFORMS.getTransform(displayContext).apply(displayContext.leftHand(), stack.last());
        GolemHatRenderer.submit(stack, nodeCollector, this.renderer.modelManager, GolemObjects.GOLEM_HAT.defaultBlockState(), faceId, foil, flame, light, overlay, outline);
    }

    public void getExtents(Consumer<Vector3fc> consumer) {
    }

    public DataComponentMap extractArgument(ItemStack stack) {
        return stack.getComponents();
    }

    public static final class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final Unbaked INSTANCE = new Unbaked();
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit((Object)INSTANCE);

        private Unbaked() {
        }

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext ctx) {
            return new GolemHatSpecialRenderer(new GolemHatRenderer());
        }
    }
}

