/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.SnowierGolems;
import net.anawesomguy.snowiergolems.client.GolemHatRenderer;
import net.anawesomguy.snowiergolems.client.GolemHatSpecialRenderer;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.entity.SnowGolemRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT})
public final class SnowierGolemsClient {
    public static final ContextKey<ItemStack> HAT_KEY = new ContextKey(SnowierGolems.GOLEM_HAT_ID);
    public static final List<Material> NORMAL_FACES = List.of(SnowierGolemsClient.pumpkinFace("face_1"), SnowierGolemsClient.pumpkinFace("face_2"), SnowierGolemsClient.pumpkinFace("face_3"), SnowierGolemsClient.pumpkinFace("face_4"));
    public static final List<Material> ANGRY_FACES = List.of(SnowierGolemsClient.pumpkinFace("angry_1"), SnowierGolemsClient.pumpkinFace("angry_2"));
    public static final List<Material> LIT_FACES = List.of(SnowierGolemsClient.blockMaterial(Identifier.withDefaultNamespace((String)"block/jack_o_lantern")), SnowierGolemsClient.pumpkinFace("three_eyed_lit"));
    public static final Material ONE_EYED_FACE = SnowierGolemsClient.pumpkinFace("one_eyed");
    public static final Material THREE_EYED_FACE = SnowierGolemsClient.pumpkinFace("three_eyed");
    public static final Material FROST_FACE = SnowierGolemsClient.pumpkinFace("frost");
    public static final Material SNOWY_PUMPKIN_SIDE = SnowierGolemsClient.blockMaterial(SnowierGolems.id("block/pumpkin/snowy_pumpkin"));
    public static final Material PUMPKIN_SIDE = SnowierGolemsClient.blockMaterial(Identifier.withDefaultNamespace((String)"block/pumpkin_side"));
    public static final Material SNOW = SnowierGolemsClient.blockMaterial(Identifier.withDefaultNamespace((String)"block/snow"));
    public static final Material PUMPKIN_TOP = SnowierGolemsClient.blockMaterial(Identifier.withDefaultNamespace((String)"block/pumpkin_top"));
    public static final Material PUMPKIN_FACE = SnowierGolemsClient.blockMaterial(Identifier.withDefaultNamespace((String)"block/carved_pumpkin"));
    public static final List<Material> ALL_FACES = ImmutableList.builder().addAll(NORMAL_FACES).addAll(ANGRY_FACES).addAll(LIT_FACES).add((Object[])new Material[]{ONE_EYED_FACE, THREE_EYED_FACE, FROST_FACE}).build();
    public static final List<EnumMap<Direction, StandaloneModelKey<BlockModelPart>>> FACES_KEYS = Arrays.asList(new EnumMap[ALL_FACES.size()]);

    private static Material blockMaterial(Identifier texture) {
        return new Material(ModelManager.BLOCK_OR_ITEM, texture);
    }

    private static Material pumpkinFace(String faceName) {
        return SnowierGolemsClient.blockMaterial(SnowierGolems.id("block/pumpkin/face/" + faceName));
    }

    @SubscribeEvent
    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(GolemObjects.GOLEM_HAT_TYPE, GolemHatRenderer::new);
        event.registerEntityRenderer(GolemObjects.ENCHANTED_SNOWBALL, ThrownItemRenderer::new);
    }

    @SubscribeEvent
    private static void registerSpecialModelRenderers(RegisterSpecialModelRendererEvent event) {
        event.register(SnowierGolems.GOLEM_HAT_ID, GolemHatSpecialRenderer.Unbaked.CODEC);
    }

    @SubscribeEvent
    private static void registerRenderStateModifiersEvent(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(SnowGolemRenderer.class, (golem, state) -> state.setRenderData(HAT_KEY, (Object)golem.getItemBySlot(EquipmentSlot.HEAD)));
    }

    @SubscribeEvent
    private static void registerStandaloneModels(ModelEvent.RegisterStandalone event) {
        int size = ALL_FACES.size();
        for (int i = 0; i < size; ++i) {
            Material face = ALL_FACES.get(i);
            EnumMap<Direction, StandaloneModelKey> map = new EnumMap<Direction, StandaloneModelKey>(Direction.class);
            FACES_KEYS.set(i, map);
            for (Direction d : Direction.Plane.HORIZONTAL) {
                String name = "snowiergolems:" + ALL_FACES.get(i).texture().getPath().substring(19) + "_" + String.valueOf(d);
                ModelDebugName debugName = () -> name;
                StandaloneModelKey key = new StandaloneModelKey(debugName);
                map.put(d, key);
                event.register(key, (UnbakedStandaloneModel)new StandaloneGolemHatModel(d, face, debugName));
            }
        }
    }

    public record StandaloneGolemHatModel(Direction facing, Material face, ModelDebugName debugName) implements UnbakedStandaloneModel<BlockModelPart>
    {
        private static final Identifier CUBE = Identifier.withDefaultNamespace((String)"block/cube");
        public static final ItemTransforms TRANSFORMS;

        public BlockModelPart bake(ModelBaker baker) {
            boolean frost = FROST_FACE.equals((Object)this.face);
            TextureSlots.Data.Builder data = new TextureSlots.Data.Builder().addTexture("particle", PUMPKIN_FACE).addTexture("up", frost ? SNOW : PUMPKIN_TOP).addTexture("down", PUMPKIN_TOP);
            Material side = frost ? SNOWY_PUMPKIN_SIDE : PUMPKIN_SIDE;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                data.addTexture(d.getName(), d == this.facing ? this.face : side);
            }
            return SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)baker.resolveInlineModel((UnbakedModel)new BlockModel(null, null, null, TRANSFORMS, data.build(), CUBE), this.debugName), (ModelState)BlockModelRotation.IDENTITY);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(CUBE);
        }

        static {
            ItemTransform thirdPerson = new ItemTransform((Vector3fc)new Vector3f(75.0f, 45.0f, 0.0f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_TRANSLATION, (Vector3fc)new Vector3f(0.375f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION);
            ItemTransform firstPerson = new ItemTransform((Vector3fc)new Vector3f(0.0f, 135.0f, 0.0f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_TRANSLATION, (Vector3fc)new Vector3f(0.4f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION);
            TRANSFORMS = new ItemTransforms(thirdPerson, thirdPerson, firstPerson, firstPerson, new ItemTransform((Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION, (Vector3fc)ItemTransform.Deserializer.DEFAULT_TRANSLATION, (Vector3fc)ItemTransform.Deserializer.DEFAULT_SCALE, (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION), new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_TRANSLATION, (Vector3fc)new Vector3f(0.625f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION), new ItemTransform((Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION, (Vector3fc)new Vector3f(0.0f, 3.0f, 0.0f), (Vector3fc)new Vector3f(0.25f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION), new ItemTransform((Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION, (Vector3fc)ItemTransform.Deserializer.DEFAULT_TRANSLATION, (Vector3fc)new Vector3f(0.5f), (Vector3fc)ItemTransform.Deserializer.DEFAULT_ROTATION), ItemTransform.NO_TRANSFORM, ImmutableMap.of());
        }
    }
}

