/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.entity;

import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.anawesomguy.snowiergolems.util.ExpiringMemoizedBooleanSupplier;
import net.minecraft.world.entity.ai.goal.Goal;

public final class ConditionalGoal
extends Goal {
    public final Goal delegateGoal;
    private final BooleanSupplier predicate;

    public ConditionalGoal(Goal delegateGoal, BooleanSupplier predicate, int cacheCalls) {
        this.delegateGoal = delegateGoal;
        this.predicate = cacheCalls <= 0 || predicate instanceof ExpiringMemoizedBooleanSupplier ? predicate : new ExpiringMemoizedBooleanSupplier(predicate, cacheCalls);
    }

    public ConditionalGoal(Goal delegateGoal, BooleanSupplier predicate) {
        this(delegateGoal, predicate, 8);
    }

    public boolean canUse() {
        return this.predicate.getAsBoolean() && this.delegateGoal.canUse();
    }

    public boolean canContinueToUse() {
        return this.delegateGoal.canContinueToUse();
    }

    public boolean isInterruptable() {
        return this.delegateGoal.isInterruptable();
    }

    public void start() {
        this.delegateGoal.start();
    }

    public void stop() {
        this.delegateGoal.stop();
    }

    public boolean requiresUpdateEveryTick() {
        return this.delegateGoal.requiresUpdateEveryTick();
    }

    public void tick() {
        this.delegateGoal.tick();
    }

    public void setFlags(EnumSet<Goal.Flag> flagSet) {
        this.delegateGoal.setFlags(flagSet);
    }

    public String toString() {
        return "ConditionalGoal[" + String.valueOf(this.delegateGoal) + "]";
    }

    public EnumSet<Goal.Flag> getFlags() {
        return this.delegateGoal.getFlags();
    }
}

