/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EnchantedSnowball
extends Snowball {
    protected static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.defineId(EnchantedSnowball.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final int IGNITE_TICKS = 40;
    public float baseDamage = 0.0f;
    protected final ItemStack shotFrom;
    @Nullable
    private EnchantedItemInUse itemInUse;

    public EnchantedSnowball(EntityType<? extends EnchantedSnowball> entityType, Level level, ItemStack shotFrom) {
        super(entityType, level);
        ItemEnchantments enchantments = shotFrom.getAllEnchantments((HolderLookup.RegistryLookup)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
        if (!enchantments.isEmpty()) {
            this.getItem().set(DataComponents.ENCHANTMENTS, (Object)enchantments);
        }
        this.shotFrom = shotFrom;
        if (level instanceof ServerLevel && !shotFrom.isEmpty()) {
            EnchantedItemInUse itemInUse = this.getOrCreateItemInUse(null);
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                ((Enchantment)((Holder)entry.getKey()).value()).onProjectileSpawned((ServerLevel)level, entry.getIntValue(), itemInUse, (Entity)this);
            }
        }
    }

    public EnchantedSnowball(EntityType<? extends EnchantedSnowball> entityType, Level level) {
        this(entityType, level, ItemStack.EMPTY);
    }

    public EnchantedSnowball(Level level, double x, double y, double z, ItemStack shotFrom) {
        this(GolemObjects.ENCHANTED_SNOWBALL, level, shotFrom);
        this.setPos(x, y, z);
    }

    public EnchantedSnowball(Level level, LivingEntity shooter, ItemStack shotFrom) {
        this(level, shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ(), shotFrom);
        this.setOwner((Entity)shooter);
        if (shooter instanceof SnowGolem && shooter.getItemBySlot(EquipmentSlot.HEAD).is((Item)GolemObjects.GOLEM_HAT_ITEM)) {
            this.getOrCreateItemInUse(EquipmentSlot.HEAD);
        }
    }

    public ItemStack getShotFrom() {
        return this.shotFrom;
    }

    protected EnchantedItemInUse getOrCreateItemInUse(@Nullable EquipmentSlot slot) {
        if (this.itemInUse == null) {
            LivingEntity living;
            Entity entity = this.getOwner();
            LivingEntity owner = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
            this.itemInUse = owner != null && slot != null ? new EnchantedItemInUse(this.shotFrom, slot, owner) : new EnchantedItemInUse(this.shotFrom, slot, owner, item -> {});
            return this.itemInUse;
        }
        return this.itemInUse;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PIERCE_LEVEL, (Object)0);
    }

    protected void setPierceLevel(byte pierceLevel) {
        this.entityData.set(PIERCE_LEVEL, (Object)pierceLevel);
    }

    public byte getPierceLevel() {
        return (Byte)this.entityData.get(PIERCE_LEVEL);
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.baseDamage != 0.0f) {
            output.putDouble("damage", (double)this.baseDamage);
        }
    }

    public void readAdditionalSaveData(ValueInput input) {
        this.baseDamage = input.getFloatOr("damage", 0.0f);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            LivingEntity livingOwner;
            ServerLevel level2 = (ServerLevel)level;
            Vec3 vec3 = result.getBlockPos().clampLocationWithin(result.getLocation());
            Entity entity = this.getOwner();
            EnchantmentHelper.onHitBlock((ServerLevel)level2, (ItemStack)this.shotFrom, (LivingEntity)(entity instanceof LivingEntity ? (livingOwner = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)level2.getBlockState(result.getBlockPos()), item -> {});
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        ItemStack shotFrom = this.shotFrom;
        DamageSource source = this.damageSources().thrown((Entity)this, this.getOwner());
        float damage = this.baseDamage;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!shotFrom.isEmpty()) {
                damage = EnchantmentHelper.modifyDamage((ServerLevel)level2, (ItemStack)shotFrom, (Entity)this, (DamageSource)source, (float)damage);
                if (entity instanceof Blaze) {
                    damage += 3.0f;
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    double knockback = EnchantmentHelper.modifyKnockback((ServerLevel)level2, (ItemStack)shotFrom, (Entity)entity, (DamageSource)source, (float)0.0f);
                    if (knockback > 0.0) {
                        double resistance = Math.max(0.0, 1.0 - living.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
                        Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(knockback * resistance * 0.6);
                        if (vec3.lengthSqr() > 0.0) {
                            entity.push(vec3.x, 0.1, vec3.z);
                        }
                    }
                }
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)level2, (Entity)entity, (DamageSource)source, (ItemStack)shotFrom);
            }
            entity.hurtServer(level2, source, damage);
        }
        if (this.isOnFire()) {
            entity.igniteForTicks(40);
        }
    }
}

