/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.entity;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import org.jetbrains.annotations.Nullable;

public class SnowGolemOwnerHurtByTargetGoal
extends TargetGoal {
    protected final OwnableEntity ownable;
    @Nullable
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public <T extends Mob> SnowGolemOwnerHurtByTargetGoal(T ownable) {
        super(ownable, false);
        this.ownable = (OwnableEntity)Objects.requireNonNull(ownable);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity owner = this.ownable.getOwner();
        if (owner != null) {
            this.ownerLastHurtBy = owner.getLastHurtByMob();
            LivingEntity entity = this.ownerLastHurtBy;
            if (entity == null) {
                return false;
            }
            if (SnowGolem.class.isAssignableFrom(entity.getClass())) {
                return false;
            }
            return owner.getLastHurtByMobTimestamp() != this.timestamp && this.canAttack(entity, TargetingConditions.DEFAULT);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        LivingEntity owner = this.ownable.getOwner();
        if (owner != null) {
            this.timestamp = owner.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

