/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.function.Predicate;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.block.GolemHatBlock;
import net.anawesomguy.snowiergolems.block.GolemHatBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarvedPumpkinBlock.class})
public abstract class CarvedPumpkinMixin {
    private CarvedPumpkinMixin() {
    }

    @Inject(method={"trySpawnGolem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/CarvedPumpkinBlock;getOrCreateIronGolemFull()Lnet/minecraft/world/level/block/state/pattern/BlockPattern;")}, cancellable=true)
    private void noIronGolem(Level level, BlockPos pos, CallbackInfo ci) {
        if (this instanceof GolemHatBlock) {
            ci.cancel();
        }
    }

    @Inject(method={"trySpawnGolem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/CarvedPumpkinBlock;spawnGolemInWorld(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/pattern/BlockPattern$BlockPatternMatch;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;)V", ordinal=0)})
    private void addSnowGolemEnchants(Level level, BlockPos pos, CallbackInfo ci, @Local BlockPattern.BlockPatternMatch match, @Local SnowGolem golem) {
        BlockEntity golemHat;
        BlockInWorld blockInWorld = match.getBlock(0, 0, 0);
        if (match.getBlock(0, 0, 0).getState().is((Block)GolemObjects.GOLEM_HAT) && (golemHat = blockInWorld.getEntity()) instanceof GolemHatBlockEntity) {
            GolemHatBlockEntity golemHatEntity = (GolemHatBlockEntity)golemHat;
            golem.setItemSlot(EquipmentSlot.HEAD, golemHatEntity.getAsStack());
            if (golemHatEntity.hasCustomName()) {
                golem.setCustomName(golemHatEntity.getCustomName());
            }
        }
    }

    @Inject(method={"spawnGolemInWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancements/criterion/SummonedEntityTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/entity/Entity;)V")})
    private static void findNearestPlayerToGolem(Level level, BlockPattern.BlockPatternMatch patternMatch, Entity golem, BlockPos pos, CallbackInfo ci, @Local ServerPlayer player, @Share(value="nearestPlayer") LocalRef<ServerPlayer> nearestPlayer, @Share(value="distanceSqr") LocalDoubleRef distanceSqrRef) {
        if (golem instanceof SnowGolem) {
            double playerDistanceSqr = player.distanceToSqr(golem);
            double distanceSqr = distanceSqrRef.get();
            if (!(player instanceof FakePlayer) && (distanceSqr == 0.0 || playerDistanceSqr < distanceSqr)) {
                distanceSqrRef.set(playerDistanceSqr);
                nearestPlayer.set((Object)player);
            }
        }
    }

    @Inject(method={"spawnGolemInWorld"}, at={@At(value="RETURN")})
    private static void setSnowGolemOwner(Level level, BlockPattern.BlockPatternMatch patternMatch, Entity golem, BlockPos pos, CallbackInfo ci, @Share(value="nearestPlayer") LocalRef<@Nullable ServerPlayer> nearestPlayer, @Share(value="distanceSqr") LocalDoubleRef distanceSqrRef) {
        Player player;
        if (golem instanceof SnowGolem && (player = (Player)nearestPlayer.get()) != null) {
            golem.setData(GolemObjects.SNOW_GOLEM_OWNER, (Object)EntityReference.of((UniquelyIdentifyable)player));
        }
    }

    @ModifyExpressionValue(method={"getOrCreateSnowGolemFull"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/CarvedPumpkinBlock;PUMPKINS_PREDICATE:Ljava/util/function/Predicate;", opcode=178)})
    private Predicate<BlockState> addGolemHatAsPumpkin(Predicate<BlockState> original) {
        return original.or(state -> state.is((Block)GolemObjects.GOLEM_HAT));
    }
}

