/*
 * Decompiled with CFR 0.152.
 */
package net.anawesomguy.snowiergolems.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.function.Consumer;
import net.anawesomguy.snowiergolems.GolemObjects;
import net.anawesomguy.snowiergolems.enchant.GolemEnchantments;
import net.anawesomguy.snowiergolems.entity.ConditionalGoal;
import net.anawesomguy.snowiergolems.entity.EnchantedSnowball;
import net.anawesomguy.snowiergolems.entity.SnowGolemFollowOwnerGoal;
import net.anawesomguy.snowiergolems.entity.SnowGolemOwnerHurtByTargetGoal;
import net.anawesomguy.snowiergolems.entity.SnowGolemOwnerHurtTargetGoal;
import net.anawesomguy.snowiergolems.util.ExpiringMemoizedBooleanSupplier;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.golem.AbstractGolem;
import net.minecraft.world.entity.animal.golem.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowGolem.class})
public abstract class SnowGolemMixin
extends AbstractGolem
implements OwnableEntity {
    @Shadow
    private static void lambda$performRangedAttack$1(double x, double eyeY, double yOffset, double z, Snowball snowball) {
    }

    private SnowGolemMixin() {
        super(null, null);
        throw new AssertionError();
    }

    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return (EntityReference)this.getData(GolemObjects.SNOW_GOLEM_OWNER);
    }

    @ModifyReturnValue(method={"createAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder addAttributes(AttributeSupplier.Builder builder) {
        return builder.add(GolemEnchantments.PROJECTILE_ACCURACY, -11.0);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void alwaysDropHat(EntityType<? extends SnowGolem> type, Level level, CallbackInfo ci) {
        this.setItemSlotAndDropWhenKilled(EquipmentSlot.HEAD, Items.CARVED_PUMPKIN.getDefaultInstance());
    }

    @Inject(method={"registerGoals"}, at={@At(value="RETURN")})
    private void addCustomGoals(CallbackInfo ci) {
        ExpiringMemoizedBooleanSupplier checkLoyalty = new ExpiringMemoizedBooleanSupplier(() -> this.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel(this.registryAccess().holderOrThrow(GolemEnchantments.SNOWY_LOYALTY)) > 0, 12);
        this.goalSelector.addGoal(5, (Goal)new ConditionalGoal(new SnowGolemFollowOwnerGoal(this, 1.1, 15.0, 4.0), checkLoyalty));
        this.targetSelector.addGoal(-4, (Goal)new ConditionalGoal((Goal)new SnowGolemOwnerHurtByTargetGoal(this), checkLoyalty));
        this.targetSelector.addGoal(-3, (Goal)new ConditionalGoal((Goal)new SnowGolemOwnerHurtTargetGoal(this), checkLoyalty));
        this.targetSelector.addGoal(-2, (Goal)new ConditionalGoal((Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, (entity, level) -> {
            EntityReference<LivingEntity> owner = this.getOwnerReference();
            return owner == null || !owner.matches((UniquelyIdentifyable)entity);
        }), () -> this.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel(this.registryAccess().holderOrThrow(GolemEnchantments.AGGRESSIVE)) >= 3));
        this.targetSelector.addGoal(-1, (Goal)new ConditionalGoal((Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SnowGolem.class}).setAlertOthers(new Class[0]), () -> this.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel(this.registryAccess().holderOrThrow(GolemEnchantments.AGGRESSIVE)) >= 2));
        this.targetSelector.addGoal(0, (Goal)new ConditionalGoal((Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{SnowGolem.class}), () -> this.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel(this.registryAccess().holderOrThrow(GolemEnchantments.AGGRESSIVE)) >= 1));
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private void wearHat(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir, @Local ItemStack stack) {
        if (stack.is((Item)GolemObjects.GOLEM_HAT_ITEM) || stack.is(Items.CARVED_PUMPKIN)) {
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            this.setItemSlot(EquipmentSlot.HEAD, stack.split(1));
        }
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/attribute/EnvironmentAttributeSystem;getValue(Lnet/minecraft/world/attribute/EnvironmentAttribute;Lnet/minecraft/world/phys/Vec3;)Ljava/lang/Object;")})
    private Object doNotMelt(Object original) {
        return (Boolean)original != false && this.getItemBySlot(EquipmentSlot.HEAD).getEnchantmentLevel(this.registryAccess().holderOrThrow(GolemEnchantments.HEAT_RESISTANT)) <= 0;
    }

    @WrapOperation(method={"performRangedAttack"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/projectile/throwableitemprojectile/Snowball;")})
    private Snowball enchantSnowball(Level level, LivingEntity shooter, ItemStack stack, Operation<Snowball> original, @Share(value="hatStack") LocalRef<ItemStack> hatStack, @Share(value="enchanted") LocalBooleanRef enchantedRef) {
        ItemStack hat = this.getItemBySlot(EquipmentSlot.HEAD);
        hatStack.set((Object)hat);
        boolean enchanted = hat.isEnchanted();
        enchantedRef.set(enchanted);
        return enchanted ? new EnchantedSnowball(level, shooter, hat) : (Snowball)original.call(new Object[]{level, shooter, stack});
    }

    @WrapOperation(method={"performRangedAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;spawnProjectile(Lnet/minecraft/world/entity/projectile/Projectile;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Ljava/util/function/Consumer;)Lnet/minecraft/world/entity/projectile/Projectile;")})
    private Projectile doMultishot(Projectile projectile, ServerLevel level, ItemStack stack, Consumer<Projectile> adapter, Operation<Projectile> original, @Share(value="hatStack") LocalRef<ItemStack> hatStack, @Share(value="enchanted") LocalBooleanRef enchantedRef, @Local(ordinal=0) double x, @Local(ordinal=2) double z, @Local(ordinal=3) double yOffset) {
        int count;
        ItemStack hat = (ItemStack)hatStack.get();
        boolean enchanted = enchantedRef.get();
        if (!enchanted || (count = EnchantmentHelper.processProjectileCount((ServerLevel)level, (ItemStack)hat, (Entity)this, (int)1)) <= 1) {
            return (Projectile)original.call(new Object[]{projectile, level, stack, adapter});
        }
        float spread = 2.0f * EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)hat, (Entity)this, (float)0.0f) / (float)(count - 1);
        float offset = (float)((count - 1) % 2) * spread / 2.0f;
        Vector3f forward = new Vector3f((float)x, (float)yOffset - 1.0f, (float)z).normalize();
        Vector3f axis = new Vector3f(-forward.z, 0.0f, forward.x);
        if (x * x + z * z <= 1.0E-7) {
            forward.cross((Vector3fc)this.getUpVector(1.0f).toVector3f(), axis);
        }
        axis.cross((Vector3fc)forward).normalize();
        Vector3f vec = new Vector3f();
        AttributeInstance instance = this.getAttribute((Holder)GolemEnchantments.PROJECTILE_ACCURACY);
        float accuracy = instance == null ? 12.0f : Math.max(0.0f, -((float)instance.getValue()));
        Consumer<Snowball> newAdapter = snowball -> snowball.shoot((double)vec.x, (double)vec.y, (double)vec.z, 1.6f, accuracy);
        while (--count > 0) {
            float angle = offset + spread * (float)((count + 1) / 2);
            forward.rotateAxis(angle * ((float)Math.PI / 180), axis.x, axis.y, axis.z, vec);
            spread = -spread;
            original.call(new Object[]{new EnchantedSnowball((Level)level, (LivingEntity)this, hat), level, stack, newAdapter});
        }
        if (offset == 0.0f) {
            vec.set((Vector3fc)forward);
        } else {
            forward.rotateAxis(offset * ((float)Math.PI / 180), axis.x, axis.y, axis.z, vec);
        }
        return (Projectile)original.call(new Object[]{projectile, level, stack, newAdapter});
    }

    @ModifyArg(method={"lambda$performRangedAttack$1"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/throwableitemprojectile/Snowball;shoot(DDDFF)V"), index=4)
    private static float changeInaccuracy(float inaccuracy, @Local(argsOnly=true) Snowball snowball) {
        AttributeInstance accuracy = ((LivingEntity)snowball.getOwner()).getAttribute(GolemEnchantments.PROJECTILE_ACCURACY);
        return accuracy == null ? inaccuracy : Math.max(0.0f, -((float)accuracy.getValue()));
    }
}

