/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block.entity;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.GraveConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends class_2586 {
    @Nullable
    private GraveComponent component = null;
    @Nullable
    private UUID graveId = null;
    @Nullable
    private GameProfile graveSkull = null;
    @Nullable
    private class_2561 graveText = null;
    @Nullable
    private class_2680 previousState = null;
    private boolean claimed = true;
    private static YigdConfig cachedConfig = YigdConfig.getConfig();

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(Yigd.GRAVE_BLOCK_ENTITY, pos, state);
    }

    public void setComponent(GraveComponent component) {
        this.component = component;
        this.setClaimed(component.getStatus() == GraveStatus.CLAIMED);
        this.graveSkull = component.getOwner();
        this.graveId = component.getGraveId();
        this.graveText = class_2561.method_30163((String)this.graveSkull.getName());
        this.method_5431();
    }

    public void setPreviousState(@Nullable class_2680 previousState) {
        this.previousState = previousState;
    }

    public void setGraveText(@Nullable class_2561 text) {
        this.graveText = text;
    }

    @Nullable
    public UUID getGraveId() {
        return this.graveId;
    }

    @Nullable
    public GameProfile getGraveSkull() {
        return this.graveSkull;
    }

    public void setGraveSkull(@Nullable GameProfile skull) {
        this.graveSkull = skull;
    }

    @Nullable
    public GraveComponent getComponent() {
        return this.component;
    }

    @Nullable
    public class_2680 getPreviousState() {
        return this.previousState;
    }

    public boolean isUnclaimed() {
        return !this.claimed;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    @Nullable
    public class_2561 getGraveText() {
        return this.graveText;
    }

    public void onBroken() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        Yigd.END_OF_TICK.add(() -> {
            Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(this.graveId);
            component.ifPresent(grave -> {
                if (grave.getStatus() == GraveStatus.UNCLAIMED) {
                    grave.onDestroyed();
                }
            });
        });
    }

    public class_2487 method_16887() {
        class_2487 nbt = this.method_38244();
        if (this.graveSkull != null) {
            nbt.method_10566("skull", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveSkull));
        }
        if (this.graveText != null) {
            nbt.method_10582("text", class_2561.class_2562.method_10867((class_2561)this.graveText));
        }
        nbt.method_10556("claimed", this.claimed);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10556("claimed", this.claimed);
        if (this.graveText != null) {
            nbt.method_10582("text", class_2561.class_2562.method_10867((class_2561)this.graveText));
        }
        if (this.graveSkull != null) {
            nbt.method_10566("skull", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveSkull));
        }
        if (this.graveId != null) {
            nbt.method_25927("graveId", this.graveId);
        }
        if (this.previousState != null) {
            nbt.method_10566("previousState", (class_2520)class_2512.method_10686((class_2680)this.previousState));
        }
    }

    public void method_11014(class_2487 nbt) {
        if (nbt.method_10545("skull")) {
            this.graveSkull = class_2512.method_10683((class_2487)nbt.method_10562("skull"));
        }
        if (nbt.method_10545("text")) {
            this.graveText = class_2561.class_2562.method_10877((String)nbt.method_10558("text"));
        }
        this.claimed = nbt.method_10577("claimed");
        if (nbt.method_10545("graveId")) {
            this.graveId = nbt.method_25926("graveId");
            if (this.component == null) {
                DeathInfoManager.INSTANCE.getGrave(this.graveId).ifPresent(this::setComponent);
            }
        }
        if (nbt.method_10545("previousState")) {
            class_7225.class_7226 registryEntryLookup = this.field_11863 != null ? this.field_11863.method_45448(class_7924.field_41254) : class_7923.field_41175.method_46771();
            this.previousState = class_2512.method_10681((class_7871)registryEntryLookup, (class_2487)nbt.method_10562("previousState"));
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 ignoredState, GraveBlockEntity be) {
        if (world.field_9236) {
            return;
        }
        if (be.component == null) {
            if (be.graveId == null) {
                return;
            }
            DeathInfoManager.INSTANCE.getGrave(be.graveId).ifPresent(be::setComponent);
            if (be.component == null) {
                return;
            }
        }
        if (world.method_8510() % 2400L == 0L) {
            cachedConfig = YigdConfig.getConfig();
        }
        GraveConfig.GraveTimeout timeoutConfig = GraveBlockEntity.cachedConfig.graveConfig.graveTimeout;
        if (!pos.equals((Object)be.component.getPos()) || !be.component.getWorldRegistryKey().equals((Object)world.method_27983())) {
            be.updatePosition((class_3218)world, pos);
        }
        if (!timeoutConfig.enabled || be.component.getStatus() != GraveStatus.UNCLAIMED) {
            return;
        }
        long timePassed = world.method_8510() - be.component.getCreationTime().getTime();
        int ticksPerSecond = 20;
        if (timeoutConfig.timeUnit.toSeconds(timeoutConfig.afterTime) * 20L <= timePassed) {
            be.component.setStatus(GraveStatus.DESTROYED);
            class_2680 newState = class_2246.field_10124.method_9564();
            class_2680 previousState = be.getPreviousState();
            if (YigdConfig.getConfig().graveConfig.replaceOldWhenClaimed && previousState != null) {
                newState = previousState;
            }
            be.component.replaceWithOld(newState, false);
            if (timeoutConfig.dropContentsOnTimeout) {
                be.component.dropAllGraveItems();
            }
        }
    }

    private void updatePosition(class_3218 world, class_2338 pos) {
        if (this.component == null) {
            return;
        }
        this.component.setPos(pos);
        this.component.setWorld(world);
        if (this.component.getStatus() == GraveStatus.DESTROYED || !this.claimed) {
            class_3222 player;
            this.component.setStatus(GraveStatus.UNCLAIMED);
            class_3324 playerManager = world.method_8503().method_3760();
            GameProfile owner = this.component.getOwner();
            class_3222 class_32222 = player = owner.getId() != null ? playerManager.method_14602(owner.getId()) : playerManager.method_14566(owner.getName());
            if (player != null) {
                Yigd.LOGGER.info("Grave belonging to {} resurfaced at X: {} / Y: {} / Z: {} / {}", new Object[]{this.component.getOwner().getName(), this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260(), this.component.getWorldRegistryKey().method_29177()});
                player.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.grave_relocated", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), world.method_27983().method_29177().toString()}));
            }
        }
    }
}

