/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.DropRuleEvent;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class AccessoriesCompat
implements InvModCompat<Map<String, AccessoriesInventoryGroup>> {
    @Override
    public String getModName() {
        return "accessories";
    }

    @Override
    public void clear(class_3222 player) {
        AccessoriesCapability.getOptionally((class_1309)player).ifPresent(inv -> inv.reset(false));
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> readNbt(class_2487 nbt) {
        HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
        for (String key : nbt.method_10541()) {
            class_2487 slotNbt = nbt.method_10562(key);
            class_2371<AccessoriesInventorySlot> normalSlot = InventoryComponent.listFromNbt(slotNbt.method_10562("normal"), itemNbt -> {
                String dropRuleString;
                class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.method_10545("dropRule") ? ((dropRuleString = itemNbt.method_10558("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.method_10545("visible") || itemNbt.method_10577("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.empty(true));
            class_2371<AccessoriesInventorySlot> cosmeticSlot = InventoryComponent.listFromNbt(slotNbt.method_10562("cosmetic"), itemNbt -> {
                String dropRuleString;
                class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.method_10545("dropRule") ? ((dropRuleString = itemNbt.method_10558("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.method_10545("visible") || itemNbt.method_10577("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.empty(true));
            inventory.put(key, new AccessoriesInventoryGroup(normalSlot, cosmeticSlot));
        }
        return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)inventory);
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> getNewComponent(class_3222 player) {
        return new AccessoriesCompatComponent(player);
    }

    public static class AccessoriesInventorySlot {
        public GraveItem graveItem;
        public boolean visible;

        public AccessoriesInventorySlot(class_1799 stack, com.b1n_ry.yigd.util.DropRule dropRule, boolean visible) {
            this.graveItem = new GraveItem(stack, dropRule);
            this.visible = visible;
        }

        public static AccessoriesInventorySlot empty(boolean visible) {
            return new AccessoriesInventorySlot(class_1799.field_8037, com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, visible);
        }
    }

    public record AccessoriesInventoryGroup(class_2371<AccessoriesInventorySlot> normal, class_2371<AccessoriesInventorySlot> cosmetic) {
        private void addAllNonEmptyToList(Collection<GraveItem> list) {
            this.addAllNonEmptyToList(list, slot -> new GraveItem(slot.graveItem.stack, slot.graveItem.dropRule));
        }

        private void addAllNonEmptyToStackList(Collection<class_1799> list) {
            this.addAllNonEmptyToList(list, slot -> slot.graveItem.stack);
        }

        private <T> void addAllNonEmptyToList(Collection<T> list, Function<AccessoriesInventorySlot, T> mapFunc) {
            for (AccessoriesInventorySlot slot : this.normal) {
                if (slot.graveItem.stack.method_7960()) continue;
                list.add(mapFunc.apply(slot));
            }
            for (AccessoriesInventorySlot slot : this.cosmetic) {
                if (slot.graveItem.stack.method_7960()) continue;
                list.add(mapFunc.apply(slot));
            }
        }
    }

    private static class AccessoriesCompatComponent
    extends CompatComponent<Map<String, AccessoriesInventoryGroup>> {
        public AccessoriesCompatComponent(class_3222 player) {
            super(player);
        }

        public AccessoriesCompatComponent(Map<String, AccessoriesInventoryGroup> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, AccessoriesInventoryGroup> getInventory(class_3222 player) {
            HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return inventory;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : containers.entrySet()) {
                boolean shouldRender;
                int i;
                class_2371 normalSlot = class_2371.method_10211();
                class_2371 cosmeticSlot = class_2371.method_10211();
                AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
                ExpandedSimpleContainer normal = container.getAccessories();
                ExpandedSimpleContainer cosmetic = container.getCosmeticAccessories();
                for (i = 0; i < normal.method_5439(); ++i) {
                    shouldRender = container.shouldRender(i);
                    normalSlot.add((Object)new AccessoriesInventorySlot(normal.method_5438(i).method_7972(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, shouldRender));
                }
                for (i = 0; i < cosmetic.method_5439(); ++i) {
                    shouldRender = container.shouldRender(i);
                    cosmeticSlot.add((Object)new AccessoriesInventorySlot(cosmetic.method_5438(i).method_7972(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, shouldRender));
                }
                inventory.put((String)entry.getKey(), new AccessoriesInventoryGroup((class_2371<AccessoriesInventorySlot>)normalSlot, (class_2371<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return inventory;
        }

        @Override
        public class_2371<GraveItem> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry mergeEntry : mergingInventory.entrySet()) {
                class_1799 currentStack;
                AccessoriesInventorySlot currentSlot;
                class_1799 mergingStack;
                AccessoriesInventorySlot mergingSlot;
                int i;
                String key = (String)mergeEntry.getKey();
                if (!((Map)this.inventory).containsKey(key)) {
                    ((AccessoriesInventoryGroup)mergeEntry.getValue()).addAllNonEmptyToList((Collection<GraveItem>)extraItems);
                    continue;
                }
                AccessoriesInventoryGroup mergingGroup = (AccessoriesInventoryGroup)mergeEntry.getValue();
                AccessoriesInventoryGroup thisGroup = (AccessoriesInventoryGroup)((Map)this.inventory).get(key);
                for (i = 0; i < mergingGroup.normal.size(); ++i) {
                    mergingSlot = (AccessoriesInventorySlot)mergingGroup.normal.get(i);
                    mergingStack = mergingSlot.graveItem.stack.method_7972();
                    if (mergingStack.method_7960()) continue;
                    if (thisGroup.normal.size() <= i) {
                        extraItems.add((Object)new GraveItem(mergingStack, mergingSlot.graveItem.dropRule));
                        continue;
                    }
                    currentSlot = (AccessoriesInventorySlot)thisGroup.normal.get(i);
                    currentStack = currentSlot.graveItem.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((class_1799)mergingStack, (SlotReference)SlotReference.of((class_1309)merger, (String)key, (int)i))) {
                        extraItems.add((Object)new GraveItem(currentStack, currentSlot.graveItem.dropRule));
                        thisGroup.normal.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingSlot.graveItem.dropRule, mergingSlot.visible));
                        continue;
                    }
                    if (!currentStack.method_7960()) {
                        extraItems.add((Object)new GraveItem(mergingStack, mergingSlot.graveItem.dropRule));
                        continue;
                    }
                    thisGroup.normal.set(i, (Object)mergingSlot);
                }
                for (i = 0; i < mergingGroup.cosmetic.size(); ++i) {
                    mergingSlot = (AccessoriesInventorySlot)mergingGroup.cosmetic.get(i);
                    mergingStack = mergingSlot.graveItem.stack.method_7972();
                    if (mergingStack.method_7960()) continue;
                    if (thisGroup.cosmetic.size() <= i) {
                        extraItems.add((Object)new GraveItem(mergingStack, mergingSlot.graveItem.dropRule));
                        continue;
                    }
                    currentSlot = (AccessoriesInventorySlot)thisGroup.cosmetic.get(i);
                    currentStack = currentSlot.graveItem.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((class_1799)mergingStack, (SlotReference)SlotReference.of((class_1309)merger, (String)key, (int)i))) {
                        extraItems.add((Object)new GraveItem(currentStack, currentSlot.graveItem.dropRule));
                        thisGroup.cosmetic.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingSlot.graveItem.dropRule, mergingSlot.visible));
                        continue;
                    }
                    if (!currentStack.method_7960()) {
                        extraItems.add((Object)new GraveItem(mergingStack, mergingSlot.graveItem.dropRule));
                        continue;
                    }
                    thisGroup.cosmetic.set(i, (Object)mergingSlot);
                }
            }
            return extraItems;
        }

        @Override
        public class_2371<class_1799> pullBindingCurseItems(class_3222 playerRef) {
            class_2371 noUnequipItems = class_2371.method_10211();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                boolean isBound;
                class_1799 stack;
                AccessoriesInventorySlot inventorySlot;
                int i;
                AccessoriesInventoryGroup inventoryGroup = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventoryGroup.normal.size(); ++i) {
                    inventorySlot = (AccessoriesInventorySlot)inventoryGroup.normal.get(i);
                    stack = inventorySlot.graveItem.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((class_1799)stack, (SlotReference)SlotReference.of((class_1309)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    inventorySlot.graveItem.stack = class_1799.field_8037;
                }
                for (i = 0; i < inventoryGroup.cosmetic.size(); ++i) {
                    inventorySlot = (AccessoriesInventorySlot)inventoryGroup.cosmetic.get(i);
                    stack = inventorySlot.graveItem.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((class_1799)stack, (SlotReference)SlotReference.of((class_1309)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    inventorySlot.graveItem.stack = class_1799.field_8037;
                }
            }
            return noUnequipItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return extraItems;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventorySlot slot;
                int i;
                String key = (String)entry.getKey();
                if (!containers.containsKey(key)) {
                    ((AccessoriesInventoryGroup)entry.getValue()).addAllNonEmptyToStackList((Collection<class_1799>)extraItems);
                    continue;
                }
                AccessoriesContainer container = (AccessoriesContainer)containers.get(key);
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                ExpandedSimpleContainer normalAccessories = container.getAccessories();
                ExpandedSimpleContainer cosmeticAccessories = container.getCosmeticAccessories();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    if (i >= normalAccessories.method_5439()) {
                        extraItems.add((Object)slot.graveItem.stack.method_7972());
                        continue;
                    }
                    container.renderOptions().set(i, slot.visible);
                    if (slot.graveItem.stack.method_7960()) continue;
                    normalAccessories.method_5447(i, slot.graveItem.stack.method_7972());
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    if (i >= cosmeticAccessories.method_5439()) {
                        extraItems.add((Object)slot.graveItem.stack.method_7972());
                        continue;
                    }
                    container.renderOptions().set(i, slot.visible);
                    if (slot.graveItem.stack.method_7960()) continue;
                    cosmeticAccessories.method_5447(i, slot.graveItem.stack.method_7972());
                }
                container.markChanged(false);
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                com.b1n_ry.yigd.util.DropRule defaultDropRule;
                class_1799 stack;
                AccessoriesInventorySlot slot;
                int i;
                String key = (String)entry.getKey();
                AccessoriesInventoryGroup inventoryGroup = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventoryGroup.normal.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventoryGroup.normal.get(i);
                    stack = slot.graveItem.stack;
                    GraveItem graveItem = slot.graveItem;
                    graveItem.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((class_1799)stack).getDropRule(stack, SlotReference.of((class_1309)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                            }
                            yield defaultDropRule;
                        }
                    };
                }
                for (i = 0; i < inventoryGroup.cosmetic.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventoryGroup.cosmetic.get(i);
                    stack = slot.graveItem.stack;
                    GraveItem graveItem = slot.graveItem;
                    graveItem.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((class_1799)stack).getDropRule(stack, SlotReference.of((class_1309)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
                            }
                            yield defaultDropRule;
                        }
                    };
                }
            }
        }

        @Override
        public class_2371<GraveItem> getAsGraveItemList() {
            class_2371 allItems = class_2371.method_10211();
            for (AccessoriesInventoryGroup group : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot slot : group.normal) {
                    allItems.add((Object)slot.graveItem);
                }
                for (AccessoriesInventorySlot slot : group.cosmetic) {
                    allItems.add((Object)slot.graveItem);
                }
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, AccessoriesInventoryGroup>> filterInv(Predicate<com.b1n_ry.yigd.util.DropRule> predicate) {
            HashMap<String, AccessoriesInventoryGroup> filtered = new HashMap<String, AccessoriesInventoryGroup>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                class_2371 normalSlot = class_2371.method_10211();
                class_2371 cosmeticSlot = class_2371.method_10211();
                for (AccessoriesInventorySlot slot : inventorySlot.normal) {
                    if (predicate.test(slot.graveItem.dropRule)) {
                        normalSlot.add((Object)slot);
                        continue;
                    }
                    normalSlot.add((Object)AccessoriesInventorySlot.empty(slot.visible));
                }
                for (AccessoriesInventorySlot slot : inventorySlot.cosmetic) {
                    if (predicate.test(slot.graveItem.dropRule)) {
                        cosmeticSlot.add((Object)slot);
                        continue;
                    }
                    cosmeticSlot.add((Object)AccessoriesInventorySlot.empty(slot.visible));
                }
                filtered.put((String)entry.getKey(), new AccessoriesInventoryGroup((class_2371<AccessoriesInventorySlot>)normalSlot, (class_2371<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot slot : inventorySlot.normal) {
                    class_1799 stack = slot.graveItem.stack;
                    if (!predicate.test(stack)) continue;
                    stack.method_7934(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                Collections.fill(inventorySlot.normal, AccessoriesInventorySlot.empty(true));
                Collections.fill(inventorySlot.cosmetic, AccessoriesInventorySlot.empty(true));
            }
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                class_2487 slotNbt = new class_2487();
                class_2487 normalNbt = InventoryComponent.listToNbt(inventorySlot.normal, slot -> {
                    class_2487 itemNbt = new class_2487();
                    if (!slot.graveItem.stack.method_7960()) {
                        slot.graveItem.stack.method_7953(itemNbt);
                    }
                    itemNbt.method_10582("dropRule", slot.graveItem.dropRule.name());
                    itemNbt.method_10556("visible", slot.visible);
                    return itemNbt;
                }, slot -> slot.graveItem.stack.method_7960() && slot.visible);
                class_2487 cosmeticNbt = InventoryComponent.listToNbt(inventorySlot.cosmetic, slot -> {
                    class_2487 itemNbt = new class_2487();
                    if (!slot.graveItem.stack.method_7960()) {
                        slot.graveItem.stack.method_7953(itemNbt);
                    }
                    itemNbt.method_10582("dropRule", slot.graveItem.dropRule.name());
                    itemNbt.method_10556("visible", slot.visible);
                    return itemNbt;
                }, slot -> slot.graveItem.stack.method_7960() && slot.visible);
                slotNbt.method_10566("normal", (class_2520)normalNbt);
                slotNbt.method_10566("cosmetic", (class_2520)cosmeticNbt);
                nbt.method_10566((String)entry.getKey(), (class_2520)slotNbt);
            }
            return nbt;
        }
    }
}

