/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.EffectComponent;
import com.b1n_ry.yigd.components.ExpComponent;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.RespawnConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RespawnComponent {
    @Nullable
    private InventoryComponent soulboundInventory;
    @Nullable
    private ExpComponent soulboundExp;
    private final EffectComponent respawnEffects;
    private boolean graveGenerated = false;

    public RespawnComponent(class_3222 player) {
        this.respawnEffects = new EffectComponent(player);
    }

    private RespawnComponent(@Nullable InventoryComponent soulboundInventory, @Nullable ExpComponent expComponent, EffectComponent effectComponent) {
        this.soulboundInventory = soulboundInventory;
        this.respawnEffects = effectComponent;
        this.soulboundExp = expComponent;
    }

    public void setSoulboundInventory(@NotNull InventoryComponent component) {
        this.soulboundInventory = component;
    }

    public void setSoulboundExp(@NotNull ExpComponent component) {
        this.soulboundExp = component;
    }

    @Nullable
    public ExpComponent getSoulboundExp() {
        return this.soulboundExp;
    }

    public void setGraveGenerated(boolean graveGenerated) {
        this.graveGenerated = graveGenerated;
    }

    public boolean wasGraveGenerated() {
        return this.graveGenerated;
    }

    public void primeForRespawn(GameProfile profile) {
        DeathInfoManager.INSTANCE.addRespawnComponent(profile, this);
        DeathInfoManager.INSTANCE.method_80();
    }

    public boolean isEmpty() {
        return !(this.soulboundInventory != null && !this.soulboundInventory.isEmpty() || this.soulboundExp != null && !this.soulboundExp.isEmpty());
    }

    public void apply(class_3222 player) {
        List<GraveComponent> playerGraves;
        class_1799 key;
        boolean turned;
        class_1799 scroll;
        boolean turned2;
        if (this.soulboundInventory != null) {
            class_2371 extraItems = class_2371.method_10211();
            if (YigdConfig.getConfig().respawnConfig.treatBindingCurse) {
                extraItems.addAll(this.soulboundInventory.pullBindingCurseItems(player));
            }
            extraItems.addAll(this.soulboundInventory.applyToPlayer(player));
            double x = player.method_23317();
            double y = player.method_23318();
            double z = player.method_23321();
            class_3218 world = player.method_51469();
            for (class_1799 stack : extraItems) {
                InventoryComponent.dropItemIfToBeDropped(stack, x, y, z, world);
            }
        }
        YigdConfig config = YigdConfig.getConfig();
        ExtraFeaturesConfig extraFeaturesConfig = config.extraFeatures;
        if (extraFeaturesConfig.deathScroll.enabled && extraFeaturesConfig.deathScroll.receiveOnRespawn && (turned2 = Yigd.DEATH_SCROLL_ITEM.bindStackToLatestDeath(player, scroll = Yigd.DEATH_SCROLL_ITEM.method_7854()))) {
            player.method_7270(scroll);
        }
        if (extraFeaturesConfig.graveKeys.enabled && extraFeaturesConfig.graveKeys.receiveOnRespawn && (turned = Yigd.GRAVE_KEY_ITEM.bindStackToLatestGrave((class_1657)player, key = Yigd.GRAVE_KEY_ITEM.method_7854()))) {
            player.method_7270(key);
        }
        if (extraFeaturesConfig.graveCompass.receiveOnRespawn && !(playerGraves = DeathInfoManager.INSTANCE.getBackupData(player.method_7334())).isEmpty()) {
            GraveComponent latestGrave = playerGraves.get(playerGraves.size() - 1);
            GraveCompassHelper.giveCompass(player, latestGrave.getGraveId(), latestGrave.getPos(), latestGrave.getWorldRegistryKey());
        }
        for (RespawnConfig.ExtraItemDrop extraItemDrop : config.respawnConfig.extraItemDrops) {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(extraItemDrop.itemId));
            class_1799 stack = new class_1799((class_1935)item, extraItemDrop.count);
            try {
                if (!extraItemDrop.itemNbt.isEmpty()) {
                    stack.method_7980(class_2512.method_32260((String)extraItemDrop.itemNbt));
                }
            }
            catch (CommandSyntaxException e) {
                Yigd.LOGGER.error("Could not give an item with NBT to player on respawn. Invalid NBT. Falling back to item without NBT");
            }
            player.method_7270(stack);
        }
        if (this.soulboundExp != null) {
            this.soulboundExp.applyToPlayer(player);
        }
        this.respawnEffects.applyToPlayer(player);
        DeathInfoManager.INSTANCE.removeRespawnComponent(player.method_7334());
        DeathInfoManager.INSTANCE.method_80();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        if (this.soulboundInventory != null) {
            nbt.method_10566("inventory", (class_2520)this.soulboundInventory.toNbt());
        }
        if (this.soulboundExp != null) {
            nbt.method_10566("exp", (class_2520)this.soulboundExp.toNbt());
        }
        nbt.method_10566("effects", (class_2520)this.respawnEffects.toNbt());
        return nbt;
    }

    public static RespawnComponent fromNbt(class_2487 nbt) {
        InventoryComponent soulboundInventory = null;
        if (nbt.method_10545("inventory")) {
            class_2487 inventoryNbt = nbt.method_10562("inventory");
            soulboundInventory = InventoryComponent.fromNbt(inventoryNbt);
        }
        ExpComponent expComponent = null;
        if (nbt.method_10545("exp")) {
            class_2487 expNbt = nbt.method_10562("exp");
            expComponent = ExpComponent.fromNbt(expNbt);
        }
        class_2487 effectsNbt = nbt.method_10562("effects");
        EffectComponent effectComponent = EffectComponent.fromNbt(effectsNbt);
        return new RespawnComponent(soulboundInventory, expComponent, effectComponent);
    }
}

