/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.util;

import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.CommandConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.packets.LightGraveData;
import com.b1n_ry.yigd.packets.LightPlayerData;
import com.b1n_ry.yigd.packets.ServerPacketHandler;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class YigdCommands {
    public static void register() {
        YigdConfig config = YigdConfig.getConfig();
        CommandConfig commandConfig = config.commandConfig;
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandConfig.mainCommand).requires(Permissions.require((String)"yigd.command.base_permission", (int)commandConfig.basePermissionLevel))).executes(YigdCommands::baseCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"latest").requires(Permissions.require((String)"yigd.command.view_latest", (int)commandConfig.viewLatestPermissionLevel))).executes(YigdCommands::viewLatest))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"grave").requires(Permissions.require((String)"yigd.command.view_self", (int)commandConfig.viewSelfPermissionLevel))).executes(YigdCommands::viewSelf)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(Permissions.require((String)"yigd.command.view_user", (int)commandConfig.viewUserPermissionLevel))).executes(context -> YigdCommands.viewUser((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"moderate").requires(Permissions.require((String)"yigd.command.view_all", (int)commandConfig.viewAllPermissionLevel))).executes(YigdCommands::viewAll))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").requires(Permissions.require((String)"yigd.command.restore", (int)commandConfig.restorePermissionLevel))).executes(YigdCommands::restore)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> YigdCommands.restore((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(context -> YigdCommands.restore((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), class_2262.method_48299((CommandContext)context, (String)"pos"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rob").requires(Permissions.require((String)"yigd.command.rob", (int)commandConfig.robPermissionLevel))).then(class_2170.method_9244((String)"victim", (ArgumentType)class_2186.method_9305()).executes(context -> YigdCommands.rob((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"victim"))))).then(class_2170.method_9244((String)"grave_id", (ArgumentType)class_5242.method_27643()).executes(context -> YigdCommands.rob((CommandContext<class_2168>)context, class_5242.method_27645((CommandContext)context, (String)"grave_id")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").requires(Permissions.require((String)"yigd.command.whitelist", (int)commandConfig.whitelistPermissionLevel))).executes(YigdCommands::showListType)).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(context -> YigdCommands.addToList((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"target")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(context -> YigdCommands.removeFromList((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"target")))))).then(class_2170.method_9247((String)"toggle").executes(YigdCommands::toggleListType))).then(class_2170.method_9247((String)"list").executes(YigdCommands::showList)))));
    }

    private static int baseCommand(CommandContext<class_2168> context) {
        return YigdCommands.viewSelf(context);
    }

    private static int viewLatest(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return -1;
        }
        List<GraveComponent> components = DeathInfoManager.INSTANCE.getBackupData(player.method_7334());
        ArrayList<GraveComponent> unClaimedGraves = new ArrayList<GraveComponent>(components);
        unClaimedGraves.removeIf(graveComponent -> graveComponent.getStatus() != GraveStatus.UNCLAIMED);
        if (unClaimedGraves.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.latest.fail"));
            return -1;
        }
        ServerPacketHandler.sendGraveOverviewPacket(player, (GraveComponent)unClaimedGraves.get(0));
        return 1;
    }

    private static int viewSelf(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return -1;
        }
        return YigdCommands.viewUser(context, player);
    }

    private static int viewUser(CommandContext<class_2168> context, class_3222 user) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (user == null) {
            return -1;
        }
        GameProfile profile = user.method_7334();
        List<GraveComponent> components = DeathInfoManager.INSTANCE.getBackupData(profile);
        ArrayList<LightGraveData> lightGraveData = new ArrayList<LightGraveData>();
        for (GraveComponent component : components) {
            lightGraveData.add(component.toLightData());
        }
        ServerPacketHandler.sendGraveSelectionPacket(player, profile, lightGraveData);
        return 1;
    }

    private static int viewAll(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Map<GameProfile, List<GraveComponent>> players = DeathInfoManager.INSTANCE.getPlayerGraves();
        ArrayList<LightPlayerData> lightPlayerData = new ArrayList<LightPlayerData>();
        players.forEach((profile, components) -> {
            int unclaimed = 0;
            int destroyed = 0;
            for (GraveComponent component : components) {
                switch (component.getStatus()) {
                    case UNCLAIMED: {
                        ++unclaimed;
                        break;
                    }
                    case DESTROYED: {
                        ++destroyed;
                    }
                }
            }
            LightPlayerData lightData = new LightPlayerData(components.size(), unclaimed, destroyed, (GameProfile)profile);
            lightPlayerData.add(lightData);
        });
        ServerPacketHandler.sendPlayerSelectionPacket(player, lightPlayerData);
        return 1;
    }

    private static int restore(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return -1;
        }
        return YigdCommands.restore(context, player);
    }

    private static int restore(CommandContext<class_2168> context, class_3222 target) {
        GameProfile profile = target.method_7334();
        ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(profile));
        graves.removeIf(graveComponent -> graveComponent.getStatus() == GraveStatus.CLAIMED);
        int size = graves.size();
        if (size < 1) {
            return -1;
        }
        return YigdCommands.restore(context, target, (GraveComponent)graves.get(size - 1));
    }

    private static int restore(CommandContext<class_2168> context, class_3222 target, class_2338 pos) {
        GameProfile profile = target.method_7334();
        ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(profile));
        graves.removeIf(graveComponent -> graveComponent.getStatus() == GraveStatus.CLAIMED);
        for (GraveComponent grave : graves) {
            if (!grave.getPos().equals((Object)pos)) continue;
            return YigdCommands.restore(context, target, grave);
        }
        return -1;
    }

    private static int restore(CommandContext<class_2168> context, class_3222 target, GraveComponent component) {
        component.applyToPlayer(target, target.method_51469(), target.method_19538(), true);
        component.setStatus(GraveStatus.CLAIMED);
        component.removeGraveBlock();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.yigd.command.restore.success"));
        return 1;
    }

    private static int rob(CommandContext<class_2168> context, class_3222 victim) {
        GameProfile profile = victim.method_7334();
        ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(profile));
        graves.removeIf(graveComponent -> graveComponent.getStatus() != GraveStatus.UNCLAIMED);
        int size = graves.size();
        if (size < 1) {
            return -1;
        }
        GraveComponent component = (GraveComponent)graves.get(size - 1);
        return YigdCommands.rob(context, component);
    }

    private static int rob(CommandContext<class_2168> context, UUID graveId) {
        Optional<GraveComponent> component = DeathInfoManager.INSTANCE.getGrave(graveId);
        return component.map(graveComponent -> YigdCommands.rob(context, graveComponent)).orElse(-1);
    }

    private static int rob(CommandContext<class_2168> context, GraveComponent component) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return -1;
        }
        component.applyToPlayer(player, ((class_2168)context.getSource()).method_9225(), player.method_19538(), false);
        component.setStatus(GraveStatus.CLAIMED);
        component.removeGraveBlock();
        player.method_43496((class_2561)class_2561.method_43471((String)"text.yigd.command.rob.success"));
        return 1;
    }

    private static int showListType(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.yigd.command.whitelist.show_current", (Object[])new Object[]{DeathInfoManager.INSTANCE.getGraveListMode().name()}));
        return 1;
    }

    private static int addToList(CommandContext<class_2168> context, Collection<class_3222> players) {
        int i = 0;
        for (class_3222 player : players) {
            DeathInfoManager.INSTANCE.addToList(player.method_7334());
            ++i;
        }
        DeathInfoManager.INSTANCE.method_80();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.yigd.command.whitelist.added_players", (Object[])new Object[]{i, DeathInfoManager.INSTANCE.getGraveListMode().name()}));
        return i > 0 ? 1 : 0;
    }

    private static int removeFromList(CommandContext<class_2168> context, Collection<class_3222> players) {
        int i = 0;
        for (class_3222 player : players) {
            if (!DeathInfoManager.INSTANCE.removeFromList(player.method_7334())) continue;
            ++i;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.yigd.command.whitelist.removed_players", (Object[])new Object[]{i, DeathInfoManager.INSTANCE.getGraveListMode().name()}));
        return i > 0 ? 1 : 0;
    }

    private static int toggleListType(CommandContext<class_2168> context) {
        ListMode listMode = DeathInfoManager.INSTANCE.getGraveListMode();
        ListMode newMode = listMode == ListMode.WHITELIST ? ListMode.BLACKLIST : ListMode.WHITELIST;
        DeathInfoManager.INSTANCE.setGraveListMode(newMode);
        DeathInfoManager.INSTANCE.method_80();
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.yigd.command.whitelist.toggle", (Object[])new Object[]{newMode.name()}));
        return 1;
    }

    private static int showList(CommandContext<class_2168> context) {
        ListMode listMode = DeathInfoManager.INSTANCE.getGraveListMode();
        Set<GameProfile> affectedPlayers = DeathInfoManager.INSTANCE.getAffectedPlayers();
        StringJoiner joiner = new StringJoiner(", ");
        for (GameProfile profile : affectedPlayers) {
            joiner.add(profile.getName());
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)(listMode.name() + ": %s" + String.valueOf(joiner))));
        return 1;
    }
}

