/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.render;

import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.events.RenderGlowingGraveEvent;
import com.b1n_ry.yigd.mixin.accessor.WorldRendererAccessor;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_4730;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5603;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_836;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class GraveBlockEntityRenderer
implements class_827<GraveBlockEntity> {
    private static final Gson GSON = new Gson();
    private final Map<class_2484.class_2485, class_5598> skullModels;
    private final class_327 textRenderer;
    private final class_310 client;
    private final boolean adaptRenderer;
    private static class_630 graveModel;
    @Nullable
    private static TextRenderInfo textRenderInfo;
    @Nullable
    private static SkullRenderInfo skullRenderInfo;
    private static final Map<String, class_4730> CUBOID_SPRITES;
    private static final class_1921 OUTLINE_RENDER_LAYER;
    public static boolean renderOutlineShader;

    public GraveBlockEntityRenderer(class_5614.class_5615 context) {
        this.skullModels = class_836.method_32160((class_5599)context.method_32142());
        this.textRenderer = context.method_32143();
        this.client = class_310.method_1551();
        this.adaptRenderer = YigdConfig.getConfig().graveRendering.adaptRenderer;
    }

    public void render(GraveBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        YigdConfig.GraveRendering config = YigdConfig.getConfig().graveRendering;
        if (!config.useCustomFeatureRenderer) {
            return;
        }
        class_2680 state = entity.method_11010();
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        float rotation = switch (direction) {
            case class_2350.field_11035 -> (float)Math.PI;
            case class_2350.field_11039 -> 1.5707964f;
            case class_2350.field_11034 -> 4.712389f;
            default -> 0.0f;
        };
        matrices.method_22903();
        matrices.method_49278(class_7833.field_40716.rotation(rotation), 0.5f, 0.5f, 0.5f);
        if (config.useGlowingEffect && entity.isUnclaimed()) {
            class_4618 consumerProvider = ((WorldRendererAccessor)this.client.field_1769).getBufferBuilders().method_23003();
            this.renderGlowingOutline(entity, tickDelta, matrices, (class_4597)consumerProvider, light, overlay);
        }
        if (config.useSkullRenderer) {
            this.renderOwnerSkull(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        if (config.useTextRenderer) {
            this.renderGraveText(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        this.renderGraveModel(entity, tickDelta, matrices, vertexConsumers, light, overlay);
        matrices.method_22909();
    }

    private void renderOwnerSkull(GraveBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_9296 skullOwner = entity.getGraveSkull();
        if (skullOwner == null) {
            return;
        }
        class_2484.class_2486 type = class_2484.class_2486.field_11510;
        class_1921 renderLayer = class_836.method_3578((class_2484.class_2485)type, (class_9296)skullOwner);
        this.renderSkull(entity, tickDelta, matrices, vertexConsumers, light, overlay, renderLayer);
    }

    private void renderSkull(GraveBlockEntity ignoredEntity, float ignoredTickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int ignoredOverlay, class_1921 renderLayer) {
        if (skullRenderInfo == null) {
            return;
        }
        class_2484.class_2486 type = class_2484.class_2486.field_11510;
        class_5598 model = this.skullModels.get(type);
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.25f, 0.5f);
        int[] rotation = GraveBlockEntityRenderer.skullRenderInfo.rotation;
        matrices.method_22904(0.0, (double)(-(4.0f - GraveBlockEntityRenderer.skullRenderInfo.height)) / 16.0, (double)(-(8.0f - GraveBlockEntityRenderer.skullRenderInfo.depth)) / 16.0);
        Quaternionf angle = new Quaternionf().rotateXYZ((float)Math.toRadians(rotation[0]), (float)Math.toRadians(rotation[1]), (float)Math.toRadians(rotation[2]));
        matrices.method_22907(angle);
        matrices.method_22905(GraveBlockEntityRenderer.skullRenderInfo.scaleFace, GraveBlockEntityRenderer.skullRenderInfo.scaleFace, GraveBlockEntityRenderer.skullRenderInfo.scaleDepth);
        matrices.method_46416(-0.5f, -0.25f, -0.5f);
        class_836.method_32161(null, (float)0.0f, (float)0.0f, (class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_5598)model, (class_1921)renderLayer);
        matrices.method_22909();
    }

    private void renderGraveText(GraveBlockEntity entity, float ignoredTickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int ignoredOverlay) {
        class_2561 graveText = entity.getGraveText();
        if (graveText == null || textRenderInfo == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(0.5, (double)(GraveBlockEntityRenderer.textRenderInfo.height / 16.0f), (double)(GraveBlockEntityRenderer.textRenderInfo.depth / 16.0f - 1.0E-4f));
        matrices.method_22905(-1.0f, -1.0f, 0.0f);
        int textWidth = this.textRenderer.method_1727(graveText.getString());
        float scale = GraveBlockEntityRenderer.textRenderInfo.width / ((float)textWidth * 16.0f);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22904((double)(-textWidth) / 2.0, -4.5, 0.0);
        this.textRenderer.method_30882(graveText, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22909();
    }

    private void renderGraveModel(GraveBlockEntity entity, float ignoredTickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        for (Map.Entry<String, class_4730> cuboid : CUBOID_SPRITES.entrySet()) {
            class_1937 world;
            String key = cuboid.getKey();
            class_630 part = graveModel.method_32086(key);
            if (this.adaptRenderer && key.equals("ground") && (world = entity.method_10997()) != null) {
                class_2338 underPos = entity.method_11016().method_10074();
                class_2680 blockUnder = entity.method_10997().method_8320(underPos);
                if (blockUnder != null && blockUnder.method_26216((class_1922)world, underPos)) {
                    class_630.class_628 cuboidPart = part.method_22700(world.field_9229);
                    float scaleX = cuboidPart.field_3648 - cuboidPart.field_3645;
                    float scaleZ = cuboidPart.field_3646 - cuboidPart.field_3643;
                    matrices.method_22903();
                    matrices.method_46416(cuboidPart.field_3645 / 16.0f + 5.0E-4f, cuboidPart.field_3647 / 16.0f - 1.0f, cuboidPart.field_3643 / 16.0f + 5.0E-4f);
                    matrices.method_22905(0.999f * (scaleX / 16.0f), 1.0f, 0.999f * (scaleZ / 16.0f));
                    this.client.method_1541().method_3355(blockUnder, underPos, (class_1920)world, matrices, vertexConsumers.getBuffer(class_1921.method_23581()), false, world.field_9229);
                    matrices.method_22909();
                    continue;
                }
            }
            class_4588 consumer = cuboid.getValue().method_24145(vertexConsumers, class_1921::method_23576);
            part.method_22698(matrices, consumer, light, overlay);
        }
    }

    private void renderGlowingOutline(GraveBlockEntity entity, float ignoredTickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_746 player = this.client.field_1724;
        if (!((RenderGlowingGraveEvent)RenderGlowingGraveEvent.EVENT.invoker()).canRenderOutline(entity, player)) {
            return;
        }
        class_4588 consumer = vertexConsumers.getBuffer(OUTLINE_RENDER_LAYER);
        renderOutlineShader = true;
        graveModel.method_22698(matrices, consumer, light, overlay);
        if (YigdConfig.getConfig().graveRendering.useSkullRenderer) {
            this.renderSkull(entity, ignoredTickDelta, matrices, vertexConsumers, light, overlay, OUTLINE_RENDER_LAYER);
        }
    }

    public static void reloadModelFromJson(JsonObject json) throws IllegalStateException {
        CUBOID_SPRITES.clear();
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        JsonArray textureSize = json.getAsJsonArray("texture_size");
        JsonObject textures = json.getAsJsonObject("textures");
        JsonArray elements = json.getAsJsonArray("elements");
        JsonObject features = json.has("features") ? json.getAsJsonObject("features") : null;
        int uvX = textureSize.get(0).getAsInt();
        int uvY = textureSize.get(1).getAsInt();
        HashMap<String, String> nameIds = new HashMap<String, String>();
        for (Map.Entry e : textures.entrySet()) {
            String key = (String)e.getKey();
            String value = ((JsonElement)e.getValue()).getAsString();
            nameIds.put(key, value);
        }
        int i = 0;
        for (JsonElement e : elements) {
            JsonObject o = e.getAsJsonObject();
            String name = o.has("name") ? o.get("name").getAsString() : String.valueOf(i++);
            JsonArray from = o.getAsJsonArray("from");
            JsonArray to = o.getAsJsonArray("to");
            JsonObject faces = o.getAsJsonObject("faces");
            float minX = Float.MAX_VALUE;
            float minY = Float.MAX_VALUE;
            String textureName = "";
            for (Map.Entry face : faces.entrySet()) {
                JsonObject value = ((JsonElement)face.getValue()).getAsJsonObject();
                JsonArray uv = value.getAsJsonArray("uv");
                textureName = value.get("texture").getAsString();
                minX = Math.min(minX, uv.get(0).getAsFloat());
                minY = Math.min(minY, uv.get(1).getAsFloat());
            }
            minX *= (float)uvX / 16.0f;
            minY *= (float)uvY / 16.0f;
            if (nameIds.containsKey(textureName = textureName.replaceFirst("#", ""))) {
                textureName = (String)nameIds.get(textureName);
            }
            class_2960 texture = new class_2960(textureName);
            class_4730 sprite = new class_4730(class_1723.field_21668, texture);
            CUBOID_SPRITES.put(name, sprite);
            float fromX = from.get(0).getAsFloat();
            float fromY = from.get(1).getAsFloat();
            float fromZ = from.get(2).getAsFloat();
            float toX = to.get(0).getAsFloat();
            float toY = to.get(1).getAsFloat();
            float toZ = to.get(2).getAsFloat();
            float lowerX = Math.min(fromX, toX);
            float lowerY = Math.min(fromY, toY);
            float lowerZ = Math.min(fromZ, toZ);
            float higherX = Math.max(fromX, toX);
            float higherY = Math.max(fromY, toY);
            float higherZ = Math.max(fromZ, toZ);
            GraveBlockEntityRenderer.addChildPart(root, name, (int)minX, (int)minY, lowerX, lowerY, lowerZ, higherX - lowerX, higherY - lowerY, higherZ - lowerZ);
        }
        if (features != null) {
            if (features.has("text")) {
                textRenderInfo = (TextRenderInfo)GSON.fromJson(features.get("text"), TextRenderInfo.class);
            }
            if (features.has("skull")) {
                skullRenderInfo = (SkullRenderInfo)GSON.fromJson(features.get("skull"), SkullRenderInfo.class);
            }
        }
        graveModel = class_5607.method_32110((class_5609)modelData, (int)uvX, (int)uvY).method_32109();
    }

    private static class_630 getGraveModel() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        GraveBlockEntityRenderer.addChildPart(root, "ground", 0, 0, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f);
        GraveBlockEntityRenderer.addChildPart(root, "base", 0, 21, 2.0f, 1.0f, 10.0f, 12.0f, 2.0f, 5.0f);
        GraveBlockEntityRenderer.addChildPart(root, "bust", 0, 28, 3.0f, 3.0f, 11.0f, 10.0f, 12.0f, 3.0f);
        GraveBlockEntityRenderer.addChildPart(root, "top", 0, 17, 4.0f, 15.0f, 11.0f, 8.0f, 1.0f, 3.0f);
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64).method_32109();
    }

    private static void addChildPart(class_5610 root, String name, int uvX, int uvY, float minX, float minY, float minZ, float sizeX, float sizeY, float sizeZ) {
        root.method_32117(name, class_5606.method_32108().method_32101(uvX, uvY).method_32097(minX, minY, minZ, sizeX, sizeY, sizeZ), class_5603.method_32091((float)(sizeX + minX * 2.0f), (float)(sizeY + minY * 2.0f), (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
    }

    static {
        textRenderInfo = null;
        skullRenderInfo = null;
        CUBOID_SPRITES = new HashMap<String, class_4730>();
        renderOutlineShader = false;
        graveModel = GraveBlockEntityRenderer.getGraveModel();
        OUTLINE_RENDER_LAYER = class_1921.method_23287((class_2960)new class_2960("textures/misc/white.png"));
    }

    private record SkullRenderInfo(float depth, float height, int[] rotation, float scaleFace, float scaleDepth) {
    }

    private record TextRenderInfo(float depth, float height, float width) {
    }
}

