/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1269;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9296;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DeathInfoManager
extends class_18 {
    public static DeathInfoManager INSTANCE = new DeathInfoManager();
    private final Map<class_9296, RespawnComponent> respawnEffects = new HashMap<class_9296, RespawnComponent>();
    private final Map<class_9296, List<GraveComponent>> graveBackups = new HashMap<class_9296, List<GraveComponent>>();
    private final Map<UUID, GraveComponent> graveMap = new HashMap<UUID, GraveComponent>();
    private ListMode graveListMode = ListMode.BLACKLIST;
    private final Set<class_9296> affectedPlayers = new HashSet<class_9296>();

    public void clear() {
        this.respawnEffects.clear();
        this.graveBackups.clear();
        this.graveMap.clear();
        this.affectedPlayers.clear();
    }

    public Set<class_9296> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public static class_18.class_8645<DeathInfoManager> getPersistentStateType(MinecraftServer server) {
        return new class_18.class_8645(DeathInfoManager::new, (nbt, lookupRegistry) -> DeathInfoManager.fromNbt(nbt, lookupRegistry, server), null);
    }

    public class_1269 delete(UUID graveId) {
        GraveComponent component = this.graveMap.get(graveId);
        if (component == null) {
            return class_1269.field_5814;
        }
        class_9296 profile = component.getOwner();
        this.graveMap.remove(graveId);
        if (!this.graveBackups.containsKey(profile)) {
            return class_1269.field_5811;
        }
        this.graveBackups.get(profile).remove(component);
        if (component.getStatus() != GraveStatus.UNCLAIMED) {
            return class_1269.field_5812;
        }
        return component.removeGraveBlock() ? class_1269.field_5812 : class_1269.field_5811;
    }

    public void addRespawnComponent(class_9296 profile, RespawnComponent component) {
        this.respawnEffects.put(profile, component);
    }

    public Optional<RespawnComponent> getRespawnComponent(class_9296 profile) {
        return Optional.ofNullable(this.respawnEffects.get(profile));
    }

    public Map<class_9296, List<GraveComponent>> getPlayerGraves() {
        return this.graveBackups;
    }

    public void removeRespawnComponent(class_9296 profile) {
        this.respawnEffects.remove(profile);
    }

    public void addBackup(class_9296 profile, GraveComponent component) {
        YigdConfig config = YigdConfig.getConfig();
        if (!this.graveBackups.containsKey(profile)) {
            this.graveBackups.put(profile, new ArrayList());
        }
        List<GraveComponent> playerGraves = this.graveBackups.get(profile);
        playerGraves.add(component);
        this.graveMap.put(component.getGraveId(), component);
        if (playerGraves.size() > config.graveConfig.maxBackupsPerPerson) {
            GraveComponent toBeRemoved = playerGraves.getFirst();
            this.delete(toBeRemoved.getGraveId());
            if (toBeRemoved.getStatus() == GraveStatus.UNCLAIMED && config.graveConfig.dropFromOldestWhenDeleted) {
                toBeRemoved.dropAll();
            }
        }
        if (config.extraFeatures.graveCompass.pointToClosest != YigdConfig.ExtraFeatures.GraveCompassConfig.CompassGraveTarget.DISABLED && component.getStatus() == GraveStatus.UNCLAIMED) {
            GraveCompassHelper.addGravePosition(component.getWorldRegistryKey(), component.getPos(), profile.comp_2411().orElse(null));
        }
    }

    @NotNull
    public List<GraveComponent> getBackupData(class_9296 profile) {
        return this.graveBackups.computeIfAbsent(profile, k -> new ArrayList());
    }

    public Optional<GraveComponent> getGrave(UUID graveId) {
        return Optional.ofNullable(this.graveMap.get(graveId));
    }

    public ListMode getGraveListMode() {
        return this.graveListMode;
    }

    public void setGraveListMode(ListMode listMode) {
        this.graveListMode = listMode;
    }

    public void addToList(class_9296 profile) {
        this.affectedPlayers.add(profile);
    }

    public boolean removeFromList(class_9296 profile) {
        return this.affectedPlayers.remove(profile);
    }

    public boolean isInList(class_9296 profile) {
        return this.affectedPlayers.contains(profile);
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 respawnNbt = new class_2499();
        class_2499 graveNbt = new class_2499();
        class_2487 graveListNbt = new class_2487();
        for (Map.Entry<class_9296, RespawnComponent> entry : this.respawnEffects.entrySet()) {
            class_2487 respawnCompound = new class_2487();
            class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)entry.getKey()).result().ifPresent(nbtElement -> respawnCompound.method_10566("user", nbtElement));
            respawnCompound.method_10566("component", (class_2520)entry.getValue().toNbt(registryLookup));
            respawnNbt.add((Object)respawnCompound);
        }
        for (Map.Entry<class_9296, Object> entry : this.graveBackups.entrySet()) {
            class_2487 graveCompound = new class_2487();
            class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)entry.getKey()).result().ifPresent(nbtElement -> graveCompound.method_10566("user", nbtElement));
            class_2499 graveNbtList = new class_2499();
            for (GraveComponent graveComponent : (List)entry.getValue()) {
                graveNbtList.add((Object)graveComponent.toNbt(registryLookup));
            }
            graveCompound.method_10566("graves", (class_2520)graveNbtList);
            graveNbt.add((Object)graveCompound);
        }
        graveListNbt.method_10582("listMode", this.graveListMode.name());
        class_2499 affectedPlayersNbt = new class_2499();
        for (class_9296 profile : this.affectedPlayers) {
            class_2520 profileNbt = (class_2520)class_9296.field_49359.encodeStart((DynamicOps)class_2509.field_11560, (Object)profile).result().orElseThrow();
            affectedPlayersNbt.add((Object)profileNbt);
        }
        graveListNbt.method_10566("affectedPlayers", (class_2520)affectedPlayersNbt);
        nbt.method_10566("respawns", (class_2520)respawnNbt);
        nbt.method_10566("graves", (class_2520)graveNbt);
        nbt.method_10566("whitelist", (class_2520)graveListNbt);
        return nbt;
    }

    public static DeathInfoManager fromNbt(class_2487 nbt, class_7225.class_7874 lookupRegistry, MinecraftServer server) {
        INSTANCE.clear();
        class_2499 respawnNbt = nbt.method_10554("respawns", 10);
        class_2499 graveNbt = nbt.method_10554("graves", 10);
        for (class_2520 respawnElement : respawnNbt) {
            class_2487 respawnCompound = (class_2487)respawnElement;
            INSTANCE.addRespawnComponent((class_9296)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)respawnCompound.method_10580("user")).result().orElseThrow(), RespawnComponent.fromNbt(respawnCompound.method_10562("component"), lookupRegistry));
        }
        for (class_2520 graveElement : graveNbt) {
            class_2487 graveCompound = (class_2487)graveElement;
            class_9296 user = (class_9296)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)graveCompound.method_10580("user")).result().orElseThrow();
            class_2499 gravesList = graveCompound.method_10554("graves", 10);
            for (class_2520 grave : gravesList) {
                GraveBlockEntity be;
                class_2586 class_25862;
                GraveComponent component = GraveComponent.fromNbt((class_2487)grave, lookupRegistry, server);
                INSTANCE.addBackup(user, component);
                class_3218 world = component.getWorld();
                if (world == null || !world.method_37116(new class_1923(component.getPos()).method_8324()) || !((class_25862 = world.method_8321(component.getPos())) instanceof GraveBlockEntity) || (be = (GraveBlockEntity)class_25862).getGraveId() == null || !be.getGraveId().equals(component.getGraveId())) continue;
                be.setComponent(component);
            }
        }
        class_2487 graveListNbt = nbt.method_10562("whitelist");
        ListMode listMode = ListMode.valueOf(graveListNbt.method_10558("listMode"));
        INSTANCE.setGraveListMode(listMode);
        class_2499 affectedPlayersNbt = graveListNbt.method_10554("affectedPlayers", 9);
        for (class_2520 e : affectedPlayersNbt) {
            class_9296 profile = (class_9296)class_9296.field_49359.parse((DynamicOps)class_2509.field_11560, (Object)e).result().orElseThrow();
            INSTANCE.addToList(profile);
        }
        return INSTANCE;
    }
}

