/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class TravelersBackpackCompat
implements InvModCompat<class_3545<class_1799, DropRule>> {
    public static boolean isTrinketIntegrationEnabled() {
        return TravelersBackpackConfig.getConfig().backpackSettings.trinketsIntegration;
    }

    @Override
    public String getModName() {
        return "travelers backpack";
    }

    @Override
    public void clear(class_3222 player) {
        ComponentUtils.getComponent((class_1657)player).removeWearable();
    }

    @Override
    public CompatComponent<class_3545<class_1799, DropRule>> readNbt(class_2487 nbt) {
        class_1799 stack = class_1799.method_7915((class_2487)nbt);
        DropRule dropRule = nbt.method_10545("dropRule") ? DropRule.valueOf(nbt.method_10558("dropRule")) : YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
        return new TBCompatComponent((class_3545<class_1799, DropRule>)new class_3545((Object)stack, (Object)dropRule));
    }

    @Override
    public CompatComponent<class_3545<class_1799, DropRule>> getNewComponent(class_3222 player) {
        return new TBCompatComponent(player);
    }

    private static class TBCompatComponent
    extends CompatComponent<class_3545<class_1799, DropRule>> {
        public TBCompatComponent(class_3222 player) {
            super(player);
        }

        public TBCompatComponent(class_3545<class_1799, DropRule> inventory) {
            super(inventory);
        }

        @Override
        public class_3545<class_1799, DropRule> getInventory(class_3222 player) {
            DropRule defaultDropRule = YigdConfig.getConfig().compatConfig.defaultTravelersBackpackDropRule;
            class_1799 stack = ComponentUtils.getComponent((class_1657)player).getWearable();
            return stack == null ? InventoryComponent.EMPTY_ITEM_PAIR : new class_3545((Object)stack, (Object)defaultDropRule);
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            class_3545 pair = (class_3545)mergingComponent.inventory;
            class_1799 mergingStack = (class_1799)pair.method_15442();
            class_1799 currentStack = (class_1799)((class_3545)this.inventory).method_15442();
            if (mergingStack.method_7960()) {
                return extraItems;
            }
            if (!currentStack.method_7960()) {
                extraItems.add((Object)mergingStack);
                return extraItems;
            }
            this.inventory = new class_3545((Object)mergingStack, (Object)((DropRule)((Object)pair.method_15441())));
            return extraItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            if (((class_1799)((class_3545)this.inventory).method_15442()).method_7960()) {
                return class_2371.method_10211();
            }
            ComponentUtils.equipBackpack((class_1657)player, (class_1799)((class_1799)((class_3545)this.inventory).method_15442()));
            return class_2371.method_10211();
        }

        @Override
        public void handleDropRules(DeathContext context) {
            YigdConfig.CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            DropRule dropRule = compatConfig.defaultTravelersBackpackDropRule;
            class_1799 stack = (class_1799)((class_3545)this.inventory).method_15442();
            if (stack.method_7960()) {
                return;
            }
            if (dropRule == DropRule.PUT_IN_GRAVE) {
                dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(stack, -1, context, true);
            }
            ((class_3545)this.inventory).method_34965((Object)dropRule);
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getAsStackDropList() {
            class_2371 stacks = class_2371.method_10211();
            stacks.add((Object)((class_3545)this.inventory));
            return stacks;
        }

        @Override
        public CompatComponent<class_3545<class_1799, DropRule>> filterInv(Predicate<DropRule> predicate) {
            class_3545 pair = predicate.test((DropRule)((Object)((class_3545)this.inventory).method_15441())) ? (class_3545)this.inventory : InventoryComponent.EMPTY_ITEM_PAIR;
            return new TBCompatComponent((class_3545<class_1799, DropRule>)pair);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            class_1799 stack = (class_1799)((class_3545)this.inventory).method_15442();
            if (predicate.test(stack)) {
                stack.method_7934(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.inventory = InventoryComponent.EMPTY_ITEM_PAIR;
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            ((class_1799)((class_3545)this.inventory).method_15442()).method_7953(nbt);
            nbt.method_10582("dropRule", ((DropRule)((Object)((class_3545)this.inventory).method_15441())).name());
            return nbt;
        }
    }
}

