/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.item;

import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.packets.ServerPacketHandler;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7699;

public class DeathScrollItem
extends class_1792 {
    public DeathScrollItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 player) {
        if (!world.field_9236) {
            this.bindStackToLatestDeath((class_3222)player, stack);
        }
        super.method_54465(stack, world, player);
    }

    public boolean method_45382(class_7699 enabledFeatures) {
        return YigdConfig.getConfig().extraFeatures.deathScroll.enabled;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1271<class_1799> res;
        if (world.field_9236) {
            return super.method_7836(world, user, hand);
        }
        YigdConfig.ExtraFeatures.ScrollConfig scrollConfig = YigdConfig.getConfig().extraFeatures.deathScroll;
        class_3222 player = (class_3222)user;
        class_1799 scroll = player.method_5998(hand);
        class_2487 scrollNbt = scroll.method_7969();
        if ((scrollConfig.rebindable && player.method_5715() || scrollNbt == null || scrollNbt.method_25926("grave") == null) && this.bindStackToLatestDeath(player, scroll)) {
            return class_1271.method_29237((Object)scroll, (boolean)true);
        }
        YigdConfig.ExtraFeatures.ScrollConfig.ClickFunction clickFunction = scrollConfig.clickFunction;
        if (scrollNbt != null && scrollNbt.method_10545("clickFunction") && !scrollNbt.method_10558("clickFunction").equals("default")) {
            clickFunction = YigdConfig.ExtraFeatures.ScrollConfig.ClickFunction.valueOf(scrollNbt.method_10558("clickFunction"));
        }
        switch (clickFunction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case VIEW_CONTENTS: {
                class_1271<class_1799> class_12712 = this.viewContent(scroll, player);
                break;
            }
            case RESTORE_CONTENTS: {
                class_1271<class_1799> class_12712 = this.restoreContent(scroll, player);
                break;
            }
            case TELEPORT_TO_LOCATION: {
                class_1271<class_1799> class_12712 = res = this.teleport(scroll, player);
            }
        }
        if (res.method_5467() != class_1269.field_5811) {
            if (YigdConfig.getConfig().extraFeatures.deathScroll.consumeOnUse && res.method_5467() != class_1269.field_21466) {
                scroll.method_7934(1);
            }
            return res;
        }
        return super.method_7836(world, user, hand);
    }

    public boolean bindStackToLatestDeath(class_3222 player, class_1799 scroll) {
        if (player == null) {
            return false;
        }
        GameProfile playerProfile = player.method_7334();
        ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(playerProfile));
        graves.removeIf(component -> component.getStatus() != GraveStatus.UNCLAIMED);
        int size = graves.size();
        if (size >= 1) {
            GraveComponent component2 = (GraveComponent)graves.get(size - 1);
            class_2487 scrollNbt = scroll.method_7948();
            scrollNbt.method_25927("grave", component2.getGraveId());
            scrollNbt.method_10582("clickFunction", "default");
            return true;
        }
        return false;
    }

    private class_1271<class_1799> viewContent(class_1799 scroll, class_3222 player) {
        class_2487 scrollNbt = scroll.method_7969();
        if (scrollNbt == null) {
            return class_1271.method_22430((Object)scroll);
        }
        UUID graveId = scrollNbt.method_25926("grave");
        Optional<GraveComponent> optional = DeathInfoManager.INSTANCE.getGrave(graveId);
        if (optional.isPresent()) {
            GraveComponent component = optional.get();
            ServerPacketHandler.sendGraveOverviewPacket(player, component);
        }
        return class_1271.method_22427((Object)scroll);
    }

    private class_1271<class_1799> restoreContent(class_1799 scroll, class_3222 player) {
        class_2487 scrollNbt = scroll.method_7969();
        if (scrollNbt == null) {
            return class_1271.method_22430((Object)scroll);
        }
        UUID graveId = scrollNbt.method_25926("grave");
        Optional<GraveComponent> optional = DeathInfoManager.INSTANCE.getGrave(graveId);
        if (optional.isPresent()) {
            GraveComponent component = optional.get();
            class_1269 res = component.claim(player, player.method_51469(), null, component.getPos(), scroll);
            return new class_1271(res, (Object)scroll);
        }
        return class_1271.method_22430((Object)scroll);
    }

    private class_1271<class_1799> teleport(class_1799 scroll, class_3222 player) {
        class_2487 scrollNbt = scroll.method_7969();
        if (scrollNbt == null) {
            return class_1271.method_22430((Object)scroll);
        }
        UUID graveId = scrollNbt.method_25926("grave");
        Optional<GraveComponent> optional = DeathInfoManager.INSTANCE.getGrave(graveId);
        if (optional.isPresent()) {
            GraveComponent component = optional.get();
            class_2338 gravePos = component.getPos();
            player.method_14251(component.getWorld(), (double)gravePos.method_10263(), (double)gravePos.method_10264(), (double)gravePos.method_10260(), player.method_36454(), player.method_36455());
        }
        return class_1271.method_22427((Object)scroll);
    }
}

