/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.DropRuleEvent;
import com.b1n_ry.yigd.util.DropRule;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.InventoryPower;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class OriginsCompat
implements InvModCompat<Map<String, class_2371<class_3545<class_1799, DropRule>>>> {
    @Override
    public String getModName() {
        return "apoli";
    }

    @Override
    public void clear(class_3222 player) {
        PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class).forEach(InventoryPower::method_5448);
    }

    @Override
    public CompatComponent<Map<String, class_2371<class_3545<class_1799, DropRule>>>> readNbt(class_2487 nbt) {
        HashMap<String, class_2371<class_3545<class_1799, DropRule>>> inventory = new HashMap<String, class_2371<class_3545<class_1799, DropRule>>>();
        for (String key : nbt.method_10541()) {
            class_2487 inventoryNbt = nbt.method_10562(key);
            class_2371<class_3545<class_1799, DropRule>> items = InventoryComponent.listFromNbt(inventoryNbt, itemNbt -> {
                class_1799 stack = class_1799.method_7915((class_2487)itemNbt);
                DropRule dropRule = itemNbt.method_10545("dropRule") ? DropRule.valueOf(itemNbt.method_10558("dropRule")) : YigdConfig.getConfig().compatConfig.defaultOriginsDropRule;
                return new class_3545((Object)stack, (Object)dropRule);
            }, InventoryComponent.EMPTY_ITEM_PAIR);
            inventory.put(key, items);
        }
        return new OriginsCompatComponent((Map<String, class_2371<class_3545<class_1799, DropRule>>>)inventory);
    }

    @Override
    public CompatComponent<Map<String, class_2371<class_3545<class_1799, DropRule>>>> getNewComponent(class_3222 player) {
        return new OriginsCompatComponent(player);
    }

    private static class OriginsCompatComponent
    extends CompatComponent<Map<String, class_2371<class_3545<class_1799, DropRule>>>> {
        public OriginsCompatComponent(class_3222 player) {
            super(player);
        }

        public OriginsCompatComponent(Map<String, class_2371<class_3545<class_1799, DropRule>>> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, class_2371<class_3545<class_1799, DropRule>>> getInventory(class_3222 player) {
            YigdConfig.CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            HashMap<String, class_2371<class_3545<class_1799, DropRule>>> inventory = new HashMap<String, class_2371<class_3545<class_1799, DropRule>>>();
            List powers = PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class);
            for (InventoryPower inventoryPower : powers) {
                Active.Key key = inventoryPower.getKey();
                class_2371 stacks = class_2371.method_10211();
                for (int i = 0; i < inventoryPower.method_5439(); ++i) {
                    class_1799 stack = inventoryPower.method_5438(i);
                    DropRule dropRule = inventoryPower.shouldDropOnDeath(stack) ? compatConfig.defaultOriginsDropRule : DropRule.KEEP;
                    stacks.add((Object)new class_3545((Object)stack, (Object)dropRule));
                }
                inventory.put(key.key, (class_2371<class_3545<class_1799, DropRule>>)stacks);
            }
            return inventory;
        }

        @Override
        public class_2371<class_1799> merge(CompatComponent<?> mergingComponent, class_3222 merger) {
            class_2371 extraItems = class_2371.method_10211();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry entry : mergingInventory.entrySet()) {
                class_2371 currentItems = ((Map)this.inventory).getOrDefault(entry.getKey(), class_2371.method_10211());
                class_2371 mergingItems = (class_2371)entry.getValue();
                for (int i = 0; i < mergingItems.size(); ++i) {
                    class_1799 mergingStack = ((class_1799)((class_3545)mergingItems.get(i)).method_15442()).method_7972();
                    if (i >= currentItems.size()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    class_3545 currentPair = (class_3545)currentItems.get(i);
                    if (!((class_1799)currentPair.method_15442()).method_7960()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentItems.set(i, (Object)new class_3545((Object)mergingStack, (Object)((DropRule)((Object)currentPair.method_15441()))));
                }
            }
            return extraItems;
        }

        @Override
        public class_2371<class_1799> storeToPlayer(class_3222 player) {
            class_2371 extraItems = class_2371.method_10211();
            List powers = PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class);
            ArrayList unhandledPowers = new ArrayList(((Map)this.inventory).keySet());
            for (InventoryPower power : powers) {
                String key = power.getKey().key;
                unhandledPowers.remove(key);
                class_2371 inventoryItems = (class_2371)((Map)this.inventory).get(key);
                if (inventoryItems == null) continue;
                for (int i = 0; i < inventoryItems.size(); ++i) {
                    class_1799 currentStack = (class_1799)((class_3545)inventoryItems.get(i)).method_15442();
                    if (i >= power.method_5439()) {
                        extraItems.add((Object)currentStack);
                        continue;
                    }
                    power.method_5447(i, currentStack);
                }
            }
            for (String key : unhandledPowers) {
                for (class_3545 pair : (class_2371)((Map)this.inventory).get(key)) {
                    extraItems.add((Object)((class_1799)pair.method_15442()));
                }
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                class_2371 items = (class_2371)entry.getValue();
                for (class_3545 pair : items) {
                    class_1799 item = (class_1799)pair.method_15442();
                    if (item.method_7960()) continue;
                    DropRule dropRule = (DropRule)((Object)pair.method_15441());
                    if (dropRule == DropRule.PUT_IN_GRAVE) {
                        dropRule = ((DropRuleEvent)DropRuleEvent.EVENT.invoker()).getDropRule(item, -1, context, true);
                    }
                    pair.method_34965((Object)dropRule);
                }
            }
        }

        @Override
        public class_2371<class_3545<class_1799, DropRule>> getAsStackDropList() {
            class_2371 allItems = class_2371.method_10211();
            for (class_2371 stacks : ((Map)this.inventory).values()) {
                allItems.addAll((Collection)stacks);
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, class_2371<class_3545<class_1799, DropRule>>>> filterInv(Predicate<DropRule> predicate) {
            HashMap<String, class_2371<class_3545<class_1799, DropRule>>> inventory = new HashMap<String, class_2371<class_3545<class_1799, DropRule>>>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                class_2371 items = (class_2371)entry.getValue();
                class_2371 filteredItems = class_2371.method_10211();
                for (class_3545 pair : items) {
                    if (predicate.test((DropRule)((Object)pair.method_15441()))) {
                        filteredItems.add((Object)pair);
                        continue;
                    }
                    filteredItems.add(InventoryComponent.EMPTY_ITEM_PAIR);
                }
                inventory.put((String)entry.getKey(), (class_2371<class_3545<class_1799, DropRule>>)filteredItems);
            }
            return new OriginsCompatComponent((Map<String, class_2371<class_3545<class_1799, DropRule>>>)inventory);
        }

        @Override
        public boolean removeItem(Predicate<class_1799> predicate, int itemCount) {
            for (class_2371 stacks : ((Map)this.inventory).values()) {
                for (class_3545 pair : stacks) {
                    class_1799 stack = (class_1799)pair.method_15442();
                    if (!predicate.test(stack)) continue;
                    stack.method_7934(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (class_2371 stacks : ((Map)this.inventory).values()) {
                Collections.fill(stacks, InventoryComponent.EMPTY_ITEM_PAIR);
            }
        }

        @Override
        public class_2487 writeNbt() {
            class_2487 nbt = new class_2487();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                class_2371 items = (class_2371)entry.getValue();
                class_2487 itemsNbt = InventoryComponent.listToNbt(items, pair -> {
                    class_2487 itemNbt = new class_2487();
                    ((class_1799)pair.method_15442()).method_7953(itemNbt);
                    itemNbt.method_10582("dropRule", ((DropRule)((Object)((Object)pair.method_15441()))).toString());
                    return itemNbt;
                }, pair -> ((class_1799)pair.method_15442()).method_7960());
                nbt.method_10566((String)entry.getKey(), (class_2520)itemsNbt);
            }
            return nbt;
        }
    }
}

