/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.util;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.GraveBlock;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.data.GraveyardData;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class YigdResourceHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (elem, type, context) -> new class_2960(elem.getAsString())).registerTypeAdapter(class_2382.class, (elem, type, context) -> new class_2382(elem.getAsJsonArray().get(0).getAsInt(), elem.getAsJsonArray().get(1).getAsInt(), elem.getAsJsonArray().get(2).getAsInt())).create();

    public static void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new GraveResourceLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new GraveServerModelLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new GraveyardDataLoader());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new GraveAreaOverrideLoader());
    }

    private static class GraveResourceLoader
    implements SimpleSynchronousResourceReloadListener {
        private GraveResourceLoader() {
        }

        public class_2960 getFabricId() {
            return new class_2960("yigd", "custom_grave_model");
        }

        public void method_14491(class_3300 manager) {
            class_2960 resourceLocation = new class_2960("yigd", "models/block/grave.json");
            List resources = manager.method_14489(resourceLocation);
            for (class_3298 resource : resources) {
                try {
                    InputStream is = resource.method_14482();
                    try {
                        Yigd.LOGGER.info("Reloading grave model (client)");
                        JsonObject resourceJson = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(is));
                        GraveBlockEntityRenderer.reloadModelFromJson(resourceJson);
                        GraveBlock.reloadShapeFromJson(resourceJson);
                        Yigd.LOGGER.info("Grave model and shape reload successful (client)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from resource pack `%s`".formatted(resourceLocation, resource.method_14480()), (Throwable)e);
                }
            }
        }
    }

    private static class GraveServerModelLoader
    implements SimpleSynchronousResourceReloadListener {
        private GraveServerModelLoader() {
        }

        public class_2960 getFabricId() {
            return new class_2960("yigd", "custom_server_grave_shape");
        }

        public void method_14491(class_3300 manager) {
            class_2960 resourceLocation = new class_2960("yigd", "custom/grave_shape.json");
            List resources = manager.method_14489(resourceLocation);
            for (class_3298 resource : resources) {
                try {
                    InputStream is = resource.method_14482();
                    try {
                        Yigd.LOGGER.info("Reloading grave shape (server)");
                        JsonObject resourceJson = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(is));
                        GraveBlock.reloadShapeFromJson(resourceJson);
                        Yigd.LOGGER.info("Grave model and shape reload successful (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.method_14480()), (Throwable)e);
                }
            }
        }
    }

    private static class GraveyardDataLoader
    implements SimpleSynchronousResourceReloadListener {
        private GraveyardDataLoader() {
        }

        public class_2960 getFabricId() {
            return new class_2960("yigd", "graveyard");
        }

        public void method_14491(class_3300 manager) {
            class_2960 resourceLocation = new class_2960("yigd", "custom/graveyard.json");
            List resources = manager.method_14489(resourceLocation);
            for (class_3298 resource : resources) {
                try {
                    InputStream is = resource.method_14482();
                    try {
                        Yigd.LOGGER.info("Reloading YIGD graveyard data (server)");
                        GraveComponent.graveyardData = (GraveyardData)GSON.fromJson((Reader)new InputStreamReader(is), GraveyardData.class);
                        GraveComponent.graveyardData.handlePoint2Point();
                        Yigd.LOGGER.info("Graveyard data successfully reloaded (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.method_14480()), (Throwable)e);
                }
            }
        }
    }

    private static class GraveAreaOverrideLoader
    implements SimpleSynchronousResourceReloadListener {
        private GraveAreaOverrideLoader() {
        }

        public class_2960 getFabricId() {
            return new class_2960("yigd", "grave_area_override");
        }

        public void method_14491(class_3300 manager) {
            class_2960 resourceLocation = new class_2960("yigd", "custom/grave_areas.json");
            List resources = manager.method_14489(resourceLocation);
            for (class_3298 resource : resources) {
                try {
                    InputStream is = resource.method_14482();
                    try {
                        Yigd.LOGGER.info("Reloading YIGD grave area overrides (server)");
                        GraveOverrideAreas.INSTANCE = (GraveOverrideAreas)GSON.fromJson((Reader)new InputStreamReader(is), GraveOverrideAreas.class);
                        Yigd.LOGGER.info("Grave area overrides successfully reloaded (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.method_14480()), (Throwable)e);
                }
            }
        }
    }
}

