/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd;

import com.b1n_ry.yigd.api.ClaimModsApi;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.GraveBlock;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.client.gui.GraveViewScreen;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.compat.NumismaticOverhaulCompat;
import com.b1n_ry.yigd.compat.ProtectionApiCompat;
import com.b1n_ry.yigd.compat.TravelersBackpackCompat;
import com.b1n_ry.yigd.compat.TrinketsCompat;
import com.b1n_ry.yigd.config.PriorityInventoryConfig;
import com.b1n_ry.yigd.config.ScrollTypeConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveAreaOverride;
import com.b1n_ry.yigd.core.ServerPacketReceivers;
import com.b1n_ry.yigd.core.YigdCommand;
import com.b1n_ry.yigd.enchantment.DeathSightEnchantment;
import com.b1n_ry.yigd.enchantment.SoulboundEnchantment;
import com.b1n_ry.yigd.item.KeyItem;
import com.b1n_ry.yigd.item.ScrollItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Yigd
implements ModInitializer,
DedicatedServerModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"YIGD");
    public static List<UUID> notNotifiedPlayers = new ArrayList<UUID>();
    public static Map<UUID, String> notNotifiedRobberies = new HashMap<UUID, String>();
    public static Map<UUID, PriorityInventoryConfig> clientPriorities = new HashMap<UUID, PriorityInventoryConfig>();
    public static Map<UUID, PriorityInventoryConfig> clientRobPriorities = new HashMap<UUID, PriorityInventoryConfig>();
    public static final GraveBlock GRAVE_BLOCK = new GraveBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15914).strength(0.8f, 3600000.0f));
    public static class_2591<GraveBlockEntity> GRAVE_BLOCK_ENTITY;
    public static class_1887 DEATH_SIGHT;
    public static JsonObject graveyard;
    public static class_1792 SCROLL_ITEM;
    public static class_1792 KEY_ITEM;
    public static final List<YigdApi> apiMods;
    public static final List<ClaimModsApi> claimMods;
    public static final List<String> miscCompatMods;
    public static final List<Runnable> NEXT_TICK;
    public static YigdConfig defaultConfig;

    public void onInitialize() {
        try {
            AutoConfig.register(YigdConfig.class, Toml4jConfigSerializer::new);
        }
        catch (Exception e) {
            defaultConfig = new YigdConfig();
            LOGGER.error("Loading default YIGD config due to an error reading the config file. Delete yigd.toml, and a new working config file should generate", (Throwable)e);
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("yigd", "custom/graveyard");
            }

            public void method_14491(class_3300 manager) {
                graveyard = null;
                List graveyardResources = manager.method_14489(new class_2960("yigd", "custom/graveyard.json"));
                for (class_3298 resource : graveyardResources) {
                    try {
                        InputStream stream = resource.method_14482();
                        try {
                            LOGGER.info("Reloading graveyard");
                            graveyard = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading resource json yigd:graveyard\n" + e);
                    }
                }
                List graveAreaResources = manager.method_14489(new class_2960("yigd", "custom/grave_areas.json"));
                for (class_3298 resource : graveAreaResources) {
                    try (InputStream stream = resource.method_14482();){
                        LOGGER.info("Reloading custom grave areas");
                        GraveAreaOverride.reloadGraveAreas((JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading custom grave areas\n" + e);
                    }
                }
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                GraveBlock.customModel = null;
                List blockResources = manager.method_14489(new class_2960("yigd", "models/block/grave.json"));
                for (class_3298 resource : blockResources) {
                    try {
                        InputStream stream = resource.method_14482();
                        try {
                            LOGGER.info("Reloading grave model (client)");
                            GraveBlock.customModel = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                            GraveBlock.reloadVoxelShapes(GraveBlock.customModel);
                            GraveBlockEntityRenderer.reloadCustomModel();
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading custom grave model (client)\n" + e);
                    }
                }
                GraveViewScreen.dimensionNameOverrides.clear();
                List overrideResources = manager.method_14489(new class_2960("yigd", "texts/dim_names.json"));
                for (class_3298 resource : overrideResources) {
                    try {
                        InputStream stream = resource.method_14482();
                        try {
                            LOGGER.info("Reloading dimension name overrides for grave GUI");
                            JsonObject jObject = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                            for (Map.Entry entry : jObject.entrySet()) {
                                GraveViewScreen.dimensionNameOverrides.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                            }
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading dimension name overrides for grave GUI\n" + e);
                    }
                }
            }

            public class_2960 getFabricId() {
                return new class_2960("yigd", "models/block/grave");
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Iterator iterator;
            class_3218 world = server.method_30002();
            if (world == null && (iterator = server.method_3738().iterator()).hasNext()) {
                class_3218 serverWorld;
                world = serverWorld = (class_3218)iterator.next();
            }
            if (world == null) {
                return;
            }
            DeathInfoManager.INSTANCE = (DeathInfoManager)world.method_17983().method_17924(DeathInfoManager::fromNbt, DeathInfoManager::new, "yigd_grave_data");
            DeathInfoManager.INSTANCE.method_80();
            LOGGER.info("Loaded data from grave data file");
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            DeathInfoManager.INSTANCE = null;
        });
        GRAVE_BLOCK_ENTITY = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"yigd:grave_block_entity", (Object)FabricBlockEntityTypeBuilder.create(GraveBlockEntity::new, (class_2248[])new class_2248[]{GRAVE_BLOCK}).build(null));
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("yigd", "grave"), (Object)((Object)GRAVE_BLOCK));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("yigd", "grave"), (Object)new class_1747((class_2248)GRAVE_BLOCK, (class_1792.class_1793)new FabricItemSettings()));
        YigdConfig.UtilitySettings utilityConfig = YigdConfig.getConfig().utilitySettings;
        if (utilityConfig.soulboundEnchant.enabled) {
            class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960("yigd", "soulbound"), (Object)((Object)new SoulboundEnchantment()));
        }
        if (utilityConfig.deathSightEnchant.enabled) {
            DEATH_SIGHT = new DeathSightEnchantment();
            class_2378.method_10230((class_2378)class_7923.field_41176, (class_2960)new class_2960("yigd", "death_sight"), (Object)DEATH_SIGHT);
        }
        if (utilityConfig.scrollItem.scrollType != ScrollTypeConfig.DISABLED) {
            SCROLL_ITEM = new ScrollItem(new class_1792.class_1793());
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("yigd", "death_scroll"), (Object)SCROLL_ITEM);
        }
        if (utilityConfig.graveKeySettings.enableKeys) {
            KEY_ITEM = new KeyItem(new class_1792.class_1793());
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("yigd", "grave_key"), (Object)KEY_ITEM);
        }
        ItemGroupEvents.modifyEntriesEvent((class_1761)class_7706.field_40197).register(content -> content.method_45421((class_1935)GRAVE_BLOCK.method_8389()));
        ItemGroupEvents.modifyEntriesEvent((class_1761)class_7706.field_41060).register(content -> {
            if (utilityConfig.scrollItem.scrollType != ScrollTypeConfig.DISABLED) {
                content.method_45421((class_1935)SCROLL_ITEM);
            }
            if (utilityConfig.graveKeySettings.enableKeys) {
                content.method_45421((class_1935)KEY_ITEM);
            }
        });
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            apiMods.add(new TrinketsCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("travelersbackpack") && !TravelersBackpackCompat.isTrinketIntegrationOn()) {
            apiMods.add(new TravelersBackpackCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("numismatic-overhaul")) {
            apiMods.add(new NumismaticOverhaulCompat());
        }
        apiMods.addAll(FabricLoader.getInstance().getEntrypoints("yigd", YigdApi.class));
        if (FabricLoader.getInstance().isModLoaded("common-protection-api")) {
            claimMods.add(new ProtectionApiCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("graveyard")) {
            miscCompatMods.add("graveyard");
        }
        if (FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0")) {
            miscCompatMods.add("permissions");
        }
        YigdCommand.registerCommands();
        ServerPacketReceivers.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            YigdConfig config = YigdConfig.getConfig();
            UUID playerId = handler.field_14140.method_5667();
            if (notNotifiedPlayers.contains(playerId)) {
                handler.field_14140.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.timeout.offline"), false);
                notNotifiedPlayers.remove(playerId);
            }
            if (notNotifiedRobberies.containsKey(playerId)) {
                if (config.graveSettings.graveRobbing.tellRobber) {
                    handler.field_14140.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.robbed_by.offline", (Object[])new Object[]{notNotifiedRobberies.get(playerId)}), false);
                } else {
                    handler.field_14140.method_7353((class_2561)class_2561.method_43471((String)"text.yigd.message.robbed.offline"), false);
                }
                notNotifiedRobberies.remove(playerId);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (!YigdConfig.getConfig().graveSettings.betrayOfflinePeople) {
                return;
            }
            UUID playerId = handler.field_14140.method_5667();
            if (DeathInfoManager.INSTANCE.data.containsKey(playerId)) {
                List<DeadPlayerData> data = DeathInfoManager.INSTANCE.data.get(playerId);
                if (data.size() <= 0) {
                    return;
                }
                DeadPlayerData grave = data.get(data.size() - 1);
                if (grave.availability != 1) {
                    return;
                }
                class_2338 gravePos = grave.gravePos;
                for (class_3222 player : server.method_3760().method_14571()) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"text.yigd.message.rob_player_broadcast", (Object[])new Object[]{gravePos.method_10264(), gravePos.method_10264(), gravePos.method_10260(), grave.dimensionName}));
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<Runnable> tickFunctions = new ArrayList<Runnable>(NEXT_TICK);
            NEXT_TICK.clear();
            for (Runnable function : tickFunctions) {
                function.run();
            }
        });
    }

    public void onInitializeServer() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                List graveResources = manager.method_14489(new class_2960("yigd", "custom/grave.json"));
                for (class_3298 resource : graveResources) {
                    try {
                        InputStream stream = resource.method_14482();
                        try {
                            LOGGER.info("Reloading grave shape (server side)");
                            GraveBlock.reloadVoxelShapes((JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading custom grave shape (server side)\n" + e);
                    }
                }
            }

            public class_2960 getFabricId() {
                return new class_2960("yigd", "grave_model");
            }
        });
    }

    static {
        apiMods = new ArrayList<YigdApi>();
        claimMods = new ArrayList<ClaimModsApi>();
        miscCompatMods = new ArrayList<String>();
        NEXT_TICK = new ArrayList<Runnable>();
        defaultConfig = null;
    }
}

