/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.gui;

import com.b1n_ry.yigd.client.gui.GraveViewScreen;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.PacketIdentifiers;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class GraveSelectScreen
extends class_437 {
    private final class_2960 GRAVE_SELECT_TEXTURE = new class_2960("yigd", "textures/gui/select_grave_menu.png");
    private final class_2960 SELECT_ELEMENT_TEXTURE = new class_2960("yigd", "textures/gui/select_elements.png");
    private final Map<UUID, GraveGuiInfo> graveInfo;
    private final int page;
    private final class_437 previousScreen;
    private final GameProfile graveOwner;
    private boolean mouseIsClicked = false;
    private String hoveredElement = null;
    private boolean showClaimed;
    private boolean showDeleted;
    private boolean showPlaced;
    private boolean showStatus;
    private final YigdConfig.GuiTextColors textColors;
    private final List<UUID> filteredGraveIds;

    public GraveSelectScreen(GameProfile owner, Map<UUID, GraveGuiInfo> info, int page, class_437 previousScreen) {
        this(owner, info, page, previousScreen, true, false, false, false);
    }

    public GraveSelectScreen(GameProfile owner, Map<UUID, GraveGuiInfo> info, int page, class_437 previousScreen, boolean showPlaced, boolean showClaimed, boolean showDeleted, boolean showStatus) {
        super((class_2561)class_2561.method_43471((String)"text.yigd.gui.grave_select.title"));
        this.graveOwner = owner;
        this.graveInfo = info;
        this.filteredGraveIds = new ArrayList<UUID>(info.keySet());
        this.page = page;
        this.previousScreen = previousScreen;
        this.showPlaced = showPlaced;
        this.showClaimed = showClaimed;
        this.showDeleted = showDeleted;
        this.showStatus = showStatus;
        this.reloadFilters();
        this.textColors = YigdConfig.getConfig().graveSettings.graveRenderSettings.guiTextColors;
    }

    private void reloadFilters() {
        this.filteredGraveIds.clear();
        for (Map.Entry<UUID, GraveGuiInfo> entry : this.graveInfo.entrySet()) {
            UUID uuid = entry.getKey();
            GraveGuiInfo info = entry.getValue();
            switch (info.availability) {
                case -1: {
                    if (!this.showDeleted) break;
                    this.filteredGraveIds.add(uuid);
                    break;
                }
                case 0: {
                    if (!this.showClaimed) break;
                    this.filteredGraveIds.add(uuid);
                    break;
                }
                case 1: {
                    if (!this.showPlaced) break;
                    this.filteredGraveIds.add(uuid);
                }
            }
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787 != null && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        if (keyCode == 259) {
            if (this.previousScreen == null) {
                this.method_25419();
                return true;
            }
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.previousScreen);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredElement != null) {
            this.mouseIsClicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.mouseIsClicked = false;
        if (button == 0 && this.hoveredElement != null && this.field_22787 != null) {
            if (this.hoveredElement.equals("left") && this.page > 1) {
                GraveSelectScreen screen = new GraveSelectScreen(this.graveOwner, this.graveInfo, this.page - 1, this.previousScreen, this.showPlaced, this.showClaimed, this.showDeleted, this.showStatus);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("right") && this.filteredGraveIds.size() > this.page * 4) {
                GraveSelectScreen screen = new GraveSelectScreen(this.graveOwner, this.graveInfo, this.page + 1, this.previousScreen, this.showPlaced, this.showClaimed, this.showDeleted, this.showStatus);
                this.field_22787.method_1507((class_437)screen);
            } else if (this.hoveredElement.equals("show_available")) {
                this.showPlaced = !this.showPlaced;
            } else if (this.hoveredElement.equals("show_claimed")) {
                this.showClaimed = !this.showClaimed;
            } else if (this.hoveredElement.equals("show_destroyed")) {
                this.showDeleted = !this.showDeleted;
            } else if (this.hoveredElement.equals("show_status")) {
                this.showStatus = !this.showStatus;
            } else if (this.isUuid(this.hoveredElement)) {
                UUID parsedUuid = UUID.fromString(this.hoveredElement);
                class_2540 buf = PacketByteBufs.create();
                buf.method_43616(this.graveOwner);
                buf.method_10797(parsedUuid);
                ClientPlayNetworking.send((class_2960)PacketIdentifiers.SINGLE_GRAVE_GUI, (class_2540)buf);
            }
            if (this.hoveredElement.startsWith("show_")) {
                this.reloadFilters();
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int screenWidth = 220;
        int screenHeight = 219;
        int originX = this.field_22789 / 2;
        int originY = this.field_22790 / 2;
        int screenLeft = originX - 110;
        int screenTop = originY - 109;
        this.hoveredElement = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.GRAVE_SELECT_TEXTURE);
        GraveSelectScreen.method_25302((class_4587)matrices, (int)screenLeft, (int)screenTop, (int)0, (int)0, (int)220, (int)219);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > screenLeft + 6 && mouseX < screenLeft + 14 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "left";
        } else if (mouseX > screenLeft + 220 - 14 && mouseX < screenLeft + 220 - 6 && mouseY > originY - 8 && mouseY < originY + 7) {
            this.hoveredElement = "right";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("left") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)(screenLeft + 6), (int)(originY - 8), (int)16, (int)84, (int)8, (int)15);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)(screenLeft + 6), (int)(originY - 8), (int)0, (int)84, (int)8, (int)15);
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("right") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)(screenLeft + 220 - 14), (int)(originY - 8), (int)24, (int)84, (int)8, (int)15);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)(screenLeft + 220 - 14), (int)(originY - 8), (int)8, (int)84, (int)8, (int)15);
        }
        int infoSize = this.filteredGraveIds.size();
        int startValue = infoSize - (this.page - 1) * 4;
        int whileMoreThan = Math.max(startValue - 4, 0);
        int iterations = 0;
        for (int i = startValue; i > whileMoreThan; --i) {
            UUID graveId = this.filteredGraveIds.get(i - 1);
            GraveGuiInfo info = this.graveInfo.get(graveId);
            if (this.showStatus && info.availability != 1) {
                if (info.availability == -1) {
                    RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                }
                if (info.availability == 0) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)0.5f);
                }
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
            int left = screenLeft + 19;
            int top = screenTop + 43 + 42 * iterations;
            int width = 182;
            int height = 42;
            if (mouseX > left && mouseX < left + width && mouseY > top && mouseY < top + height) {
                this.hoveredElement = graveId.toString();
            }
            if (this.isUuid(this.hoveredElement) && UUID.fromString(this.hoveredElement).equals(graveId) && this.mouseIsClicked) {
                GraveSelectScreen.method_25302((class_4587)matrices, (int)left, (int)top, (int)0, (int)height, (int)width, (int)height);
            } else {
                GraveSelectScreen.method_25302((class_4587)matrices, (int)left, (int)top, (int)0, (int)0, (int)width, (int)height);
            }
            String dimName = GraveViewScreen.dimensionNameOverrides.containsKey(info.dimension) ? GraveViewScreen.dimensionNameOverrides.get(info.dimension) : info.dimension;
            this.field_22793.method_1729(matrices, info.pos.method_10263() + " " + info.pos.method_10264() + " " + info.pos.method_10260() + " " + dimName, (float)left + 5.0f, (float)top + 5.0f, this.textColors.graveSelectGraveLocation);
            this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.yigd.gui.grave_select.x_items", (Object[])new Object[]{info.itemCount}), (float)left + 5.0f, (float)top + 17.0f, this.textColors.graveSelectItemSize);
            this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.yigd.gui.grave_select.x_levels", (Object[])new Object[]{info.levelCount}), (float)left + 5.0f, (float)top + 29.0f, this.textColors.graveSelectLevelSize);
            ++iterations;
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.renderCheckButtons(matrices, mouseX, mouseY, screenTop, screenLeft, originX);
        int firstElement = (this.page - 1) * 4 + 1;
        String gravesDisplayed = firstElement + "-" + (firstElement + Math.min(3, infoSize - firstElement)) + "/" + infoSize;
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43469((String)"text.yigd.gui.grave_select.graves_of_user", (Object[])new Object[]{this.graveOwner.getName()}), (float)screenLeft + 19.0f, (float)screenTop + 10.0f, this.textColors.graveSelectTitle);
        int offset = this.field_22793.method_1727(gravesDisplayed);
        this.field_22793.method_1729(matrices, gravesDisplayed, (float)(screenLeft + 220) - 19.0f - (float)offset, (float)screenTop + 10.0f, this.textColors.graveSelectPageView);
    }

    private boolean isUuid(String uuidString) {
        if (uuidString == null) {
            return false;
        }
        try {
            UUID.fromString(uuidString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void renderCheckButtons(class_4587 matrices, int mouseX, int mouseY, int screenTop, int screenLeft, int originX) {
        int boxTop = screenTop + 22;
        int boxRow = boxTop + 9;
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        int leftEdge = screenLeft + 18;
        if (mouseX > leftEdge && mouseX < leftEdge + 6 && mouseY > boxTop && mouseY < boxTop + 6) {
            this.hoveredElement = "show_available";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("show_available") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxTop, (int)32, (int)90, (int)6, (int)6);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxTop, (int)32, (int)84, (int)6, (int)6);
        }
        if (this.showPlaced) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxTop, (int)38, (int)84, (int)6, (int)6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.grave_select.show_available"), (float)leftEdge + 8.0f, (float)boxTop - 1.0f, this.textColors.graveSelectShowAvailableCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > originX && mouseX < originX + 6 && mouseY > boxTop && mouseY < boxTop + 6) {
            this.hoveredElement = "show_claimed";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("show_claimed") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxTop, (int)32, (int)90, (int)6, (int)6);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxTop, (int)32, (int)84, (int)6, (int)6);
        }
        if (this.showClaimed) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxTop, (int)38, (int)84, (int)6, (int)6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.grave_select.show_claimed"), (float)originX + 8.0f, (float)boxTop - 1.0f, this.textColors.graveSelectShowClaimedCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > leftEdge && mouseX < leftEdge + 6 && mouseY > boxRow && mouseY < boxRow + 6) {
            this.hoveredElement = "show_destroyed";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("show_destroyed") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxRow, (int)32, (int)90, (int)6, (int)6);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxRow, (int)32, (int)84, (int)6, (int)6);
        }
        if (this.showDeleted) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)leftEdge, (int)boxRow, (int)38, (int)84, (int)6, (int)6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.grave_select.show_destroyed"), (float)leftEdge + 8.0f, (float)boxRow - 1.0f, this.textColors.graveSelectShowDestroyedCheckbox);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.SELECT_ELEMENT_TEXTURE);
        if (mouseX > originX && mouseX < originX + 6 && mouseY > boxRow && mouseY < boxRow + 6) {
            this.hoveredElement = "show_status";
        }
        if (this.hoveredElement != null && this.hoveredElement.equals("show_status") && this.mouseIsClicked) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxRow, (int)32, (int)90, (int)6, (int)6);
        } else {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxRow, (int)32, (int)84, (int)6, (int)6);
        }
        if (this.showStatus) {
            GraveSelectScreen.method_25302((class_4587)matrices, (int)originX, (int)boxRow, (int)38, (int)84, (int)6, (int)6);
        }
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"text.yigd.gui.grave_select.show_status"), (float)originX + 8.0f, (float)boxRow - 1.0f, this.textColors.graveSelectShowStatusCheckbox);
    }

    public record GraveGuiInfo(class_2338 pos, String dimension, int itemCount, int levelCount, byte availability) {
    }
}

