/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.DeathMessageInfo;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class DeadPlayerData {
    public class_2371<class_1799> inventory;
    public Map<String, Object> modInventories;
    public class_2338 gravePos;
    public GameProfile graveOwner;
    public int xp;
    public class_2960 worldId;
    public String dimensionName;
    public DeathMessageInfo deathMessageInfo;
    public long deathTime;
    public UUID id;
    public byte availability;
    public GameProfile claimedBy;

    public static DeadPlayerData create(class_2371<class_1799> inventory, Map<String, Object> modInventories, class_2338 gravePos, GameProfile graveOwner, int xp, class_1937 world, DeathMessageInfo deathSource, UUID id) {
        class_2960 dimId = world.method_30349().method_30530(class_7924.field_41241).method_10221((Object)world.method_8597());
        String dimName = dimId != null ? dimId.toString() : "void";
        return new DeadPlayerData(inventory, modInventories, gravePos, graveOwner, xp, world.method_27983().method_29177(), dimName, deathSource, world.method_8532(), 1, null, id);
    }

    public DeadPlayerData(class_2371<class_1799> inventory, Map<String, Object> modInventories, class_2338 gravePos, GameProfile graveOwner, int xp, class_2960 worldId, String dimensionName, DeathMessageInfo deathSource, long deathTime, byte availability, GameProfile claimedBy, UUID id) {
        this.inventory = inventory;
        this.modInventories = modInventories;
        this.gravePos = gravePos;
        this.graveOwner = graveOwner;
        this.xp = xp;
        this.worldId = worldId;
        this.deathMessageInfo = deathSource;
        this.deathTime = deathTime;
        this.dimensionName = dimensionName;
        this.availability = availability;
        this.claimedBy = claimedBy;
        this.id = id;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2487 invNbt = class_1262.method_5426((class_2487)new class_2487(), this.inventory);
        class_2487 modNbt = new class_2487();
        for (YigdApi yigdApi : Yigd.apiMods) {
            String modName = yigdApi.getModName();
            if (!this.modInventories.containsKey(modName)) continue;
            modNbt.method_10566(modName, (class_2520)yigdApi.writeNbt(this.modInventories.get(modName)));
        }
        class_2487 posNbt = class_2512.method_10692((class_2338)this.gravePos);
        class_2487 graveOwnerNbt = class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner);
        String worldId = this.worldId.toString();
        class_2487 deathMessageNbt = this.deathMessageInfo.toNbt();
        nbt.method_10566("inventory", (class_2520)invNbt);
        nbt.method_10569("inventorySize", this.inventory.size());
        nbt.method_10566("modInventory", (class_2520)modNbt);
        nbt.method_10566("gravePos", (class_2520)posNbt);
        nbt.method_10566("owner", (class_2520)graveOwnerNbt);
        nbt.method_10569("xp", this.xp);
        nbt.method_10582("world", worldId);
        nbt.method_10582("dimension", this.dimensionName);
        nbt.method_10566("causeOfDeath", (class_2520)deathMessageNbt);
        nbt.method_10544("deathTime", this.deathTime);
        nbt.method_10567("availability", this.availability);
        if (this.claimedBy != null) {
            nbt.method_10566("claimedBy", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.claimedBy));
        }
        nbt.method_25927("id", this.id);
        return nbt;
    }

    public static DeadPlayerData fromNbt(class_2487 nbt) {
        GameProfile gameProfile;
        GameProfile graveOwner;
        class_2338 pos;
        class_2520 blockPosNbt;
        class_2520 itemNbt = nbt.method_10580("inventory");
        int invSize = nbt.method_10550("inventorySize");
        class_2371 items = class_2371.method_10213((int)invSize, (Object)class_1799.field_8037);
        if (itemNbt instanceof class_2487) {
            class_2487 itemNbtCompound = (class_2487)itemNbt;
            class_1262.method_5429((class_2487)itemNbtCompound, (class_2371)items);
        }
        class_2520 modNbt = nbt.method_10580("modInventory");
        HashMap<String, Object> modInventories = new HashMap<String, Object>();
        if (modNbt instanceof class_2487) {
            class_2487 modNbtCompound = (class_2487)modNbt;
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                class_2520 e = modNbtCompound.method_10580(modName);
                if (!(e instanceof class_2487)) continue;
                class_2487 c = (class_2487)e;
                modInventories.put(modName, yigdApi.readNbt(c));
            }
        }
        if ((blockPosNbt = nbt.method_10580("gravePos")) instanceof class_2487) {
            class_2487 c = (class_2487)blockPosNbt;
            pos = class_2512.method_10691((class_2487)c);
        } else {
            pos = null;
        }
        class_2520 ownerElement = nbt.method_10580("owner");
        if (ownerElement instanceof class_2487) {
            class_2487 ownerNbt = (class_2487)ownerElement;
            graveOwner = class_2512.method_10683((class_2487)ownerNbt);
        } else {
            graveOwner = null;
        }
        int xp = nbt.method_10550("xp");
        String worldId = nbt.method_10558("world");
        class_2960 worldIdentifier = new class_2960(worldId);
        String dimName = nbt.method_10558("dimension");
        long deathTime = nbt.method_10545("deathTime") ? nbt.method_10537("deathTime") : 0L;
        byte availability = nbt.method_10545("availability") ? nbt.method_10571("availability") : (byte)1;
        class_2520 class_25202 = nbt.method_10580("claimedBy");
        if (class_25202 instanceof class_2487) {
            class_2487 claimedByNbt = (class_2487)class_25202;
            gameProfile = class_2512.method_10683((class_2487)claimedByNbt);
        } else {
            gameProfile = null;
        }
        GameProfile claimedBy = gameProfile;
        UUID id = nbt.method_10545("id") ? nbt.method_25926("id") : UUID.randomUUID();
        class_2487 deathMessageInfoNbt = nbt.method_10562("causeOfDeath");
        DeathMessageInfo deathMessageInfo = DeathMessageInfo.fromNbt(deathMessageInfoNbt);
        return new DeadPlayerData((class_2371<class_1799>)items, modInventories, pos, graveOwner, xp, worldIdentifier, dimName, deathMessageInfo, deathTime, availability, claimedBy, id);
    }

    public static class Soulbound {
        private static final Map<UUID, class_2371<class_1799>> soulboundInventories = new HashMap<UUID, class_2371<class_1799>>();
        private static final Map<UUID, Map<String, Object>> moddedSoulbound = new HashMap<UUID, Map<String, Object>>();
        private static final Map<UUID, Integer> soulboundXp = new HashMap<UUID, Integer>();

        public static class_2371<class_1799> getSoulboundInventory(UUID userId) {
            return soulboundInventories.get(userId);
        }

        public static Map<String, Object> getModdedSoulbound(UUID userId) {
            return moddedSoulbound.get(userId);
        }

        public static void setSoulboundInventories(UUID userId, class_2371<class_1799> soulboundItems) {
            Soulbound.dropSoulbound(userId);
            soulboundInventories.put(userId, soulboundItems);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void addModdedSoulbound(UUID userId, Object modInventory, String modName) {
            if (!moddedSoulbound.containsKey(userId)) {
                moddedSoulbound.put(userId, new HashMap());
            }
            moddedSoulbound.get(userId).put(modName, modInventory);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void setSoulboundXp(UUID userId, int amount) {
            Soulbound.dropSoulboundXp(userId);
            soulboundXp.put(userId, amount);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void dropSoulbound(UUID userId) {
            soulboundInventories.remove(userId);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void dropModdedSoulbound(UUID userId) {
            moddedSoulbound.remove(userId);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void dropSoulboundXp(UUID userId) {
            soulboundXp.remove(userId);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static class_2487 getNbt() {
            class_2487 nbt = new class_2487();
            class_2499 vanillaList = new class_2499();
            soulboundInventories.forEach((uuid, itemStacks) -> {
                class_2487 playerNbt = class_1262.method_5426((class_2487)new class_2487(), (class_2371)itemStacks);
                playerNbt.method_10569("inventorySize", itemStacks.size());
                playerNbt.method_25927("user", uuid);
                vanillaList.add((Object)playerNbt);
            });
            class_2499 modList = new class_2499();
            moddedSoulbound.forEach((uuid, objects) -> {
                class_2487 playerNbt = new class_2487();
                class_2487 inventories = new class_2487();
                for (YigdApi yigdApi : Yigd.apiMods) {
                    String modName = yigdApi.getModName();
                    if (!objects.containsKey(modName)) continue;
                    inventories.method_10566(modName, (class_2520)yigdApi.writeNbt(objects.get(modName)));
                }
                playerNbt.method_10566("Inventories", (class_2520)inventories);
                playerNbt.method_25927("user", uuid);
                modList.add((Object)playerNbt);
            });
            class_2499 xpList = new class_2499();
            soulboundXp.forEach((uuid, integer) -> {
                class_2487 c = new class_2487();
                c.method_10569("xp", integer.intValue());
                c.method_25927("user", uuid);
            });
            nbt.method_10566("vanilla", (class_2520)vanillaList);
            nbt.method_10566("mods", (class_2520)modList);
            nbt.method_10566("xp", (class_2520)xpList);
            return nbt;
        }

        public static void fromNbt(class_2487 nbt) {
            UUID userId;
            soulboundInventories.clear();
            moddedSoulbound.clear();
            soulboundXp.clear();
            class_2499 vanillaList = nbt.method_10554("vanilla", 10);
            class_2499 modList = nbt.method_10554("mods", 10);
            class_2499 xpList = nbt.method_10554("xp", 10);
            for (class_2520 e : vanillaList) {
                if (!(e instanceof class_2487)) continue;
                class_2487 cVanilla = (class_2487)e;
                int itemSize = cVanilla.method_10550("inventorySize");
                class_2371 items = class_2371.method_10213((int)itemSize, (Object)class_1799.field_8037);
                UUID userId2 = cVanilla.method_25926("user");
                class_1262.method_5429((class_2487)cVanilla, (class_2371)items);
                soulboundInventories.put(userId2, (class_2371<class_1799>)items);
            }
            for (class_2520 e : modList) {
                if (!(e instanceof class_2487)) continue;
                class_2487 cMods = (class_2487)e;
                class_2487 modsNbt = cMods.method_10562("Inventories");
                userId = cMods.method_25926("user");
                for (YigdApi yigdApi : Yigd.apiMods) {
                    String modName = yigdApi.getModName();
                    class_2487 modNbt = modsNbt.method_10562(modName);
                    Object modInventory = yigdApi.readNbt(modNbt);
                    Soulbound.addModdedSoulbound(userId, modInventory, modName);
                }
            }
            for (class_2520 e : xpList) {
                if (!(e instanceof class_2487)) continue;
                class_2487 cXp = (class_2487)e;
                int xpAmount = cXp.method_10550("xp");
                userId = cXp.method_25926("user");
                soulboundXp.put(userId, xpAmount);
            }
        }
    }
}

