/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.mixin;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.ScrollTypeConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.ServerPlayerEntityImpl;
import com.b1n_ry.yigd.item.KeyItem;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements ServerPlayerEntityImpl {
    private class_243 groundPos = null;

    @Shadow
    public abstract class_3218 method_14220();

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void onDeath(class_1282 source, CallbackInfo ci) {
        if (this.method_14220().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        class_3222 player = (class_3222)this;
        class_243 pos = player.method_19538();
        class_3218 playerWorld = player.method_14220();
        if (YigdConfig.getConfig().debugConfig.createGraveBeforeDeathMessage && !player.method_7325()) {
            Yigd.NEXT_TICK.add(() -> GraveHelper.onDeath((class_1657)player, (class_1937)playerWorld, pos, source));
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void onRespawn(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (alive || oldPlayer.method_7325()) {
            return;
        }
        class_3222 player = (class_3222)this;
        UUID userId = player.method_5667();
        if (player.method_14220().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        YigdConfig yigdConfig = YigdConfig.getConfig();
        if (yigdConfig.debugConfig.clearInventoryOnRespawn) {
            player.method_31548().method_5448();
            for (YigdApi yigdApi : Yigd.apiMods) {
                yigdApi.dropAll((class_1657)player);
            }
        }
        Map<String, Object> modSoulbounds = DeadPlayerData.Soulbound.getModdedSoulbound(userId);
        class_2371<class_1799> soulboundItems = DeadPlayerData.Soulbound.getSoulboundInventory(userId);
        if (soulboundItems != null || modSoulbounds != null) {
            if (soulboundItems != null && soulboundItems.size() > 0) {
                class_1661 inventory = player.method_31548();
                int mainSize = inventory.field_7547.size();
                int armorSize = inventory.field_7548.size();
                class_2371 curseBindingArmor = class_2371.method_10211();
                for (int i = 0; i < soulboundItems.size(); ++i) {
                    class_1799 stack = (class_1799)soulboundItems.get(i);
                    if (stack.method_7960()) continue;
                    if (i >= mainSize && i < mainSize + armorSize && class_1890.method_8224((class_1799)stack)) {
                        curseBindingArmor.add((Object)stack);
                        continue;
                    }
                    inventory.method_5447(i, stack);
                }
                class_2371 overFlow = class_2371.method_10211();
                for (class_1799 stack : curseBindingArmor) {
                    int i = inventory.method_7376();
                    if (i < 0) {
                        overFlow.add((Object)stack);
                        continue;
                    }
                    inventory.method_5447(i, stack);
                }
                if (overFlow.size() > 0) {
                    class_1264.method_17349((class_1937)player.field_6002, (class_2338)player.method_24515(), (class_2371)curseBindingArmor);
                }
            }
            Yigd.NEXT_TICK.add(() -> {
                if (modSoulbounds != null && modSoulbounds.size() > 0) {
                    for (YigdApi yigdApi : Yigd.apiMods) {
                        String modName = yigdApi.getModName();
                        if (!yigdApi.applySoulbound() || !modSoulbounds.containsKey(modName)) continue;
                        Object modSoulbound = modSoulbounds.get(modName);
                        yigdApi.setInventory(modSoulbound, (class_1657)player);
                    }
                }
            });
            DeadPlayerData.Soulbound.dropModdedSoulbound(userId);
            DeadPlayerData.Soulbound.dropSoulbound(userId);
        }
        try {
            List<DeadPlayerData> deadPlayerData = DeathInfoManager.INSTANCE.data.get(userId);
            if (deadPlayerData != null) {
                ArrayList<DeadPlayerData> availableData = new ArrayList<DeadPlayerData>();
                for (DeadPlayerData data : deadPlayerData) {
                    if (data.availability != 1) continue;
                    availableData.add(data);
                }
                if (availableData.size() > 0) {
                    DeadPlayerData latestDeath = (DeadPlayerData)availableData.get(availableData.size() - 1);
                    class_2338 deathPos = latestDeath.gravePos;
                    this.giveScroll((class_1657)player, latestDeath.id);
                    if (yigdConfig.utilitySettings.graveKeySettings.retrieveOnRespawn) {
                        KeyItem.giveStackToPlayer((class_1657)player, latestDeath.id);
                    }
                    if (yigdConfig.utilitySettings.graveCompassSettings.receiveOnDeath) {
                        class_1799 stack = class_1802.field_8251.method_7854();
                        class_2487 nbt = new class_2487();
                        nbt.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)latestDeath.gravePos));
                        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)latestDeath.worldId);
                        class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, (Object)worldKey).resultOrPartial(arg_0 -> ((Logger)Yigd.LOGGER).error(arg_0)).ifPresent(nbtElement -> nbt.method_10566("dimension", nbtElement));
                        stack.method_7959("pointTowards", (class_2520)nbt);
                        stack.method_7959("forGrave", (class_2520)class_2512.method_25929((UUID)latestDeath.id));
                        stack.method_7977((class_2561)class_2561.method_43471((String)"item.yigd.grave_compass").method_27694(style -> style.method_10978(Boolean.valueOf(false))));
                        player.method_7270(stack);
                    }
                    if (deathPos != null && yigdConfig.graveSettings.tellDeathPos) {
                        player.method_7353((class_2561)class_2561.method_43469((String)"text.yigd.message.grave_location_info", (Object[])new Object[]{deathPos.method_10263(), deathPos.method_10264(), deathPos.method_10260(), latestDeath.dimensionName}), false);
                    }
                }
            }
        }
        catch (Exception e) {
            Yigd.LOGGER.warn("Death data did not generate\n" + e);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void setGroundPos(CallbackInfo ci) {
        class_3222 player = (class_3222)this;
        if (player.method_24828()) {
            this.groundPos = player.method_19538();
        }
    }

    @Override
    public class_243 getLastGroundPos() {
        return this.groundPos;
    }

    private void giveScroll(class_1657 player, UUID graveId) {
        YigdConfig.UtilitySettings utilityConfig = YigdConfig.getConfig().utilitySettings;
        if (utilityConfig.scrollItem.scrollType == ScrollTypeConfig.DISABLED || !utilityConfig.scrollItem.retrieveOnRespawn) {
            return;
        }
        class_1799 stack = Yigd.SCROLL_ITEM.method_7854();
        class_2495 graveIdNbt = class_2512.method_25929((UUID)graveId);
        class_2495 playerIdNbt = class_2512.method_25929((UUID)player.method_5667());
        stack.method_7959("for_player", (class_2520)playerIdNbt);
        stack.method_7959("for_grave", (class_2520)graveIdNbt);
        player.method_7270(stack);
    }

    @Redirect(method={"createEndSpawnPlatform"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private boolean createEndSpawnPlatform(class_3218 world, class_2338 blockPos, class_2680 blockState) {
        GraveBlockEntity grave;
        class_2586 be = world.method_8321(blockPos);
        if (!(be instanceof GraveBlockEntity) || (grave = (GraveBlockEntity)be).getGraveOwner() == null) {
            return world.method_8501(blockPos, blockState);
        }
        return false;
    }
}

