/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block.entity;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1303;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class GraveBlockEntity
extends class_2586 {
    private GameProfile graveOwner = null;
    private int storedXp = 0;
    private String customName;
    private class_2371<class_1799> storedInventory = class_2371.method_10213((int)41, (Object)class_1799.field_8037);
    private Map<String, Object> moddedInventories;
    private UUID killer;
    public long creationTime = this.field_11863 != null ? this.field_11863.method_8510() : 0L;
    private UUID graveId;
    private GameProfile graveSkull = null;
    private class_2680 previousState;
    private boolean claimed;
    private boolean glowing;
    private static YigdConfig savedConfig = YigdConfig.getConfig();

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(Yigd.GRAVE_BLOCK_ENTITY, pos, state);
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
        this.previousState = class_2246.field_10124.method_9564();
        this.claimed = false;
        this.graveId = UUID.randomUUID();
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("StoredXp", this.storedXp);
        tag.method_10566("Items", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.storedInventory, (boolean)true));
        tag.method_10569("ItemCount", this.storedInventory.size());
        tag.method_10544("creationTime", this.creationTime);
        tag.method_10566("replaceState", (class_2520)class_2512.method_10686((class_2680)this.previousState));
        tag.method_10556("claimed", this.claimed);
        tag.method_25927("graveId", this.graveId);
        if (this.graveOwner != null) {
            tag.method_10566("owner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner));
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", this.customName);
        }
        if (this.graveSkull != null) {
            tag.method_10566("skull", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveSkull));
        }
        if (this.killer != null) {
            tag.method_25927("killer", this.killer);
        }
        if (this.moddedInventories != null) {
            class_2487 modNbt = new class_2487();
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                if (modName == null || !this.moddedInventories.containsKey(modName)) continue;
                modNbt.method_10566(modName, (class_2520)yigdApi.writeNbt(this.moddedInventories.get(modName)));
            }
            tag.method_10566("ModdedInventoryItems", (class_2520)modNbt);
        }
    }

    public void onBroken() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            if (this.graveOwner != null) {
                DeadPlayerData data = DeathInfoManager.findUserGrave(this.graveOwner.getId(), this.graveId);
                if (data != null && data.availability == 1) {
                    data.availability = (byte)-1;
                }
                DeathInfoManager.INSTANCE.method_80();
                Yigd.NEXT_TICK.add(() -> {
                    if (!this.claimed) {
                        class_2371 itemsToDrop = class_2371.method_10211();
                        itemsToDrop.addAll(this.storedInventory);
                        for (YigdApi yigdApi : Yigd.apiMods) {
                            Object inventory = this.moddedInventories.get(yigdApi.getModName());
                            itemsToDrop.addAll(yigdApi.toStackList(inventory));
                        }
                        class_1264.method_17349((class_1937)this.field_11863, (class_2338)this.field_11867, (class_2371)itemsToDrop);
                    }
                });
            } else if (this.graveSkull != null) {
                this.dropCosmeticSkull();
            }
        }
        super.method_11012();
    }

    public void dropCosmeticSkull() {
        class_1799 stack = class_1802.field_8575.method_7854();
        class_2487 nbt = stack.method_7969();
        if (this.graveSkull.getId() != null) {
            stack.method_7959("SkullOwner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveSkull));
        } else {
            if (nbt == null) {
                nbt = new class_2487();
            }
            nbt.method_10582("SkullOwner", this.graveSkull.getName());
            stack.method_7953(nbt);
        }
        if (this.field_11863 == null) {
            return;
        }
        class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stack);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storedInventory = class_2371.method_10213((int)tag.method_10550("ItemCount"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag.method_10562("Items"), this.storedInventory);
        this.storedXp = tag.method_10550("StoredXp");
        this.creationTime = tag.method_10545("creationTime") ? tag.method_10537("creationTime") : 0L;
        this.previousState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)tag.method_10562("replaceState"));
        this.claimed = tag.method_10545("claimed") && tag.method_10577("claimed");
        this.graveId = tag.method_25926("graveId");
        if (tag.method_10545("owner")) {
            this.graveOwner = class_2512.method_10683((class_2487)tag.method_10562("owner"));
        }
        if (tag.method_10545("CustomName")) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10545("skull")) {
            this.graveSkull = class_2512.method_10683((class_2487)tag.method_10562("skull"));
        }
        if (tag.method_10545("killer")) {
            this.killer = tag.method_25926("killer");
        }
        if (tag.method_10545("ModdedInventoryItems")) {
            this.moddedInventories = new HashMap<String, Object>();
            class_2487 modNbt = tag.method_10562("ModdedInventoryItems");
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                class_2487 nbt = modNbt.method_10562(modName);
                if (nbt == null) continue;
                this.moddedInventories.computeIfAbsent(modName, s -> yigdApi.readNbt(nbt));
            }
        }
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
        this.method_5431();
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = this.method_38244();
        nbt.method_10556("claimed", this.claimed);
        return nbt;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 ignoredState, class_2586 blockEntity) {
        boolean timeHasPassed;
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        if (world == null || world.field_9236) {
            return;
        }
        if (grave.getGraveOwner() == null) {
            return;
        }
        if ((int)world.method_8510() % 2400 == 0) {
            savedConfig = YigdConfig.getConfig();
        }
        YigdConfig.GraveDeletion deletion = GraveBlockEntity.savedConfig.graveSettings.graveDeletion;
        if (!deletion.canDelete || grave.claimed) {
            return;
        }
        if (grave.creationTime == 0L) {
            grave.creationTime = world.method_8510();
        }
        boolean bl = timeHasPassed = grave.creationTime + (long)deletion.afterTime * (long)deletion.timeType.tickFactor() <= world.method_8510();
        if (!timeHasPassed) {
            return;
        }
        if (deletion.dropInventory) {
            int xp = grave.getStoredXp();
            class_2371 dropItems = class_2371.method_10211();
            for (class_1799 stack : grave.getStoredInventory()) {
                if (stack.method_7960()) continue;
                dropItems.add((Object)stack);
            }
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object o = grave.moddedInventories.get(yigdApi.getModName());
                dropItems.addAll(yigdApi.toStackList(o));
            }
            if (!dropItems.isEmpty()) {
                class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)dropItems);
            }
            if (xp > 0 && world instanceof class_3218) {
                class_3218 sWorld = (class_3218)world;
                class_1303.method_31493((class_3218)sWorld, (class_243)class_243.method_24954((class_2382)pos), (int)xp);
            }
        }
        world.method_8650(pos, false);
        Yigd.LOGGER.info("Grave at %d %d %d expired".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        if (world.method_8503() == null || grave.graveOwner == null) {
            return;
        }
        class_3222 graveOwner = world.method_8503().method_3760().method_14602(grave.graveOwner.getId());
        if (graveOwner == null) {
            Yigd.notNotifiedPlayers.add(grave.graveOwner.getId());
            return;
        }
        graveOwner.method_7353((class_2561)class_2561.method_43471((String)("text.yigd.message.timeout" + (deletion.dropInventory ? ".dropped" : ""))), false);
    }

    public void setGraveOwner(GameProfile owner) {
        this.graveOwner = owner;
    }

    public void setStoredXp(int xp) {
        this.storedXp = xp;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.storedInventory = inventory;
    }

    public void setModdedInventories(Map<String, Object> inventories) {
        this.moddedInventories = inventories;
    }

    public void setKiller(UUID killerId) {
        this.killer = killerId;
    }

    public void setPreviousState(class_2680 state) {
        this.previousState = state;
    }

    public void setGraveSkull(GameProfile skullOwner) {
        this.graveSkull = skullOwner;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public GameProfile getGraveOwner() {
        return this.graveOwner;
    }

    public String getCustomName() {
        return this.customName;
    }

    public class_2371<class_1799> getStoredInventory() {
        return this.storedInventory;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public Map<String, Object> getModdedInventories() {
        return this.moddedInventories;
    }

    public UUID getKiller() {
        return this.killer;
    }

    public boolean canGlow() {
        return this.glowing;
    }

    public class_2680 getPreviousState() {
        return this.previousState;
    }

    public UUID getGraveId() {
        return this.graveId;
    }

    public GameProfile getGraveSkull() {
        return this.graveSkull;
    }

    public boolean isClaimed() {
        return this.claimed;
    }
}

