/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.DeathEffectConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.ModTags;
import com.b1n_ry.yigd.mixin.OriginKeepInventoryPowerAccessor;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.KeepInventoryPower;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class OriginsCompat
implements YigdApi {
    @Override
    public String getModName() {
        return "apoli";
    }

    @Override
    public Object getInventory(class_1657 player, boolean onDeath, @Nullable DeathEffectConfig onDeathHandling) {
        YigdConfig config = YigdConfig.getConfig();
        HashMap powerLists = new HashMap();
        HashMap soulboundLists = new HashMap();
        PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class).forEach(inventoryPower -> {
            Active.Key key = inventoryPower.getKey();
            class_2371 soulboundInv = class_2371.method_10213((int)inventoryPower.method_5439(), (Object)class_1799.field_8037);
            class_2371 fullInv = class_2371.method_10213((int)inventoryPower.method_5439(), (Object)class_1799.field_8037);
            for (int i = 0; i < inventoryPower.method_5439(); ++i) {
                class_1799 currentStack = inventoryPower.method_5438(i);
                if (onDeath) {
                    if (!inventoryPower.shouldDropOnDeath(currentStack) || currentStack.method_31573(ModTags.SOULBOUND_ITEM) || onDeathHandling == DeathEffectConfig.KEEP_ITEMS || GraveHelper.hasBotaniaKeepIvy(currentStack, true)) {
                        soulboundInv.set(i, (Object)currentStack);
                        continue;
                    }
                    if (GraveHelper.hasEnchantments(config.graveSettings.soulboundEnchantments, currentStack)) {
                        if (config.graveSettings.loseSoulboundLevelOnDeath) {
                            GraveHelper.removeEnchantmentLevel(currentStack, config.graveSettings.soulboundEnchantments);
                        }
                        soulboundInv.set(i, (Object)currentStack);
                        continue;
                    }
                    if (GraveHelper.hasEnchantments(config.graveSettings.deleteEnchantments, currentStack)) continue;
                    fullInv.set(i, (Object)currentStack);
                    continue;
                }
                fullInv.set(i, (Object)currentStack);
            }
            soulboundLists.put(key.key, soulboundInv);
            powerLists.put(key.key, fullInv);
        });
        if (onDeath) {
            DeadPlayerData.Soulbound.addModdedSoulbound(player.method_5667(), soulboundLists, this.getModName());
        }
        return powerLists;
    }

    @Override
    public class_2371<class_1799> setInventory(Object inventory, class_1657 player) {
        Map allItems;
        class_2371 extraItems = class_2371.method_10211();
        if (!(inventory instanceof Map) || (allItems = (Map)inventory).isEmpty()) {
            return extraItems;
        }
        PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class).forEach(inventoryPower -> {
            Object patt3908$temp = allItems.get(inventoryPower.getKey().key);
            if (!(patt3908$temp instanceof class_2371)) {
                return;
            }
            class_2371 items = (class_2371)patt3908$temp;
            for (int i = 0; i < items.size(); ++i) {
                Object patt4042$temp = items.get(i);
                if (!(patt4042$temp instanceof class_1799)) continue;
                class_1799 item = (class_1799)patt4042$temp;
                if (i >= inventoryPower.method_5439() || !inventoryPower.method_5438(i).method_7960()) {
                    extraItems.add((Object)item);
                    continue;
                }
                inventoryPower.method_5447(i, item);
            }
        });
        return extraItems;
    }

    @Override
    public int getInventorySize(Object inventory) {
        Map m;
        if (!(inventory instanceof Map) || (m = (Map)inventory).isEmpty()) {
            return 0;
        }
        int totalItems = 0;
        for (Map.Entry entry : m.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof class_2371)) continue;
            class_2371 items = (class_2371)object;
            for (Object o : items) {
                class_1799 item;
                if (!(o instanceof class_1799) || (item = (class_1799)o).method_7960()) continue;
                ++totalItems;
            }
        }
        return totalItems;
    }

    @Override
    public void dropAll(class_1657 player) {
        PowerHolderComponent.getPowers((class_1297)player, InventoryPower.class).forEach(InventoryPower::method_5448);
    }

    @Override
    public List<class_1799> toStackList(Object inventory) {
        Map m;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!(inventory instanceof Map) || (m = (Map)inventory).isEmpty()) {
            return stacks;
        }
        for (Map.Entry entry : m.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof class_2371)) continue;
            class_2371 items = (class_2371)object;
            for (Object item : items) {
                class_1799 stack;
                if (!(item instanceof class_1799) || (stack = (class_1799)item).method_7960()) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    @Override
    public class_2487 writeNbt(Object o) {
        Map m;
        class_2487 nbt = new class_2487();
        if (!(o instanceof Map) || (m = (Map)o).isEmpty()) {
            return nbt;
        }
        for (Map.Entry entry : m.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof class_2371)) continue;
            class_2371 items = (class_2371)object;
            object = entry.getKey();
            if (!(object instanceof Active.Key)) continue;
            Active.Key key = (Active.Key)object;
            class_2487 inventoryNbt = class_1262.method_5426((class_2487)new class_2487(), (class_2371)items);
            inventoryNbt.method_10569("size", items.size());
            nbt.method_10566(key.key, (class_2520)inventoryNbt);
        }
        return nbt;
    }

    @Override
    public Object readNbt(class_2487 nbt) {
        HashMap<String, class_2371> inventory = new HashMap<String, class_2371>();
        for (String key : nbt.method_10541()) {
            class_2487 inventoryNbt = nbt.method_10562(key);
            if (inventoryNbt == null || inventoryNbt.method_33133()) continue;
            int inventorySize = inventoryNbt.method_10550("size");
            class_2371 items = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)inventoryNbt, (class_2371)items);
            inventory.put(key, items);
        }
        return inventory;
    }

    public static boolean shouldSaveSlot(class_1657 player, int slot) {
        for (KeepInventoryPower keepInventoryPower : PowerHolderComponent.getPowers((class_1297)player, KeepInventoryPower.class)) {
            Set<Integer> slots = ((OriginKeepInventoryPowerAccessor)keepInventoryPower).getSlots();
            Predicate<class_1799> keepItemCondition = ((OriginKeepInventoryPowerAccessor)keepInventoryPower).getKeepItemCondition();
            if (slots != null && !slots.contains(slot)) {
                return false;
            }
            class_1799 stack = player.method_31548().method_5438(slot);
            if (stack.method_7960() || keepItemCondition != null && !keepItemCondition.test(stack)) continue;
            return true;
        }
        return false;
    }
}

