/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.DeathEffectConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.ModTags;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class TrinketsCompat
implements YigdApi {
    @Override
    public String getModName() {
        return "trinkets";
    }

    @Override
    public Object getInventory(class_1657 player, boolean onDeath, @Nullable DeathEffectConfig onDeathHandling) {
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optional.isEmpty()) {
            return new HashMap();
        }
        TrinketComponent component = (TrinketComponent)optional.get();
        Map inventory = component.getInventory();
        HashMap playerInv = new HashMap();
        YigdConfig config = YigdConfig.getConfig();
        List<String> soulboundEnchantments = config.graveSettings.soulboundEnchantments;
        List<String> deleteEnchantments = config.graveSettings.deleteEnchantments;
        HashMap soulbound = new HashMap();
        inventory.forEach((group, slots) -> {
            Map soulGroupRef = soulbound.computeIfAbsent(group, s -> new HashMap());
            Map invGroupRef = playerInv.computeIfAbsent(group, s -> new HashMap());
            slots.forEach((slot, trinkets) -> {
                class_2371 soulInv = class_2371.method_10211();
                class_2371 stacks = class_2371.method_10211();
                TrinketEnums.DropRule defaultDropRule = trinkets.getSlotType().getDropRule();
                for (int i = 0; i < trinkets.method_5439(); ++i) {
                    class_1799 stack = trinkets.method_5438(i);
                    if (stack.method_7960()) continue;
                    boolean removed = false;
                    if (onDeath) {
                        SlotReference ref = new SlotReference(trinkets, i);
                        TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket((class_1792)stack.method_7909()).getDropRule(stack, ref, (class_1309)player);
                        if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                            dropRule = defaultDropRule;
                        }
                        if ((GraveHelper.hasEnchantments(deleteEnchantments, stack) || GraveHelper.hasBotaniaKeepIvy(stack, true) || dropRule == TrinketEnums.DropRule.DESTROY) && !config.graveSettings.graveCompatConfig.keepAllTrinkets) {
                            trinkets.method_5447(i, class_1799.field_8037);
                            removed = true;
                        } else if (GraveHelper.hasEnchantments(soulboundEnchantments, stack)) {
                            if (config.graveSettings.loseSoulboundLevelOnDeath) {
                                GraveHelper.removeEnchantmentLevel(stack, soulboundEnchantments);
                            }
                            trinkets.method_5447(i, class_1799.field_8037);
                            soulInv.add((Object)stack);
                            removed = true;
                        } else if (stack.method_31573(ModTags.SOULBOUND_ITEM) || onDeathHandling == DeathEffectConfig.KEEP_ITEMS || config.graveSettings.graveCompatConfig.keepAllTrinkets || dropRule == TrinketEnums.DropRule.KEEP) {
                            trinkets.method_5447(i, class_1799.field_8037);
                            soulInv.add((Object)stack);
                            removed = true;
                        }
                    }
                    if (removed) continue;
                    stacks.add((Object)stack);
                }
                soulGroupRef.computeIfAbsent(slot, s -> soulInv);
                invGroupRef.computeIfAbsent(slot, s -> stacks);
            });
        });
        if (onDeath) {
            DeadPlayerData.Soulbound.addModdedSoulbound(player.method_5667(), soulbound, this.getModName());
        }
        return playerInv;
    }

    @Override
    public class_2371<class_1799> setInventory(Object inventory, class_1657 player) {
        class_2371 extraItems = class_2371.method_10211();
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optional.isEmpty()) {
            return extraItems;
        }
        TrinketComponent playerComponent = (TrinketComponent)optional.get();
        if (!(inventory instanceof Map)) {
            return extraItems;
        }
        Map fullInv = (Map)inventory;
        fullInv.forEach((g, map) -> {
            Map groupInv;
            block3: {
                block2: {
                    if (!(map instanceof Map)) break block2;
                    groupInv = (Map)map;
                    if (g instanceof String) break block3;
                }
                return;
            }
            String group = (String)g;
            groupInv.forEach((s, trinket) -> {
                class_2371 stacks;
                block8: {
                    block7: {
                        if (!(trinket instanceof class_2371)) break block7;
                        stacks = (class_2371)trinket;
                        if (s instanceof String) break block8;
                    }
                    return;
                }
                String slot = (String)s;
                if (playerComponent.getInventory().get(group) == null) {
                    extraItems.addAll((Collection)stacks);
                    return;
                }
                TrinketInventory equippedInv = (TrinketInventory)((Map)playerComponent.getInventory().get(group)).get(slot);
                if (equippedInv == null) {
                    extraItems.addAll((Collection)stacks);
                    return;
                }
                for (int i = 0; i < Math.min(equippedInv.method_5439(), stacks.size()); ++i) {
                    Object patt5952$temp = stacks.get(i);
                    if (!(patt5952$temp instanceof class_1799)) continue;
                    class_1799 stack = (class_1799)patt5952$temp;
                    class_1799 equipped = equippedInv.method_5438(i);
                    if (!equipped.method_7960()) {
                        extraItems.add((Object)stack);
                        continue;
                    }
                    equippedInv.method_5447(i, stack);
                }
            });
        });
        return extraItems;
    }

    @Override
    public int getInventorySize(Object inventory) {
        if (!(inventory instanceof Map)) {
            return 0;
        }
        Map modInv = (Map)inventory;
        ArrayList items = new ArrayList();
        modInv.forEach((g, group) -> group.forEach((s, slot) -> slot.forEach(stack -> {
            if (stack == null || stack.method_7960()) {
                return;
            }
            items.add(stack);
        })));
        return items.size();
    }

    @Override
    public void dropAll(class_1657 player) {
        Optional optional = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optional.isEmpty()) {
            return;
        }
        TrinketComponent component = (TrinketComponent)optional.get();
        component.forEach((ref, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            ref.inventory().method_5448();
        });
    }

    @Override
    public List<class_1799> toStackList(Object inventory) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!(inventory instanceof Map)) {
            return stacks;
        }
        Map inv = (Map)inventory;
        inv.forEach((group, slots) -> {
            if (!(slots instanceof Map)) {
                return;
            }
            Map slotMap = (Map)slots;
            slotMap.forEach((slot, items) -> {
                if (!(items instanceof class_2371)) {
                    return;
                }
                class_2371 trinketInv = (class_2371)items;
                for (class_1799 item : trinketInv) {
                    if (item.method_7960()) continue;
                    stacks.add(item);
                }
            });
        });
        return stacks;
    }

    @Override
    public class_2487 writeNbt(Object o) {
        class_2487 nbt = new class_2487();
        if (!(o instanceof Map)) {
            return nbt;
        }
        Map inv = (Map)o;
        inv.forEach((group, slots) -> {
            String groupName;
            block3: {
                block2: {
                    if (!(group instanceof String)) break block2;
                    groupName = (String)group;
                    if (slots instanceof Map) break block3;
                }
                return;
            }
            Map slotMap = (Map)slots;
            class_2487 groupNbt = new class_2487();
            slotMap.forEach((slot, items) -> {
                String slotName;
                block3: {
                    block2: {
                        if (!(slot instanceof String)) break block2;
                        slotName = (String)slot;
                        if (items instanceof class_2371) break block3;
                    }
                    return;
                }
                class_2371 stacks = (class_2371)items;
                groupNbt.method_10566(slotName, (class_2520)class_1262.method_5426((class_2487)new class_2487(), (class_2371)stacks));
            });
            nbt.method_10566(groupName, (class_2520)groupNbt);
        });
        return nbt;
    }

    @Override
    public Object readNbt(class_2487 nbt) {
        HashMap<String, Map> inventory = new HashMap<String, Map>();
        Set groupKeys = nbt.method_10541();
        for (String groupKey : groupKeys) {
            class_2487 groupNbt = (class_2487)nbt.method_10580(groupKey);
            Map groupMap = inventory.computeIfAbsent(groupKey, s -> new HashMap());
            if (groupNbt == null) continue;
            Set slotKeys = groupNbt.method_10541();
            for (String slotKey : slotKeys) {
                class_2487 itemsNbt = (class_2487)groupNbt.method_10580(slotKey);
                if (itemsNbt == null) continue;
                class_2499 nbtList = itemsNbt.method_10554("Items", 10);
                class_2371 items = class_2371.method_10213((int)nbtList.size(), (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)itemsNbt, (class_2371)items);
                groupMap.putIfAbsent(slotKey, items);
            }
        }
        return inventory;
    }
}

