/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class GraveAreaOverride {
    private static final List<GraveArea> areaOverrides = new ArrayList<GraveArea>();

    public static void reloadGraveAreas(JsonObject graveAreas) {
        areaOverrides.clear();
        JsonArray values = graveAreas.getAsJsonArray("values");
        if (values == null) {
            return;
        }
        for (JsonElement e : values) {
            if (!e.isJsonObject()) continue;
            JsonObject area = e.getAsJsonObject();
            JsonArray fromCords = area.getAsJsonArray("from");
            JsonArray toCords = area.getAsJsonArray("to");
            class_2338 fromPos = new class_2338(fromCords.get(0).getAsInt(), fromCords.get(1).getAsInt(), fromCords.get(2).getAsInt());
            class_2338 toPos = new class_2338(toCords.get(0).getAsInt(), toCords.get(1).getAsInt(), toCords.get(2).getAsInt());
            boolean placeGraves = area.get("place_graves").getAsBoolean();
            boolean yDependant = area.get("y_dependant").getAsBoolean();
            String worldId = area.get("world_id").getAsString();
            areaOverrides.add(new GraveArea(placeGraves, yDependant, fromPos, toPos, new class_2960(worldId)));
        }
    }

    public static boolean canGenerateOnPos(class_2338 pos, class_2960 worldId, boolean defaultGraves) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        for (GraveArea area : areaOverrides) {
            if (!area.worldId.equals((Object)worldId) || x < area.fromCorner.method_10263() || x > area.toCorner.method_10263() || z < area.fromCorner.method_10260() || z > area.toCorner.method_10260() || area.yDependant && (y < area.fromCorner.method_10264() || y > area.toCorner.method_10264())) continue;
            return area.placeGraves;
        }
        return defaultGraves;
    }

    public record GraveArea(boolean placeGraves, boolean yDependant, class_2338 fromCorner, class_2338 toCorner, class_2960 worldId) {
    }
}

