/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.compat.RequiemCompat;
import com.b1n_ry.yigd.config.LastResortConfig;
import com.b1n_ry.yigd.config.PriorityInventoryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.ModTags;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3033;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.server.MinecraftServer;

public class GraveHelper {
    public static List<Integer> getInventoryOpenSlots(class_2371<class_1799> inventory) {
        ArrayList<Integer> openSlots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.size(); ++i) {
            if (inventory.get(i) != class_1799.field_8037) continue;
            openSlots.add(i);
        }
        return openSlots;
    }

    public static void deleteItemFromList(class_2371<class_1799> itemList, boolean asStack, List<String> ignoreEnchantments) {
        YigdConfig.ItemLoss itemLoss = YigdConfig.getConfig().graveSettings.itemLoss;
        ArrayList<Integer> itemSlots = new ArrayList<Integer>();
        for (int i = 0; i < itemList.size(); ++i) {
            class_1799 stack = (class_1799)itemList.get(i);
            if (!stack.method_7960() || stack.method_31573(ModTags.RANDOM_DELETE_BLACKLIST) || GraveHelper.hasEnchantments(ignoreEnchantments, stack) || itemLoss.ignoreSoulboundItems && stack.method_31573(ModTags.SOULBOUND_ITEM) || GraveHelper.hasBotaniaKeepIvy(stack, false)) continue;
            itemSlots.add(i);
        }
        int random = new Random().nextInt(itemSlots.size());
        int slot = (Integer)itemSlots.get(random);
        class_1799 stack = (class_1799)itemList.get(slot);
        if (asStack) {
            itemList.set(slot, (Object)class_1799.field_8037);
        } else {
            stack.method_7934(1);
        }
    }

    public static void placeDeathGrave(class_1937 world, class_243 pos, class_1657 player, class_2371<class_1799> invItems, List<Object> modInventories, int xpPoints, class_1282 source) {
        class_2338 blockPos;
        if (world.method_8608()) {
            return;
        }
        int bottomY = world.method_31607();
        int topY = world.method_31600();
        if (!YigdConfig.getConfig().graveSettings.graveInVoid && pos.field_1351 < (double)(bottomY + 1)) {
            return;
        }
        double yPos = pos.field_1351 - 1.0;
        if ((int)yPos != (int)(yPos + 0.5) && player.method_24828()) {
            yPos += 1.0;
        }
        if ((blockPos = new class_2338(pos.field_1352, (double)((int)yPos), pos.field_1350)).method_10264() <= bottomY) {
            blockPos = new class_2338(blockPos.method_10263(), bottomY + YigdConfig.getConfig().graveSettings.graveSpawnHeight, blockPos.method_10260());
        } else if (blockPos.method_10264() >= topY) {
            blockPos = new class_2338(blockPos.method_10263(), topY - 2, blockPos.method_10260());
        }
        double boundEast = world.method_8621().method_11963();
        double boundWest = world.method_8621().method_11976();
        double boundSouth = world.method_8621().method_11977();
        double boundNorth = world.method_8621().method_11958();
        if ((double)blockPos.method_10263() >= boundEast) {
            blockPos = new class_2338(boundEast - 1.0, (double)blockPos.method_10264(), (double)blockPos.method_10260());
        } else if ((double)blockPos.method_10263() <= boundWest) {
            blockPos = new class_2338(boundWest + 1.0, (double)blockPos.method_10264(), (double)blockPos.method_10260());
        }
        if ((double)blockPos.method_10260() >= boundSouth) {
            blockPos = new class_2338((double)blockPos.method_10263(), (double)blockPos.method_10264(), boundSouth - 1.0);
        } else if ((double)blockPos.method_10260() <= boundNorth) {
            blockPos = new class_2338((double)blockPos.method_10263(), (double)blockPos.method_10264(), boundNorth + 1.0);
        }
        boolean foundViableGrave = false;
        MinecraftServer server = world.method_8503();
        if (server != null && Yigd.graveyard != null) {
            JsonElement json = Yigd.graveyard.get("coordinates");
            boolean point2point = Yigd.graveyard.get("point2point").getAsBoolean();
            class_3218 overworld = world.method_8503().method_30002();
            if (json instanceof JsonArray) {
                JsonElement xyz2;
                JsonArray coordinates = (JsonArray)json;
                if (!point2point) {
                    for (JsonElement blockPosition : coordinates) {
                        boolean isPlaced;
                        class_2338 gravePos;
                        String dir;
                        if (!(blockPosition instanceof JsonObject)) continue;
                        JsonObject xyz2 = (JsonObject)blockPosition;
                        int x = xyz2.get("x").getAsInt();
                        int y = xyz2.get("y").getAsInt();
                        int z = xyz2.get("z").getAsInt();
                        if (!GraveHelper.gravePlaceableAt((class_1937)overworld, gravePos = new class_2338(x, y, z), false) || !(isPlaced = GraveHelper.placeGraveBlock(player, (class_1937)overworld, gravePos, invItems, modInventories, xpPoints, source, switch (dir = xyz2.get("direction") != null ? xyz2.get("direction").getAsString() : "none") {
                            case "NORTH" -> class_2350.field_11043;
                            case "SOUTH" -> class_2350.field_11035;
                            case "WEST" -> class_2350.field_11039;
                            case "EAST" -> class_2350.field_11034;
                            default -> player.method_5735();
                        }))) continue;
                        foundViableGrave = true;
                        break;
                    }
                } else if (coordinates.size() >= 2 && (xyz2 = coordinates.get(0)) instanceof JsonObject) {
                    JsonObject pos1 = (JsonObject)xyz2;
                    xyz2 = coordinates.get(1);
                    if (xyz2 instanceof JsonObject) {
                        JsonObject pos2 = (JsonObject)xyz2;
                        int x1 = pos1.get("x").getAsInt();
                        int x2 = pos2.get("x").getAsInt();
                        int y1 = pos1.get("y").getAsInt();
                        int y2 = pos2.get("y").getAsInt();
                        int z1 = pos1.get("z").getAsInt();
                        int z2 = pos2.get("z").getAsInt();
                        int changeX = (x2 - x1) / Math.abs(x2 - x1 != 0 ? x2 - x1 : 1);
                        int changeY = (y2 - y1) / Math.abs(y2 - y1 != 0 ? y2 - y1 : 1);
                        int changeZ = (z2 - z1) / Math.abs(z2 - z1 != 0 ? z2 - z1 : 1);
                        for (int y = y1; y != y2 && !foundViableGrave; y += changeY) {
                            block14: for (int z = z1; z != z2 && !foundViableGrave; z += changeZ) {
                                for (int x = x1; x != x2; x += changeX) {
                                    boolean isPlaced;
                                    class_2338 gravePos = new class_2338(x, y, z);
                                    if (!GraveHelper.gravePlaceableAt((class_1937)overworld, gravePos, false) || !(isPlaced = GraveHelper.placeGraveBlock(player, (class_1937)overworld, gravePos, invItems, modInventories, xpPoints, source))) continue;
                                    foundViableGrave = true;
                                    continue block14;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!foundViableGrave && YigdConfig.getConfig().graveSettings.trySoft) {
            for (class_2338 gravePos : class_2338.method_25996((class_2338)blockPos.method_10081(new class_2382(0, 1, 0)), (int)5, (int)5, (int)5)) {
                boolean isPlaced;
                if (!GraveHelper.gravePlaceableAt(world, gravePos, false) || !(isPlaced = GraveHelper.placeGraveBlock(player, world, gravePos, invItems, modInventories, xpPoints, source))) continue;
                foundViableGrave = true;
                break;
            }
        }
        if (!foundViableGrave && YigdConfig.getConfig().graveSettings.tryStrict) {
            for (class_2338 gravePos : class_2338.method_25996((class_2338)blockPos.method_10081(new class_2382(0, 1, 0)), (int)5, (int)5, (int)5)) {
                boolean isPlaced;
                if (!GraveHelper.gravePlaceableAt(world, gravePos, true) || !(isPlaced = GraveHelper.placeGraveBlock(player, world, gravePos, invItems, modInventories, xpPoints, source))) continue;
                foundViableGrave = true;
                break;
            }
        }
        if (!foundViableGrave) {
            boolean isPlaced = false;
            if (YigdConfig.getConfig().graveSettings.lastResort == LastResortConfig.SET_GRAVE && !(isPlaced = GraveHelper.placeGraveBlock(player, world, blockPos, invItems, modInventories, xpPoints, source))) {
                Yigd.LOGGER.warn("Failed to set grave as a last resort");
            }
            if (!isPlaced) {
                for (YigdApi yigdApi : Yigd.apiMods) {
                    invItems.addAll(yigdApi.toStackList(player));
                }
                class_1264.method_17349((class_1937)world, (class_2338)blockPos, invItems);
                class_1303.method_31493((class_3218)((class_3218)world), (class_243)new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (int)xpPoints);
                Yigd.LOGGER.info("Dropped items as a last resort");
            }
        }
    }

    private static boolean gravePlaceableAt(class_1937 world, class_2338 blockPos, boolean strict) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            return false;
        }
        double boundEast = world.method_8621().method_11963();
        double boundWest = world.method_8621().method_11976();
        double boundSouth = world.method_8621().method_11977();
        double boundNorth = world.method_8621().method_11958();
        boolean hasTag = false;
        class_2680 block = world.method_8320(blockPos);
        if (strict) {
            if (block.method_26164(ModTags.REPLACE_BLACKLIST)) {
                hasTag = true;
            }
        } else if (block.method_26164(ModTags.SOFT_WHITELIST)) {
            hasTag = true;
        }
        if (hasTag && strict || !hasTag && !strict) {
            return false;
        }
        int xPos = blockPos.method_10263();
        int yPos = blockPos.method_10264();
        int zPos = blockPos.method_10260();
        return !((double)xPos >= boundEast && (double)xPos <= boundWest && yPos <= world.method_31607() && yPos >= world.method_31600() && (double)zPos <= boundNorth && (double)zPos >= boundSouth);
    }

    private static boolean placeGraveBlock(class_1657 player, class_1937 world, class_2338 gravePos, class_2371<class_1799> invItems, List<Object> modInventories, int xpPoints, class_1282 source) {
        class_2350 direction = player.method_5735();
        return GraveHelper.placeGraveBlock(player, world, gravePos, invItems, modInventories, xpPoints, source, direction);
    }

    private static boolean placeGraveBlock(class_1657 player, class_1937 world, class_2338 gravePos, class_2371<class_1799> invItems, List<Object> modInventories, int xpPoints, class_1282 source, class_2350 direction) {
        class_2586 placed;
        class_2680 blockUnder;
        boolean canPlaceUnder;
        class_2874 playerDimension = player.field_6002.method_8597();
        class_2378 dimManager = player.field_6002.method_30349().method_30530(class_2378.field_25095);
        class_2960 playerWorldId = dimManager.method_10221((Object)playerDimension);
        if (playerWorldId != null && playerWorldId.equals((Object)class_2874.field_26754) && class_3033.field_13600.method_19771((class_2382)gravePos, 10.0) && world.method_8320(gravePos.method_10074()).method_27852(class_2246.field_9987)) {
            gravePos = gravePos.method_10084();
        }
        class_2680 previousState = world.method_8320(gravePos);
        boolean waterlogged = world.method_8316(gravePos) == class_3612.field_15910.method_15785();
        class_2680 graveBlock = (class_2680)((class_2680)Yigd.GRAVE_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)direction)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged));
        boolean isPlaced = world.method_8501(gravePos, graveBlock);
        if (!isPlaced) {
            return false;
        }
        class_2338 blockPosUnder = gravePos.method_10074();
        YigdConfig.BlockUnderGrave blockUnderConfig = YigdConfig.getConfig().graveSettings.blockUnderGrave;
        if (blockUnderConfig.generateBlockUnder && blockPosUnder.method_10264() >= world.method_31607() + 1 && (canPlaceUnder = (blockUnder = world.method_8320(blockPosUnder)).method_26164(ModTags.SUPPORT_REPLACE_WHITELIST))) {
            String replaceUnderBlock = world.method_27983() == class_1937.field_25179 ? blockUnderConfig.inOverWorld : (world.method_27983() == class_1937.field_25180 ? blockUnderConfig.inNether : (world.method_27983() == class_1937.field_25181 ? blockUnderConfig.inTheEnd : blockUnderConfig.inCustom));
            class_2960 blockIdentifier = class_2960.method_12829((String)replaceUnderBlock);
            class_2680 blockStateUnder = blockIdentifier == null ? class_2246.field_10566.method_9564() : ((class_2248)class_2378.field_11146.method_10223(blockIdentifier)).method_9564();
            world.method_8501(blockPosUnder, blockStateUnder);
        }
        if ((placed = world.method_8321(gravePos)) instanceof GraveBlockEntity) {
            GraveBlockEntity placedGraveEntity = (GraveBlockEntity)placed;
            GameProfile playerProfile = player.method_7334();
            if (FabricLoader.getInstance().isModLoaded("requiem") && RequiemCompat.isPlayerShellEntity(player)) {
                playerProfile = RequiemCompat.getDisplayProfile(player);
            }
            HashMap<String, Object> moddedInvStacks = new HashMap<String, Object>();
            for (int i = 0; i < Yigd.apiMods.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                moddedInvStacks.put(yigdApi.getModName(), modInventories.get(i));
            }
            class_1297 e = source.method_5526();
            UUID killerId = e instanceof class_1657 ? e.method_5667() : null;
            placedGraveEntity.setInventory(invItems);
            placedGraveEntity.setGraveOwner(playerProfile);
            placedGraveEntity.setGraveSkull(playerProfile);
            placedGraveEntity.setCustomName(playerProfile.getName());
            placedGraveEntity.setStoredXp(xpPoints);
            placedGraveEntity.setModdedInventories(moddedInvStacks);
            placedGraveEntity.setKiller(killerId);
            placedGraveEntity.setPreviousState(previousState);
            DeadPlayerData deadData = DeadPlayerData.create(invItems, modInventories, gravePos, player.method_7334(), xpPoints, world, source, placedGraveEntity.getGraveId());
            UUID userId = player.method_5667();
            if (!DeathInfoManager.INSTANCE.data.containsKey(userId)) {
                ArrayList<DeadPlayerData> deadPlayerData = new ArrayList<DeadPlayerData>();
                deadPlayerData.add(deadData);
                DeathInfoManager.INSTANCE.data.put(userId, deadPlayerData);
            } else {
                List<DeadPlayerData> playerGraves = DeathInfoManager.INSTANCE.data.get(userId);
                playerGraves.add(deadData);
                if (playerGraves.size() > YigdConfig.getConfig().graveSettings.maxGraveBackups) {
                    playerGraves.remove(0);
                }
            }
            DeathInfoManager.INSTANCE.method_80();
            Yigd.LOGGER.info("Grave spawned at: " + gravePos.method_10263() + ", " + gravePos.method_10264() + ", " + gravePos.method_10260() + " | " + deadData.dimensionName);
        }
        return true;
    }

    public static void removeFromList(class_2371<class_1799> list, class_2371<class_1799> remove) {
        for (class_1799 item : remove) {
            int match = list.indexOf((Object)item);
            if (match < 0) continue;
            list.set(match, (Object)class_1799.field_8037);
        }
    }

    public static class_2371<class_1799> getEnchantedItems(class_2371<class_1799> items, List<String> enchantStrings) {
        class_2371 included = class_2371.method_10213((int)items.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = (class_1799)items.get(i);
            if (!GraveHelper.hasEnchantments(enchantStrings, item)) continue;
            included.set(i, (Object)item);
        }
        return included;
    }

    public static boolean hasEnchantments(List<String> enchants, class_1799 item) {
        if (!item.method_7942()) {
            return false;
        }
        for (class_2520 enchantment : item.method_7921()) {
            String enchantId = ((class_2487)enchantment).method_10558("id");
            if (!enchants.stream().anyMatch(enchantId::equals)) continue;
            return true;
        }
        return false;
    }

    public static void RetrieveItems(class_1657 player, class_2371<class_1799> graveInv, Map<String, Object> modInventories, int xp, boolean robbing) {
        class_2371<class_1799> extraItems;
        class_1661 inventory = player.method_31548();
        class_2371 invInventory = class_2371.method_10211();
        invInventory.addAll((Collection)inventory.field_7547);
        invInventory.addAll((Collection)inventory.field_7548);
        invInventory.addAll((Collection)inventory.field_7544);
        int currentSize = invInventory.size();
        if (inventory.method_5439() > currentSize) {
            for (int i = currentSize; i < inventory.method_5439(); ++i) {
                invInventory.add((Object)inventory.method_5438(i));
            }
        }
        HashMap<String, Object> currentModInv = new HashMap<String, Object>();
        for (YigdApi yigdApi : Yigd.apiMods) {
            Object modInv = yigdApi.getInventory(player);
            currentModInv.put(yigdApi.getModName(), modInv);
            yigdApi.dropAll(player);
        }
        inventory.method_5448();
        UUID playerId = player.method_5667();
        PriorityInventoryConfig priorityInventory = robbing ? (Yigd.clientRobPriorities.containsKey(playerId) ? Yigd.clientRobPriorities.get(playerId) : YigdConfig.getConfig().graveSettings.graveRobbing.robPriority) : (Yigd.clientPriorities.containsKey(playerId) ? Yigd.clientPriorities.get(playerId) : YigdConfig.getConfig().graveSettings.priority);
        if (priorityInventory == PriorityInventoryConfig.GRAVE) {
            extraItems = GraveHelper.fillInventory(player, graveInv, modInventories, true);
            extraItems.addAll(GraveHelper.fillInventory(player, (class_2371<class_1799>)invInventory, currentModInv, false));
        } else {
            extraItems = GraveHelper.fillInventory(player, (class_2371<class_1799>)invInventory, currentModInv, false);
            extraItems.addAll(GraveHelper.fillInventory(player, graveInv, modInventories, true));
        }
        List<Integer> openSlots = GraveHelper.getInventoryOpenSlots((class_2371<class_1799>)inventory.field_7547);
        extraItems.removeIf(class_1799::method_7960);
        for (int i : openSlots) {
            if (extraItems.size() <= 0) break;
            inventory.method_5447(i, (class_1799)extraItems.get(0));
            extraItems.remove(0);
        }
        class_1264.method_17349((class_1937)player.field_6002, (class_2338)player.method_24515(), extraItems);
        player.method_7255(xp);
        Yigd.LOGGER.info(player.method_5476().method_10851() + " retrieved the items from the grave");
    }

    private static class_2371<class_1799> fillInventory(class_1657 player, class_2371<class_1799> inv, Map<String, Object> modInv, boolean fromGrave) {
        class_1799 stack;
        int i;
        class_1661 inventory = player.method_31548();
        int mainSize = inventory.field_7547.size();
        int armorSize = inventory.field_7548.size();
        List armorInventory = inv.subList(mainSize, mainSize + armorSize);
        List mainInventory = inv.subList(0, mainSize);
        List<String> bindingCurse = Collections.singletonList("minecraft:binding_curse");
        class_2371 extraItems = class_2371.method_10211();
        for (i = 0; i < armorInventory.size(); ++i) {
            class_1799 equipped;
            class_1799 armorItem = (class_1799)armorInventory.get(i);
            if (armorItem.method_31573(ModTags.FORCE_ITEM_SLOT)) {
                equipped = inventory.method_7372(i);
                if (!equipped.method_7960()) {
                    extraItems.add((Object)equipped);
                }
                inventory.method_5447(mainInventory.size() + i, armorItem);
                continue;
            }
            if (GraveHelper.hasEnchantments(bindingCurse, armorItem) && YigdConfig.getConfig().graveSettings.applyBindingCurse) {
                if (!fromGrave) {
                    equipped = inventory.method_7372(i);
                    if (!equipped.method_7960()) {
                        extraItems.add((Object)equipped);
                    }
                    inventory.method_5447(mainSize + i, armorItem);
                    continue;
                }
                extraItems.add((Object)armorItem);
                continue;
            }
            equipped = inventory.method_7372(i);
            if (equipped.method_7960()) {
                inventory.method_5447(mainSize + i, armorItem);
                continue;
            }
            extraItems.add((Object)armorItem);
        }
        for (i = mainSize + armorSize; i < inv.size(); ++i) {
            stack = inventory.method_5438(i);
            if (inventory.method_5439() <= i) {
                extraItems.add((Object)((class_1799)inv.get(i)));
                continue;
            }
            if (stack.method_7960()) {
                inventory.method_5447(i, (class_1799)inv.get(i));
                continue;
            }
            extraItems.add((Object)((class_1799)inv.get(i)));
        }
        for (i = 0; i < mainInventory.size(); ++i) {
            stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                inventory.method_5447(i, (class_1799)inv.get(i));
                continue;
            }
            extraItems.add((Object)((class_1799)inv.get(i)));
        }
        if (modInv != null) {
            for (i = 0; i < modInv.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                extraItems.addAll(yigdApi.setInventory(modInv.get(yigdApi.getModName()), player));
            }
        }
        return extraItems;
    }

    public static boolean hasBotaniaKeepIvy(class_1799 stack, boolean alsoDelete) {
        if (stack.method_7960() || !stack.method_7985()) {
            return false;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return false;
        }
        if (nbt.method_10545("Botania_keepIvy") && nbt.method_10577("Botania_keepIvy")) {
            if (alsoDelete) {
                GraveHelper.removeBotaniaKeepIvy(stack);
            }
            return true;
        }
        return false;
    }

    public static void removeBotaniaKeepIvy(class_1799 stack) {
        if (stack.method_7960() || !stack.method_7985()) {
            return;
        }
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return;
        }
        if (nbt.method_10545("Botania_keepIvy")) {
            stack.method_7983("Botania_keepIvy");
        }
    }
}

