/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.mixin;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.ClaimModsApi;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.compat.RequiemCompat;
import com.b1n_ry.yigd.config.DeathEffectConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.GraveAreaOverride;
import com.b1n_ry.yigd.core.GraveHelper;
import com.b1n_ry.yigd.core.ModTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1309.class}, priority=9001)
public abstract class LivingEntityMixin {
    @Shadow
    protected abstract void method_16078();

    @Shadow
    protected abstract void method_23883();

    @Redirect(method={"drop"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropInventory()V"))
    private void generateGrave(class_1309 livingEntity, class_1282 source) {
        class_1657 player;
        block3: {
            block2: {
                if (!(livingEntity instanceof class_1657)) break block2;
                player = (class_1657)livingEntity;
                if (!livingEntity.field_6002.method_8450().method_8355(class_1928.field_19389)) break block3;
            }
            this.method_16078();
            return;
        }
        YigdConfig config = YigdConfig.getConfig();
        class_243 pos = player.method_19538();
        Yigd.NEXT_TICK.add(() -> {
            List<UUID> whitelist;
            int xpPoints;
            DeathEffectConfig claimProtectionRule;
            class_1661 inventory = player.method_31548();
            inventory.method_7381();
            class_2371 allItems = class_2371.method_10211();
            class_2371 items = class_2371.method_10211();
            items.addAll((Collection)inventory.field_7547);
            items.addAll((Collection)inventory.field_7548);
            items.addAll((Collection)inventory.field_7544);
            int currentSize = items.size();
            if (inventory.method_5439() > currentSize) {
                for (int i = currentSize; i < inventory.method_5439(); ++i) {
                    class_1799 stack = inventory.method_5438(i);
                    items.add((Object)stack);
                }
            }
            List<String> soulboundEnchantments = config.graveSettings.soulboundEnchantments;
            YigdConfig.ItemLoss itemLoss = config.graveSettings.itemLoss;
            if (itemLoss.enableLoss) {
                int to;
                int from;
                boolean handleAsStacks = itemLoss.affectStacks;
                if (itemLoss.usePercentRange) {
                    class_2371 vanillaStacks = class_2371.method_10211();
                    vanillaStacks.addAll((Collection)items);
                    vanillaStacks.removeIf(class_1799::method_7960);
                    int totalItems = vanillaStacks.size();
                    if (!itemLoss.affectStacks) {
                        totalItems = 0;
                        for (class_1799 stack : vanillaStacks) {
                            totalItems += stack.method_7947();
                        }
                    }
                    from = (int)((float)itemLoss.lossRangeFrom / 100.0f * (float)totalItems);
                    to = (int)((float)itemLoss.lossRangeTo / 100.0f * (float)totalItems);
                } else {
                    from = itemLoss.lossRangeFrom;
                    to = itemLoss.lossRangeTo;
                }
                int amount = from < to ? new Random().nextInt(from, ++to) : from;
                ArrayList<String> matchingEnchantment = new ArrayList<String>();
                if (itemLoss.ignoreSoulboundItems) {
                    matchingEnchantment.addAll(soulboundEnchantments);
                }
                for (int i = 0; i < amount; ++i) {
                    if (Math.random() * 100.0 > (double)itemLoss.percentChanceOfLoss) continue;
                    GraveHelper.deleteItemFromList((class_2371<class_1799>)items, handleAsStacks, matchingEnchantment);
                }
            }
            class_2371<class_1799> soulboundInventory = GraveHelper.getEnchantedItems((class_2371<class_1799>)items, soulboundEnchantments);
            for (int i = 0; i < items.size(); ++i) {
                class_1799 stack = (class_1799)items.get(i);
                if (!stack.method_31573(ModTags.SOULBOUND_ITEM) && !GraveHelper.hasBotaniaKeepIvy(stack, false)) continue;
                soulboundInventory.set(i, (Object)stack);
            }
            YigdConfig.GraveSettings graveConfig = config.graveSettings;
            GraveHelper.removeFromList((class_2371<class_1799>)items, soulboundInventory);
            List<String> removeEnchantments = graveConfig.deleteEnchantments;
            class_2371<class_1799> removeFromGrave = GraveHelper.getEnchantedItems((class_2371<class_1799>)items, removeEnchantments);
            GraveHelper.removeFromList((class_2371<class_1799>)items, removeFromGrave);
            class_2874 playerDimension = player.field_6002.method_8597();
            class_2378 dimManager = player.field_6002.method_30349().method_30530(class_2378.field_25095);
            class_2338 blockPos = new class_2338(pos);
            boolean canGenerate = GraveAreaOverride.canGenerateOnPos(blockPos, dimManager.method_10221((Object)playerDimension), graveConfig.generateGraves);
            DeathEffectConfig spawnProtectionRule = graveConfig.deathInSpawnProtection;
            DeathEffectConfig alteredSpawnRules = DeathEffectConfig.CREATE_GRAVE;
            class_3218 serverWorld = (class_3218)player.field_6002;
            if (spawnProtectionRule != DeathEffectConfig.CREATE_GRAVE) {
                boolean isSpawnProtected = serverWorld.method_8503().method_3785(serverWorld, blockPos, player);
                if (isSpawnProtected && spawnProtectionRule == DeathEffectConfig.KEEP_ITEMS) {
                    alteredSpawnRules = spawnProtectionRule;
                    for (int i = 0; i < items.size(); ++i) {
                        if (!((class_1799)soulboundInventory.get(i)).method_7960()) continue;
                        soulboundInventory.set(i, (Object)((class_1799)items.remove(i)));
                    }
                } else if (isSpawnProtected && spawnProtectionRule == DeathEffectConfig.DROP_ITEMS) {
                    alteredSpawnRules = spawnProtectionRule;
                    canGenerate = false;
                }
            }
            if ((claimProtectionRule = graveConfig.graveCompatConfig.claimRuleOverride) != DeathEffectConfig.CREATE_GRAVE) {
                boolean isInClaim = false;
                for (ClaimModsApi claimMod : Yigd.claimMods) {
                    if (isInClaim) break;
                    isInClaim = claimMod.isInClaim(blockPos, serverWorld);
                }
                if (isInClaim && claimProtectionRule == DeathEffectConfig.KEEP_ITEMS) {
                    alteredSpawnRules = claimProtectionRule;
                    for (int i = 0; i < items.size(); ++i) {
                        if (!((class_1799)soulboundInventory.get(i)).method_7960()) continue;
                        soulboundInventory.set(i, (Object)((class_1799)items.get(i)));
                        items.set(i, (Object)class_1799.field_8037);
                    }
                } else if (isInClaim && claimProtectionRule == DeathEffectConfig.DROP_ITEMS) {
                    alteredSpawnRules = claimProtectionRule;
                    canGenerate = false;
                }
            }
            ArrayList<Object> modInventories = new ArrayList<Object>();
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object modInv = yigdApi.getInventory(player, true, alteredSpawnRules);
                modInventories.add(modInv);
                allItems.addAll(yigdApi.toStackList(modInv));
                yigdApi.dropAll(player);
            }
            allItems.addAll((Collection)items);
            allItems.removeIf(class_1799::method_7960);
            UUID playerId = player.method_5667();
            if (FabricLoader.getInstance().isModLoaded("requiem") && RequiemCompat.isPlayerShellEntity(player)) {
                playerId = RequiemCompat.getDisplayId(player);
            }
            if (graveConfig.defaultXpDrop) {
                xpPoints = Math.min(7 * player.field_7520, 100);
            } else {
                int currentLevel = player.field_7520;
                int totalExperience = currentLevel >= 32 ? (int)(4.5 * Math.pow(currentLevel, 2.0) - 162.5 * (double)currentLevel + 2220.0) : (currentLevel >= 17 ? (int)(2.5 * Math.pow(currentLevel, 2.0) - 40.5 * (double)currentLevel + 360.0) : (int)(Math.pow(currentLevel, 2.0) + (double)(6 * currentLevel) + (double)player.field_7510));
                xpPoints = (int)((float)graveConfig.xpDropPercent / 100.0f * (float)totalExperience);
            }
            DeadPlayerData.Soulbound.setSoulboundInventories(playerId, soulboundInventory);
            inventory.method_5448();
            player.field_7495 = 0;
            player.field_7510 = 0.0f;
            player.field_7520 = 0;
            if (graveConfig.dropPlayerHead) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8575, 1);
                class_2487 nbt = new class_2487();
                nbt.method_10582("SkullOwner", player.method_5477().method_10851());
                stack.method_7980(nbt);
                items.add((Object)stack);
            }
            if (graveConfig.requireGraveItem) {
                canGenerate = false;
                for (class_1799 stack : items) {
                    if (stack.method_7909() != Yigd.GRAVE_BLOCK.method_8389()) continue;
                    canGenerate = true;
                    stack.method_7934(1);
                }
            }
            if (!(whitelist = DeathInfoManager.INSTANCE.getGraveList()).contains(player.method_5667()) && DeathInfoManager.INSTANCE.isWhiteList() || whitelist.contains(player.method_5667()) && !DeathInfoManager.INSTANCE.isWhiteList()) {
                canGenerate = false;
            }
            int dimId = dimManager.method_10206((Object)playerDimension);
            if (!graveConfig.generateGraves || graveConfig.blacklistDimensions.contains(dimId) || graveConfig.ignoreDeathTypes.contains(source.field_5841) || !canGenerate) {
                for (int i = 0; i < Yigd.apiMods.size(); ++i) {
                    YigdApi yigdApi = Yigd.apiMods.get(i);
                    Object o = modInventories.get(i);
                    items.addAll(yigdApi.toStackList(o));
                    yigdApi.dropOnGround(o, serverWorld, pos);
                }
                class_1264.method_17349((class_1937)player.field_6002, (class_2338)new class_2338(pos), (class_2371)items);
                class_1303.method_31493((class_3218)((class_3218)player.field_6002), (class_243)pos, (int)xpPoints);
                return;
            }
            if (!graveConfig.putXpInGrave) {
                class_1303.method_31493((class_3218)((class_3218)player.field_6002), (class_243)pos, (int)xpPoints);
                xpPoints = 0;
            }
            for (int i = 0; i < soulboundInventory.size(); ++i) {
                inventory.method_5447(i, (class_1799)soulboundInventory.get(i));
            }
            if (allItems.size() > 0 || xpPoints > 0 || graveConfig.generateEmptyGraves) {
                GraveHelper.placeDeathGrave(player.field_6002, pos, inventory.field_7546, (class_2371<class_1799>)items, modInventories, xpPoints, source);
            }
            this.method_16078();
        });
    }

    @Redirect(method={"drop"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropXp()V"))
    private void overwriteXp(class_1309 instance) {
        if (!(instance instanceof class_1657)) {
            this.method_23883();
        }
    }
}

