/*
 * Decompiled with CFR 0.152.
 */
package com.b1n4ry.yigd.block;

import com.b1n4ry.yigd.Yigd;
import com.b1n4ry.yigd.block.entity.GraveBlockEntity;
import com.b1n4ry.yigd.config.DropTypeConfig;
import com.b1n4ry.yigd.config.RetrievalTypeConfig;
import com.b1n4ry.yigd.config.YigdConfig;
import com.b1n4ry.yigd.core.GraveHelper;
import com.mojang.authlib.GameProfile;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6760;
import org.jetbrains.annotations.Nullable;

public class GraveBlock
extends class_2237
implements class_2343,
class_3737 {
    public static final class_2753 FACING = class_2383.field_11177;
    protected static final class_265 SHAPE_NORTH;
    protected static final class_265 SHAPE_BASE_NORTH;
    protected static final class_265 SHAPE_FOOT_NORTH;
    protected static final class_265 SHAPE_CORE_NORTH;
    protected static final class_265 SHAPE_TOP_NORTH;
    protected static final class_265 SHAPE_WEST;
    protected static final class_265 SHAPE_BASE_WEST;
    protected static final class_265 SHAPE_FOOT_WEST;
    protected static final class_265 SHAPE_CORE_WEST;
    protected static final class_265 SHAPE_TOP_WEST;
    protected static final class_265 SHAPE_EAST;
    protected static final class_265 SHAPE_BASE_EAST;
    protected static final class_265 SHAPE_FOOT_EAST;
    protected static final class_265 SHAPE_CORE_EAST;
    protected static final class_265 SHAPE_TOP_EAST;
    protected static final class_265 SHAPE_SOUTH;
    protected static final class_265 SHAPE_BASE_SOUTH;
    protected static final class_265 SHAPE_FOOT_SOUTH;
    protected static final class_265 SHAPE_CORE_SOUTH;
    protected static final class_265 SHAPE_TOP_SOUTH;
    protected static final class_2746 WATERLOGGED;
    private String customName = null;

    public GraveBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12481, WATERLOGGED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        RetrievalTypeConfig retrievalType = YigdConfig.getConfig().graveSettings.retrievalType;
        if (retrievalType == RetrievalTypeConfig.ON_USE || retrievalType == null) {
            this.RetrieveItems(player, world, pos);
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1657 player;
        if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_STAND && entity instanceof class_1657) {
            class_1657 player2 = (class_1657)entity;
            this.RetrieveItems(player2, world, pos);
        } else if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_SNEAK && entity instanceof class_1657 && (player = (class_1657)entity).method_18276()) {
            this.RetrieveItems(player, world, pos);
        }
        super.method_9591(world, pos, state, entity);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_BREAK && this.RetrieveItems(player, world, pos)) {
            return;
        }
        super.method_9576(world, pos, state, player);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof GraveBlockEntity) {
            boolean timePassed;
            GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
            YigdConfig.GraveRobbing graveRobbing = YigdConfig.getConfig().graveSettings.graveRobbing;
            boolean canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == player.method_5667());
            boolean bl = timePassed = graveEntity.age > graveRobbing.afterTime * graveRobbing.timeType.tickFactor();
            if (YigdConfig.getConfig().graveSettings.retrievalType == RetrievalTypeConfig.ON_BREAK && (player.method_7334().equals((Object)graveEntity.getGraveOwner()) || canRobGrave && timePassed) || graveEntity.getGraveOwner() == null) {
                return super.method_9594(state, player, world, pos);
            }
        }
        return 0.0f;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (itemStack.method_7938()) {
            this.customName = itemStack.method_7964().method_10851();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof GraveBlockEntity) {
                GraveBlockEntity graveBlockEntity = (GraveBlockEntity)blockEntity;
                graveBlockEntity.setCustomName(this.customName);
            }
        }
    }

    private class_265 getShape(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            default -> class_259.method_1077();
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ct) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        return this.getShape(dir);
    }

    public class_2680 method_9605(class_1750 context) {
        class_2338 blockPos = context.method_8037();
        class_3610 fluidState = context.method_8045().method_8316(blockPos);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_39363(class_6760.method_39410((Object)class_3612.field_15910, (class_2338)pos));
        }
        return direction.method_10166().method_10179() ? state : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return GraveBlock.method_31618(type, Yigd.GRAVE_BLOCK_ENTITY, GraveBlockEntity::tick);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GraveBlockEntity(this.customName, pos, state);
    }

    private boolean RetrieveItems(class_1657 playerEntity, class_1937 world, class_2338 pos) {
        boolean timePassed;
        if (world.field_9236) {
            return false;
        }
        if (!(playerEntity instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)playerEntity;
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity graveEntity = (GraveBlockEntity)blockEntity;
        if (graveEntity.getGraveOwner() == null) {
            return false;
        }
        GameProfile graveOwner = graveEntity.getGraveOwner();
        class_2371<class_1799> items = graveEntity.getStoredInventory();
        int xp = graveEntity.getStoredXp();
        if (graveOwner == null) {
            return false;
        }
        if (items == null) {
            return false;
        }
        YigdConfig.GraveRobbing graveRobbing = YigdConfig.getConfig().graveSettings.graveRobbing;
        boolean canRobGrave = graveRobbing.enableRobbing && (!graveRobbing.onlyMurderer || graveEntity.getKiller() == player.method_5667());
        int age = graveEntity.age;
        int requiredAge = graveRobbing.afterTime * graveRobbing.timeType.tickFactor();
        boolean isRobbing = false;
        boolean bl = timePassed = age > requiredAge;
        if (!player.method_7334().getId().equals(graveOwner.getId())) {
            if (!canRobGrave || !timePassed) {
                if (canRobGrave) {
                    ArrayList<CallSite> timeStrings = new ArrayList<CallSite>();
                    double timeRemaining = ((double)requiredAge - (double)age) / 20.0;
                    if (timeRemaining >= 3600.0) {
                        timeStrings.add((CallSite)((Object)((int)(timeRemaining / 36000.0) + " hours")));
                        timeRemaining %= 3600.0;
                    }
                    if (timeRemaining >= 60.0) {
                        timeStrings.add((CallSite)((Object)((int)(timeRemaining / 60.0) + " minutes")));
                        timeRemaining %= 60.0;
                    }
                    timeStrings.add((CallSite)((Object)((int)timeRemaining + " seconds")));
                    player.method_7353(class_2561.method_30163((String)("You can retrieve the items from this grave in: " + String.join((CharSequence)", ", timeStrings))), true);
                } else {
                    player.method_7353(class_2561.method_30163((String)"You are not allowed to retrieve these items"), true);
                }
                return false;
            }
            isRobbing = true;
        }
        class_2371<class_1799> graveModItems = graveEntity.getModdedInventories();
        if (YigdConfig.getConfig().graveSettings.dropType == DropTypeConfig.ON_GROUND) {
            items.addAll(graveModItems);
            class_1264.method_17349((class_1937)world, (class_2338)pos, items);
            world.method_8650(pos, false);
            return true;
        }
        ArrayList<class_1799> graveModInv = new ArrayList<class_1799>((Collection<class_1799>)graveModItems);
        GraveHelper.RetrieveItems((class_1657)player, items, graveModInv, xp, isRobbing);
        world.method_8650(pos, false);
        return true;
    }

    static {
        SHAPE_BASE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_NORTH = class_2248.method_9541((double)2.0, (double)1.0, (double)10.0, (double)14.0, (double)3.0, (double)15.0);
        SHAPE_CORE_NORTH = class_2248.method_9541((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)14.0, (double)14.0);
        SHAPE_TOP_NORTH = class_2248.method_9541((double)4.0, (double)14.0, (double)11.0, (double)12.0, (double)15.0, (double)14.0);
        SHAPE_BASE_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_EAST = class_2248.method_9541((double)1.0, (double)1.0, (double)2.0, (double)6.0, (double)3.0, (double)14.0);
        SHAPE_CORE_EAST = class_2248.method_9541((double)2.0, (double)3.0, (double)3.0, (double)5.0, (double)14.0, (double)13.0);
        SHAPE_TOP_EAST = class_2248.method_9541((double)2.0, (double)14.0, (double)4.0, (double)5.0, (double)15.0, (double)12.0);
        SHAPE_BASE_WEST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_WEST = class_2248.method_9541((double)10.0, (double)1.0, (double)2.0, (double)15.0, (double)3.0, (double)14.0);
        SHAPE_CORE_WEST = class_2248.method_9541((double)11.0, (double)3.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0);
        SHAPE_TOP_WEST = class_2248.method_9541((double)11.0, (double)14.0, (double)4.0, (double)14.0, (double)15.0, (double)12.0);
        SHAPE_BASE_SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        SHAPE_FOOT_SOUTH = class_2248.method_9541((double)2.0, (double)1.0, (double)1.0, (double)14.0, (double)3.0, (double)6.0);
        SHAPE_CORE_SOUTH = class_2248.method_9541((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)14.0, (double)5.0);
        SHAPE_TOP_SOUTH = class_2248.method_9541((double)4.0, (double)14.0, (double)2.0, (double)12.0, (double)15.0, (double)5.0);
        SHAPE_NORTH = class_259.method_17786((class_265)SHAPE_BASE_NORTH, (class_265[])new class_265[]{SHAPE_FOOT_NORTH, SHAPE_CORE_NORTH, SHAPE_TOP_NORTH});
        SHAPE_WEST = class_259.method_17786((class_265)SHAPE_BASE_WEST, (class_265[])new class_265[]{SHAPE_FOOT_WEST, SHAPE_CORE_WEST, SHAPE_TOP_WEST});
        SHAPE_EAST = class_259.method_17786((class_265)SHAPE_BASE_EAST, (class_265[])new class_265[]{SHAPE_FOOT_EAST, SHAPE_CORE_EAST, SHAPE_TOP_EAST});
        SHAPE_SOUTH = class_259.method_17786((class_265)SHAPE_BASE_SOUTH, (class_265[])new class_265[]{SHAPE_FOOT_SOUTH, SHAPE_CORE_SOUTH, SHAPE_TOP_SOUTH});
        WATERLOGGED = class_2741.field_12508;
    }
}

