/*
 * Decompiled with CFR 0.152.
 */
package com.b1n4ry.yigd.block.entity;

import com.b1n4ry.yigd.Yigd;
import com.b1n4ry.yigd.config.YigdConfig;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1303;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class GraveBlockEntity
extends class_2586 {
    private GameProfile graveOwner = null;
    private int storedXp = 0;
    private String customName;
    private class_2371<class_1799> storedInventory;
    private class_2371<class_1799> moddedInventories;
    private UUID killer;
    public int age;

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        this(null, pos, state);
    }

    public GraveBlockEntity(String customName, class_2338 pos, class_2680 state) {
        super(Yigd.GRAVE_BLOCK_ENTITY, pos, state);
        this.customName = customName;
        this.storedInventory = class_2371.method_10213((int)41, (Object)class_1799.field_8037);
        this.age = 0;
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("StoredXp", this.storedXp);
        tag.method_10566("Items", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.storedInventory, (boolean)true));
        tag.method_10569("ItemCount", this.storedInventory.size());
        tag.method_10544("age", (long)this.age);
        if (this.graveOwner != null) {
            tag.method_10566("owner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner));
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", this.customName);
        }
        if (this.killer != null) {
            tag.method_25927("killer", this.killer);
        }
        if (this.moddedInventories != null) {
            tag.method_10566("ModdedInventoryItems", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.moddedInventories, (boolean)true));
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.storedInventory = class_2371.method_10213((int)tag.method_10550("ItemCount"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag.method_10562("Items"), this.storedInventory);
        this.storedXp = tag.method_10550("StoredXp");
        this.age = tag.method_10550("age");
        if (tag.method_10545("owner")) {
            this.graveOwner = class_2512.method_10683((class_2487)tag.method_10562("owner"));
        }
        if (tag.method_10545("CustomName")) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10545("killer")) {
            this.killer = tag.method_25926("killer");
        }
        if (tag.method_10545("ModdedInventoryItems")) {
            int modInvSize = tag.method_10562("ModdedInventoryItems").method_10554("Items", 10).size();
            this.moddedInventories = class_2371.method_10213((int)modInvSize, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)tag.method_10562("ModdedInventoryItems"), this.moddedInventories);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        boolean timeHasPassed;
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        if (grave.getGraveOwner() == null) {
            return;
        }
        ++grave.age;
        YigdConfig.GraveDeletion deletion = YigdConfig.getConfig().graveSettings.graveDeletion;
        if (!deletion.canDelete) {
            return;
        }
        if (world == null) {
            return;
        }
        boolean bl = timeHasPassed = grave.age > deletion.afterTime * deletion.timeType.tickFactor();
        if (!timeHasPassed) {
            return;
        }
        if (deletion.dropInventory) {
            int xp = grave.getStoredXp();
            class_2371 dropItems = class_2371.method_10211();
            for (class_1799 stack : grave.getStoredInventory()) {
                if (stack.method_7960()) continue;
                dropItems.add((Object)stack);
            }
            for (class_1799 stack : grave.getModdedInventories()) {
                if (stack.method_7960()) continue;
                dropItems.add((Object)stack);
            }
            if (!dropItems.isEmpty()) {
                class_1264.method_17349((class_1937)world, (class_2338)pos, (class_2371)dropItems);
            }
            if (xp > 0) {
                class_1303.method_31493((class_3218)((class_3218)world), (class_243)new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (int)xp);
            }
        }
        world.method_8650(pos, false);
    }

    public void setGraveOwner(GameProfile owner) {
        this.graveOwner = owner;
    }

    public void setStoredXp(int xp) {
        this.storedXp = xp;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.storedInventory = inventory;
    }

    public void setModdedInventories(class_2371<class_1799> inventories) {
        this.moddedInventories = inventories;
    }

    public void setKiller(UUID killerId) {
        this.killer = killerId;
    }

    public GameProfile getGraveOwner() {
        return this.graveOwner;
    }

    public String getCustomName() {
        return this.customName;
    }

    public class_2371<class_1799> getStoredInventory() {
        return this.storedInventory;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public class_2371<class_1799> getModdedInventories() {
        return this.moddedInventories;
    }

    public UUID getKiller() {
        return this.killer;
    }
}

