/*
 * Decompiled with CFR 0.152.
 */
package com.b1n4ry.yigd.core;

import com.b1n4ry.yigd.Yigd;
import com.b1n4ry.yigd.api.YigdApi;
import com.b1n4ry.yigd.block.entity.GraveBlockEntity;
import com.b1n4ry.yigd.config.LastResortConfig;
import com.b1n4ry.yigd.config.PriorityInventoryConfig;
import com.b1n4ry.yigd.config.YigdConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1264;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.server.MinecraftServer;

public class GraveHelper {
    public static List<Integer> getInventoryOpenSlots(class_2371<class_1799> inventory) {
        ArrayList<Integer> openSlots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.size(); ++i) {
            if (inventory.get(i) != class_1799.field_8037) continue;
            openSlots.add(i);
        }
        return openSlots;
    }

    public static void placeDeathGrave(class_1937 world, class_243 pos, class_1657 player, class_2371<class_1799> invItems, List<Object> modInventories, int xpPoints, UUID killerId) {
        class_2338 blockPos;
        if (world.method_8608()) {
            return;
        }
        int bottomY = world.method_31607();
        int topY = world.method_31600();
        if (!YigdConfig.getConfig().graveSettings.graveInVoid && pos.field_1351 < (double)(bottomY + 1)) {
            return;
        }
        double yPos = pos.field_1351 - 1.0;
        if ((int)yPos != (int)(yPos + 0.5)) {
            yPos += 1.0;
        }
        if ((blockPos = new class_2338(pos.field_1352, (double)((int)yPos), pos.field_1350)).method_10264() <= bottomY) {
            blockPos = new class_2338(blockPos.method_10263(), bottomY + YigdConfig.getConfig().graveSettings.graveSpawnHeight, blockPos.method_10260());
        } else if (blockPos.method_10264() >= topY) {
            blockPos = new class_2338(blockPos.method_10263(), topY - 2, blockPos.method_10260());
        }
        double boundEast = world.method_8621().method_11963();
        double boundWest = world.method_8621().method_11976();
        double boundSouth = world.method_8621().method_11977();
        double boundNorth = world.method_8621().method_11958();
        if ((double)blockPos.method_10263() >= boundEast) {
            blockPos = new class_2338(boundEast - 1.0, (double)blockPos.method_10264(), (double)blockPos.method_10260());
        } else if ((double)blockPos.method_10263() <= boundWest) {
            blockPos = new class_2338(boundWest + 1.0, (double)blockPos.method_10264(), (double)blockPos.method_10260());
        }
        if ((double)blockPos.method_10260() >= boundSouth) {
            blockPos = new class_2338((double)blockPos.method_10263(), (double)blockPos.method_10264(), boundSouth - 1.0);
        } else if ((double)blockPos.method_10260() <= boundNorth) {
            blockPos = new class_2338((double)blockPos.method_10263(), (double)blockPos.method_10264(), boundNorth + 1.0);
        }
        boolean foundViableGrave = false;
        MinecraftServer server = world.method_8503();
        if (server != null) {
            JsonElement json = Yigd.graveyard.get("coordinates");
            boolean point2point = Yigd.graveyard.get("point2point").getAsBoolean();
            class_3218 overworld = world.method_8503().method_30002();
            if (json instanceof JsonArray) {
                JsonElement xyz2;
                JsonArray coordinates = (JsonArray)json;
                if (!point2point) {
                    for (JsonElement blockPosition : coordinates) {
                        int z;
                        int y;
                        JsonObject xyz2;
                        int x;
                        class_2338 gravePos;
                        if (!(blockPosition instanceof JsonObject) || !GraveHelper.gravePlaceableAt((class_1937)overworld, gravePos = new class_2338(x = (xyz2 = (JsonObject)blockPosition).get("x").getAsInt(), y = xyz2.get("y").getAsInt(), z = xyz2.get("z").getAsInt()), false)) continue;
                        GraveHelper.placeGraveBlock(player, (class_1937)overworld, gravePos, invItems, modInventories, xpPoints, killerId);
                        foundViableGrave = true;
                        break;
                    }
                } else if (coordinates.size() >= 2 && (xyz2 = coordinates.get(0)) instanceof JsonObject) {
                    JsonObject pos1 = (JsonObject)xyz2;
                    xyz2 = coordinates.get(1);
                    if (xyz2 instanceof JsonObject) {
                        JsonObject pos2 = (JsonObject)xyz2;
                        int x1 = pos1.get("x").getAsInt();
                        int x2 = pos2.get("x").getAsInt();
                        int y1 = pos1.get("y").getAsInt();
                        int y2 = pos2.get("y").getAsInt();
                        int z1 = pos1.get("z").getAsInt();
                        int z2 = pos2.get("z").getAsInt();
                        int changeX = (x2 - x1) / Math.abs(x2 - x1 != 0 ? x2 - x1 : 1);
                        int changeY = (y2 - y1) / Math.abs(y2 - y1 != 0 ? y2 - y1 : 1);
                        int changeZ = (z2 - z1) / Math.abs(z2 - z1 != 0 ? z2 - z1 : 1);
                        for (int y = y1; y != y2 && !foundViableGrave; y += changeY) {
                            block2: for (int z = z1; z != z2 && !foundViableGrave; z += changeZ) {
                                for (int x = x1; x != x2; x += changeX) {
                                    class_2338 gravePos = new class_2338(x, y, z);
                                    if (!GraveHelper.gravePlaceableAt((class_1937)overworld, gravePos, false)) continue;
                                    GraveHelper.placeGraveBlock(player, (class_1937)overworld, gravePos, invItems, modInventories, xpPoints, killerId);
                                    foundViableGrave = true;
                                    continue block2;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!foundViableGrave && YigdConfig.getConfig().graveSettings.trySoft) {
            for (class_2338 gravePos : class_2338.method_25996((class_2338)blockPos.method_10081(new class_2382(0, 1, 0)), (int)5, (int)5, (int)5)) {
                if (!GraveHelper.gravePlaceableAt(world, gravePos, false)) continue;
                GraveHelper.placeGraveBlock(player, world, gravePos, invItems, modInventories, xpPoints, killerId);
                foundViableGrave = true;
                break;
            }
        }
        if (!foundViableGrave && YigdConfig.getConfig().graveSettings.tryStrict) {
            for (class_2338 gravePos : class_2338.method_25996((class_2338)blockPos.method_10081(new class_2382(0, 1, 0)), (int)5, (int)5, (int)5)) {
                if (!GraveHelper.gravePlaceableAt(world, gravePos, true)) continue;
                GraveHelper.placeGraveBlock(player, world, gravePos, invItems, modInventories, xpPoints, killerId);
                foundViableGrave = true;
                break;
            }
        }
        if (!foundViableGrave) {
            if (YigdConfig.getConfig().graveSettings.lastResort == LastResortConfig.SET_GRAVE) {
                GraveHelper.placeGraveBlock(player, world, blockPos, invItems, modInventories, xpPoints, killerId);
            } else {
                for (YigdApi yigdApi : Yigd.apiMods) {
                    invItems.addAll(yigdApi.toStackList(player));
                }
                class_1264.method_17349((class_1937)world, (class_2338)blockPos, invItems);
                class_1303.method_31493((class_3218)((class_3218)world), (class_243)new class_243((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260()), (int)xpPoints);
            }
        }
    }

    private static boolean gravePlaceableAt(class_1937 world, class_2338 blockPos, boolean strict) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            return false;
        }
        double boundEast = world.method_8621().method_11963();
        double boundWest = world.method_8621().method_11976();
        double boundSouth = world.method_8621().method_11977();
        double boundNorth = world.method_8621().method_11958();
        String path = strict ? "replace_blacklist" : "soft_whitelist";
        boolean hasTag = false;
        class_2248 block = world.method_8320(blockPos).method_26204();
        Collection tagIds = world.method_8514().method_33164(class_2378.field_25105).method_30206((Object)block);
        for (class_2960 tagId : tagIds) {
            if (!tagId.method_12836().equals("yigd") || !tagId.method_12832().equals(path)) continue;
            hasTag = true;
            break;
        }
        if (hasTag && strict || !hasTag && !strict) {
            return false;
        }
        int xPos = blockPos.method_10263();
        int yPos = blockPos.method_10264();
        int zPos = blockPos.method_10260();
        return !((double)xPos >= boundEast && (double)xPos <= boundWest && yPos <= world.method_31607() && yPos >= world.method_31600() && (double)zPos <= boundNorth && (double)zPos >= boundSouth);
    }

    private static void placeGraveBlock(class_1657 player, class_1937 world, class_2338 gravePos, class_2371<class_1799> invItems, List<Object> modInventories, int xpPoints, UUID killerId) {
        class_2586 placed;
        boolean waterlogged = world.method_8316(gravePos) == class_3612.field_15910.method_15785();
        class_2680 graveBlock = (class_2680)((class_2680)Yigd.GRAVE_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)player.method_5735())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlogged));
        world.method_8501(gravePos, graveBlock);
        class_2338 blockPosUnder = new class_2338(gravePos.method_10263(), gravePos.method_10264() - 1, gravePos.method_10260());
        YigdConfig.BlockUnderGrave blockUnderConfig = YigdConfig.getConfig().graveSettings.blockUnderGrave;
        if (blockUnderConfig.generateBlockUnder && blockPosUnder.method_10264() >= world.method_31607() + 1) {
            class_2248 blockUnder = world.method_8320(blockPosUnder).method_26204();
            boolean canPlaceUnder = false;
            Collection tagIds = world.method_8514().method_33164(class_2378.field_25105).method_30206((Object)blockUnder);
            for (class_2960 tagId : tagIds) {
                if (!tagId.method_12836().equals("yigd") || !tagId.method_12832().equals("support_replace_whitelist")) continue;
                canPlaceUnder = true;
                break;
            }
            if (canPlaceUnder) {
                String replaceUnderBlock = world.method_27983() == class_1937.field_25179 ? blockUnderConfig.inOverWorld : (world.method_27983() == class_1937.field_25180 ? blockUnderConfig.inNether : (world.method_27983() == class_1937.field_25181 ? blockUnderConfig.inTheEnd : blockUnderConfig.inCustom));
                class_2960 blockIdentifier = class_2960.method_12829((String)replaceUnderBlock);
                class_2680 blockStateUnder = blockIdentifier == null ? class_2246.field_10566.method_9564() : ((class_2248)class_2378.field_11146.method_10223(blockIdentifier)).method_9564();
                world.method_8501(blockPosUnder, blockStateUnder);
            }
        }
        if ((placed = world.method_8321(gravePos)) instanceof GraveBlockEntity) {
            GraveBlockEntity placedGraveEntity = (GraveBlockEntity)placed;
            GameProfile playerProfile = player.method_7334();
            class_2371 moddedInvStacks = class_2371.method_10211();
            for (int i = 0; i < Yigd.apiMods.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                moddedInvStacks.addAll(yigdApi.toStackList(modInventories.get(i)));
            }
            placedGraveEntity.setInventory(invItems);
            placedGraveEntity.setGraveOwner(playerProfile);
            placedGraveEntity.setCustomName(playerProfile.getName());
            placedGraveEntity.setStoredXp(xpPoints);
            placedGraveEntity.setModdedInventories((class_2371<class_1799>)moddedInvStacks);
            placedGraveEntity.setKiller(killerId);
            System.out.println("[Yigd] Grave spawned at: " + gravePos.method_10263() + ", " + gravePos.method_10264() + ", " + gravePos.method_10260());
        }
        if (YigdConfig.getConfig().graveSettings.tellDeathPos) {
            Yigd.deadPlayerData.setDeathPos(player.method_5667(), gravePos);
        }
    }

    public static class_2371<class_1799> removeFromList(class_2371<class_1799> list, class_2371<class_1799> remove) {
        for (class_1799 item : remove) {
            int match = list.indexOf((Object)item);
            if (match < 0) continue;
            list.set(match, (Object)class_1799.field_8037);
        }
        return list;
    }

    public static class_2371<class_1799> getEnchantedItems(class_2371<class_1799> items, List<String> enchantStrings) {
        class_2371 included = class_2371.method_10213((int)items.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = (class_1799)items.get(i);
            if (!GraveHelper.hasEnchantments(enchantStrings, item)) continue;
            included.set(i, (Object)item);
        }
        return included;
    }

    public static boolean hasEnchantments(List<String> enchants, class_1799 item) {
        if (!item.method_7942()) {
            return false;
        }
        for (class_2520 enchantment : item.method_7921()) {
            String enchantId = ((class_2487)enchantment).method_10558("id");
            if (!enchants.stream().anyMatch(enchantId::equals)) continue;
            return true;
        }
        return false;
    }

    public static void RetrieveItems(class_1657 player, class_2371<class_1799> graveInv, List<class_1799> graveModInv, int xp, boolean robbing) {
        class_2371<class_1799> extraItems;
        class_1661 inventory = player.method_31548();
        class_2371 invInventory = class_2371.method_10211();
        invInventory.addAll((Collection)inventory.field_7547);
        invInventory.addAll((Collection)inventory.field_7548);
        invInventory.addAll((Collection)inventory.field_7544);
        if (inventory.method_5439() > 41) {
            for (int i = 41; i < inventory.method_5439(); ++i) {
                invInventory.add((Object)inventory.method_5438(i));
            }
        }
        ArrayList<Object> currentModInv = new ArrayList<Object>();
        for (YigdApi yigdApi : Yigd.apiMods) {
            Object modInv = yigdApi.getInventory(player, new boolean[0]);
            currentModInv.add(modInv);
            yigdApi.dropAll(player);
        }
        UUID userId = player.method_5667();
        List<Object> modInventories = Yigd.deadPlayerData.getModdedInventories(userId);
        inventory.method_5448();
        PriorityInventoryConfig priorityInventory = robbing ? YigdConfig.getConfig().graveSettings.graveRobbing.robPriority : YigdConfig.getConfig().graveSettings.priority;
        if (priorityInventory == PriorityInventoryConfig.GRAVE) {
            extraItems = GraveHelper.fillInventory(player, graveInv, modInventories, true);
            extraItems.addAll(GraveHelper.fillInventory(player, (class_2371<class_1799>)invInventory, currentModInv, false));
        } else {
            extraItems = GraveHelper.fillInventory(player, (class_2371<class_1799>)invInventory, currentModInv, false);
            extraItems.addAll(GraveHelper.fillInventory(player, graveInv, modInventories, true));
        }
        if (modInventories == null && graveModInv != null) {
            extraItems.addAll(graveModInv);
        }
        List<Integer> openSlots = GraveHelper.getInventoryOpenSlots((class_2371<class_1799>)inventory.field_7547);
        extraItems.removeIf(class_1799::method_7960);
        for (int i : openSlots) {
            if (extraItems.size() <= 0) break;
            inventory.method_5447(i, (class_1799)extraItems.get(0));
            extraItems.remove(0);
        }
        class_1264.method_17349((class_1937)player.field_6002, (class_2338)player.method_24515(), extraItems);
        player.method_7255(xp);
        Yigd.deadPlayerData.dropDeathXp(userId);
        Yigd.deadPlayerData.dropDeathInventory(userId);
        Yigd.deadPlayerData.dropModdedInventory(userId);
        Yigd.deadPlayerData.dropDeathPos(userId);
    }

    private static class_2371<class_1799> fillInventory(class_1657 player, class_2371<class_1799> inv, List<Object> modInv, boolean fromGrave) {
        class_1799 stack;
        int i;
        List armorInventory = inv.subList(36, 40);
        List mainInventory = inv.subList(0, 36);
        class_1661 inventory = player.method_31548();
        List<String> bindingCurse = Collections.singletonList("minecraft:binding_curse");
        class_2371 extraItems = class_2371.method_10211();
        for (i = 0; i < armorInventory.size(); ++i) {
            class_1799 equipped;
            class_1799 armorItem = (class_1799)armorInventory.get(i);
            if (GraveHelper.hasEnchantments(bindingCurse, armorItem)) {
                if (!fromGrave) {
                    equipped = inventory.method_7372(i);
                    if (!equipped.method_7960()) {
                        extraItems.add((Object)equipped);
                    }
                    inventory.method_5447(mainInventory.size() + i, armorItem);
                    continue;
                }
                extraItems.add((Object)armorItem);
                continue;
            }
            equipped = inventory.method_7372(i);
            if (equipped.method_7960()) {
                inventory.method_5447(mainInventory.size() + i, armorItem);
                continue;
            }
            extraItems.add((Object)armorItem);
        }
        for (i = 40; i < inv.size(); ++i) {
            stack = inventory.method_5438(i);
            if (inventory.method_5439() <= i) {
                extraItems.add((Object)((class_1799)inv.get(i)));
                continue;
            }
            if (stack.method_7960()) {
                inventory.method_5447(i, (class_1799)inv.get(i));
                continue;
            }
            extraItems.add((Object)((class_1799)inv.get(i)));
        }
        for (i = 0; i < mainInventory.size(); ++i) {
            stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                inventory.method_5447(i, (class_1799)inv.get(i));
                continue;
            }
            extraItems.add((Object)((class_1799)inv.get(i)));
        }
        if (modInv != null) {
            for (i = 0; i < modInv.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                extraItems.addAll(yigdApi.setInventory(modInv.get(i), player));
            }
        }
        return extraItems;
    }
}

