/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd;

import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.block.GraveBlock;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.compat.InventorioCompat;
import com.b1n_ry.yigd.compat.TravelersBackpackCompat;
import com.b1n_ry.yigd.compat.TrinketsCompat;
import com.b1n_ry.yigd.config.PriorityInventoryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.b1n_ry.yigd.core.YigdCommand;
import com.b1n_ry.yigd.enchantment.DeathSightEnchantment;
import com.b1n_ry.yigd.enchantment.SoulboundEnchantment;
import com.b1n_ry.yigd.item.ScrollItem;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Yigd
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"YIGD");
    public static List<UUID> notNotifiedPlayers = new ArrayList<UUID>();
    public static List<UUID> notNotifiedRobberies = new ArrayList<UUID>();
    public static Map<UUID, PriorityInventoryConfig> clientPriorities = new HashMap<UUID, PriorityInventoryConfig>();
    public static Map<UUID, PriorityInventoryConfig> clientRobPriorities = new HashMap<UUID, PriorityInventoryConfig>();
    public static final GraveBlock GRAVE_BLOCK = new GraveBlock((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15914).strength(0.8f, 3600000.0f));
    public static class_2591<GraveBlockEntity> GRAVE_BLOCK_ENTITY;
    public static final class_1887 DEATH_SIGHT;
    public static JsonObject graveyard;
    public static class_1792 SCROLL_ITEM;
    public static final List<YigdApi> apiMods;
    public static final List<Runnable> NEXT_TICK;

    public void onInitialize() {
        AutoConfig.register(YigdConfig.class, Toml4jConfigSerializer::new);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                block20: {
                    JsonParser parser;
                    InputStream stream;
                    graveyard = null;
                    for (class_2960 id : manager.method_14488("custom", path -> path.equals("graveyard.json"))) {
                        if (!id.method_12836().equals("yigd")) continue;
                        try {
                            stream = manager.method_14486(id).method_14482();
                            try {
                                LOGGER.info("Reloading graveyard");
                                parser = new JsonParser();
                                graveyard = (JsonObject)parser.parse((Reader)new InputStreamReader(stream));
                                break;
                            }
                            finally {
                                if (stream != null) {
                                    stream.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error occurred while loading resource json " + id + "\n" + e);
                        }
                    }
                    try {
                        if (FabricLoader.getInstance() == null || !(FabricLoader.getInstance().getGameInstance() instanceof MinecraftServer)) break block20;
                        for (class_2960 id : manager.method_14488("custom", path -> path.equals("grave.json"))) {
                            if (!id.method_12836().equals("yigd")) continue;
                            try {
                                stream = manager.method_14486(id).method_14482();
                                try {
                                    LOGGER.info("Reloading grave shape (server side)");
                                    parser = new JsonParser();
                                    GraveBlock.reloadVoxelShapes((JsonObject)parser.parse((Reader)new InputStreamReader(stream)));
                                    break;
                                }
                                finally {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Error occurred while loading custom grave shape (server side)\n" + e);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while trying to generate server side voxel-shape\n" + e);
                    }
                }
            }

            public class_2960 getFabricId() {
                return new class_2960("yigd", "graveyard");
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public void method_14491(class_3300 manager) {
                GraveBlock.customModel = null;
                Collection ids = manager.method_14488("models/block", path -> path.equals("grave.json"));
                for (class_2960 id : ids) {
                    if (!id.method_12836().equals("yigd")) continue;
                    try (InputStream stream = manager.method_14486(id).method_14482();){
                        LOGGER.info("Reloading grave model (client)");
                        JsonParser parser = new JsonParser();
                        GraveBlock.customModel = (JsonObject)parser.parse((Reader)new InputStreamReader(stream));
                        GraveBlock.reloadVoxelShapes(GraveBlock.customModel);
                        GraveBlockEntityRenderer.reloadCustomModel();
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while loading custom grave model " + id + "\n" + e);
                    }
                }
            }

            public class_2960 getFabricId() {
                return new class_2960("yigd", "models/block/grave");
            }
        });
        GRAVE_BLOCK_ENTITY = (class_2591)class_2378.method_10226((class_2378)class_2378.field_11137, (String)"yigd:grave_block_entity", (Object)FabricBlockEntityTypeBuilder.create(GraveBlockEntity::new, (class_2248[])new class_2248[]{GRAVE_BLOCK}).build(null));
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960("yigd", "grave"), (Object)((Object)GRAVE_BLOCK));
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("yigd", "grave"), (Object)new class_1747((class_2248)GRAVE_BLOCK, (class_1792.class_1793)new FabricItemSettings().group(class_1761.field_7928)));
        if (YigdConfig.getConfig().utilitySettings.soulboundEnchant) {
            class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("yigd", "soulbound"), (Object)((Object)new SoulboundEnchantment()));
        }
        if (YigdConfig.getConfig().utilitySettings.deathSightEnchant) {
            class_2378.method_10230((class_2378)class_2378.field_11160, (class_2960)new class_2960("yigd", "death_sight"), (Object)DEATH_SIGHT);
        }
        if (YigdConfig.getConfig().utilitySettings.teleportScroll) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("yigd", "tp_scroll"), (Object)SCROLL_ITEM);
        }
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            apiMods.add(new TrinketsCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("inventorio")) {
            apiMods.add(new InventorioCompat());
        }
        if (FabricLoader.getInstance().isModLoaded("travelersbackpack")) {
            apiMods.add(new TravelersBackpackCompat());
        }
        apiMods.addAll(FabricLoader.getInstance().getEntrypoints("yigd", YigdApi.class));
        YigdCommand.registerCommands();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("yigd", "config_update"), (server, player, handler, buf, responseSender) -> {
            if (player == null) {
                return;
            }
            PriorityInventoryConfig normalPriority = (PriorityInventoryConfig)buf.method_10818(PriorityInventoryConfig.class);
            PriorityInventoryConfig robbingPriority = (PriorityInventoryConfig)buf.method_10818(PriorityInventoryConfig.class);
            UUID playerId = player.method_5667();
            clientPriorities.put(playerId, normalPriority);
            clientRobPriorities.put(playerId, robbingPriority);
            LOGGER.info("Priority overwritten for player " + player.method_5476().method_10851() + ". Normal: " + normalPriority.name() + " / Robbing: " + robbingPriority.name());
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world == server.method_30002()) {
                DeathInfoManager.INSTANCE = (DeathInfoManager)world.method_17983().method_17924(DeathInfoManager::fromNbt, DeathInfoManager::new, "yigd_grave_data");
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            UUID playerId = handler.field_14140.method_5667();
            if (notNotifiedPlayers.contains(playerId)) {
                handler.field_14140.method_7353((class_2561)new class_2588("message.yigd.grave.timeout.offline"), false);
                notNotifiedPlayers.remove(playerId);
            }
            if (notNotifiedRobberies.contains(playerId)) {
                handler.field_14140.method_7353((class_2561)new class_2588("message.yigd.grave.robbed.offline"), false);
                notNotifiedRobberies.remove(playerId);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<Runnable> tickFunctions = new ArrayList<Runnable>(NEXT_TICK);
            NEXT_TICK.clear();
            for (Runnable function : tickFunctions) {
                function.run();
            }
        });
    }

    static {
        DEATH_SIGHT = new DeathSightEnchantment();
        SCROLL_ITEM = new ScrollItem(new class_1792.class_1793().method_7892(class_1761.field_7932));
        apiMods = new ArrayList<YigdApi>();
        NEXT_TICK = new ArrayList<Runnable>();
    }
}

