/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.block.entity;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.GraveHelper;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.block.entity.BlockEntityClientSerializable;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3000;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class GraveBlockEntity
extends class_2586
implements BlockEntityClientSerializable,
class_3000 {
    private GameProfile graveOwner = null;
    private int storedXp = 0;
    private String customName;
    private class_2371<class_1799> storedInventory;
    private Map<String, Object> moddedInventories;
    private UUID killer;
    public int age;
    private boolean glowing;

    public GraveBlockEntity(String customName) {
        super(Yigd.GRAVE_BLOCK_ENTITY);
        this.customName = customName;
        this.storedInventory = class_2371.method_10213((int)41, (Object)class_1799.field_8037);
        this.age = 0;
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
    }

    public GraveBlockEntity() {
        this(null);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("StoredXp", this.storedXp);
        tag.method_10566("Items", (class_2520)class_1262.method_5427((class_2487)new class_2487(), this.storedInventory, (boolean)true));
        tag.method_10569("ItemCount", this.storedInventory.size());
        tag.method_10544("age", (long)this.age);
        if (this.graveOwner != null) {
            tag.method_10566("owner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner));
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", this.customName);
        }
        if (this.killer != null) {
            tag.method_25927("killer", this.killer);
        }
        if (this.moddedInventories != null) {
            class_2487 modNbt = new class_2487();
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                if (modName == null || !this.moddedInventories.containsKey(modName)) continue;
                modNbt.method_10566(modName, (class_2520)yigdApi.writeNbt(this.moddedInventories.get(modName)));
            }
            tag.method_10566("ModdedInventoryItems", (class_2520)modNbt);
        }
        tag.method_10556("canGlow", YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave);
        return tag;
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.storedInventory = class_2371.method_10213((int)tag.method_10550("ItemCount"), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag.method_10562("Items"), this.storedInventory);
        this.storedXp = tag.method_10550("StoredXp");
        this.age = tag.method_10550("age");
        if (tag.method_10545("owner")) {
            this.graveOwner = class_2512.method_10683((class_2487)tag.method_10562("owner"));
        }
        if (tag.method_10545("CustomName")) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10545("killer")) {
            this.killer = tag.method_25926("killer");
        }
        if (tag.method_10545("ModdedInventoryItems")) {
            this.moddedInventories = new HashMap<String, Object>();
            class_2487 modNbt = tag.method_10562("ModdedInventoryItems");
            for (YigdApi yigdApi : Yigd.apiMods) {
                String modName = yigdApi.getModName();
                class_2487 nbt = modNbt.method_10562(modName);
                this.moddedInventories.computeIfAbsent(modName, s -> yigdApi.readNbt(nbt));
            }
        }
        this.glowing = YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave;
    }

    public void fromClientTag(class_2487 tag) {
        if (tag.method_10545("owner")) {
            this.graveOwner = class_2512.method_10683((class_2487)tag.method_10562("owner"));
        }
        if (tag.method_10545("CustomName")) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10545("glowing")) {
            this.glowing = tag.method_10577("glowing");
        }
    }

    public class_2487 toClientTag(class_2487 tag) {
        if (this.graveOwner != null) {
            tag.method_10566("owner", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner));
        }
        if (this.customName != null) {
            tag.method_10582("CustomName", this.customName);
        }
        tag.method_10556("canGlow", YigdConfig.getConfig().graveSettings.graveRenderSettings.glowingGrave);
        return tag;
    }

    public void method_16896() {
        boolean timeHasPassed;
        if (this.field_11863 == null) {
            return;
        }
        ++this.age;
        if (this.getGraveOwner() == null) {
            return;
        }
        YigdConfig.GraveDeletion deletion = YigdConfig.getConfig().graveSettings.graveDeletion;
        if (!deletion.canDelete) {
            return;
        }
        boolean bl = timeHasPassed = this.age > deletion.afterTime * deletion.timeType.tickFactor();
        if (!timeHasPassed) {
            return;
        }
        if (deletion.dropInventory) {
            int xp = this.getStoredXp();
            class_2371 dropItems = class_2371.method_10211();
            for (class_1799 stack : this.getStoredInventory()) {
                if (stack.method_7960()) continue;
                dropItems.add((Object)stack);
            }
            for (YigdApi yigdApi : Yigd.apiMods) {
                Object o = this.moddedInventories.get(yigdApi.getModName());
                dropItems.addAll(yigdApi.toStackList(o));
            }
            if (!dropItems.isEmpty()) {
                class_1264.method_17349((class_1937)this.field_11863, (class_2338)this.field_11867, (class_2371)dropItems);
            }
            if (xp > 0) {
                GraveHelper.dropExp((class_3218)this.field_11863, new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260()), xp);
            }
        }
        this.field_11863.method_8650(this.field_11867, false);
        if (this.field_11863.method_8503() == null || this.graveOwner == null) {
            return;
        }
        class_3222 graveOwner = this.field_11863.method_8503().method_3760().method_14602(this.graveOwner.getId());
        if (graveOwner == null) {
            Yigd.notNotifiedPlayers.add(this.graveOwner.getId());
            return;
        }
        graveOwner.method_7353((class_2561)new class_2588("text.yigd.message.timeout" + (deletion.dropInventory ? ".dropped" : "")), false);
    }

    public double method_11006() {
        class_310 client = class_310.method_1551();
        return client.field_1773.method_3193();
    }

    public void setGraveOwner(GameProfile owner) {
        this.graveOwner = owner;
    }

    public void setStoredXp(int xp) {
        this.storedXp = xp;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public void setInventory(class_2371<class_1799> inventory) {
        this.storedInventory = inventory;
    }

    public void setModdedInventories(Map<String, Object> inventories) {
        this.moddedInventories = inventories;
    }

    public void setKiller(UUID killerId) {
        this.killer = killerId;
    }

    public GameProfile getGraveOwner() {
        return this.graveOwner;
    }

    public String getCustomName() {
        return this.customName;
    }

    public class_2371<class_1799> getStoredInventory() {
        return this.storedInventory;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public Map<String, Object> getModdedInventories() {
        return this.moddedInventories;
    }

    public UUID getKiller() {
        return this.killer;
    }

    public boolean canGlow() {
        return this.glowing;
    }
}

