/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.core.DeadPlayerData;
import com.b1n_ry.yigd.core.GraveHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import top.theillusivec4.curios.api.CuriosApi;

public class CuriosCompat
implements YigdApi {
    @Override
    public String getModName() {
        return "curios";
    }

    @Override
    public Object getInventory(class_1657 player) {
        return this.getInventory(player, false);
    }

    @Override
    public Object getInventory(class_1657 player, boolean onDeath) {
        Optional optional = CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)player);
        HashMap inventory = new HashMap();
        List<String> soulboundEnchantments = YigdConfig.getConfig().graveSettings.soulboundEnchantments;
        List<String> deleteEnchantments = YigdConfig.getConfig().graveSettings.deleteEnchantments;
        HashMap soulbound = new HashMap();
        optional.ifPresent(handler -> handler.getCurios().forEach((s, stacksHandler) -> {
            class_1799 stack;
            int i;
            HashMap<String, class_2371> itemStacks = new HashMap<String, class_2371>();
            HashMap<String, class_2371> soulboundStacks = new HashMap<String, class_2371>();
            class_2371 stacks = class_2371.method_10211();
            class_2371 cosmeticStacks = class_2371.method_10211();
            class_2371 soulboundNormal = class_2371.method_10211();
            class_2371 soulboundCosmetic = class_2371.method_10211();
            for (i = 0; i < stacksHandler.getSlots(); ++i) {
                stack = stacksHandler.getStacks().method_5438(i);
                if (onDeath) {
                    if (GraveHelper.hasEnchantments(soulboundEnchantments, stack) || this.isDefaultSoulbound(player, stack.method_7909())) {
                        soulboundNormal.add((Object)stack);
                        continue;
                    }
                    if (GraveHelper.hasEnchantments(deleteEnchantments, stack)) continue;
                    stacks.add((Object)stack);
                    continue;
                }
                stacks.add((Object)stack);
            }
            for (i = 0; i < stacksHandler.getSlots(); ++i) {
                stack = stacksHandler.getCosmeticStacks().method_5438(i);
                if (onDeath) {
                    if (GraveHelper.hasEnchantments(soulboundEnchantments, stack) || this.isDefaultSoulbound(player, stack.method_7909())) {
                        soulboundCosmetic.add((Object)stack);
                        continue;
                    }
                    if (GraveHelper.hasEnchantments(deleteEnchantments, stack)) continue;
                    cosmeticStacks.add((Object)stack);
                    continue;
                }
                cosmeticStacks.add((Object)stack);
            }
            itemStacks.put("normal", stacks);
            itemStacks.put("cosmetic", cosmeticStacks);
            soulboundStacks.put("normal", soulboundNormal);
            soulboundStacks.put("cosmetic", soulboundCosmetic);
            inventory.put(s, itemStacks);
            soulbound.put(s, soulboundStacks);
        }));
        if (onDeath) {
            DeadPlayerData.Soulbound.addModdedSoulbound(player.method_5667(), soulbound);
        }
        return inventory;
    }

    @Override
    public class_2371<class_1799> setInventory(Object inventory, class_1657 player) {
        class_2371 extraItems = class_2371.method_10211();
        if (!(inventory instanceof Map)) {
            return extraItems;
        }
        Map modInv = (Map)inventory;
        Optional optional = CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)player);
        optional.ifPresent(handler -> modInv.forEach((s, itemMap) -> {
            Optional stacksHandlerOptional = handler.getStacksHandler(s);
            stacksHandlerOptional.ifPresent(stacksHandler -> {
                class_2371 normalItems = (class_2371)itemMap.get("normal");
                for (int i = 0; i < normalItems.size(); ++i) {
                    class_1799 stack = (class_1799)normalItems.get(i);
                    if (stack.method_7960()) continue;
                    class_1799 present = stacksHandler.getStacks().method_5438(i);
                    if (present.method_7960()) {
                        stacksHandler.getStacks().method_5447(i, stack);
                        continue;
                    }
                    extraItems.add((Object)stack);
                }
                class_2371 cosmeticItems = (class_2371)itemMap.get("cosmetic");
                for (int i = 0; i < cosmeticItems.size(); ++i) {
                    class_1799 stack = (class_1799)cosmeticItems.get(i);
                    if (stack.method_7960()) continue;
                    class_1799 present = stacksHandler.getCosmeticStacks().method_5438(i);
                    if (present.method_7960()) {
                        stacksHandler.getCosmeticStacks().method_5447(i, stack);
                        continue;
                    }
                    extraItems.add((Object)stack);
                }
            });
        }));
        return extraItems;
    }

    @Override
    public int getInventorySize(Object inventory) {
        if (!(inventory instanceof Map)) {
            return 0;
        }
        ArrayList actualItems = new ArrayList();
        Map modInv = (Map)inventory;
        modInv.forEach((slotName, inv) -> inv.forEach((s, itemStacks) -> {
            for (class_1799 stack : itemStacks) {
                if (stack == null || stack.method_7960()) continue;
                actualItems.add(stack);
            }
        }));
        return actualItems.size();
    }

    @Override
    public void dropAll(class_1657 player) {
        Optional optional = CuriosApi.getCuriosHelper().getCuriosHandler((class_1309)player);
        optional.ifPresent(handler -> handler.getCurios().forEach((s, stacksHandler) -> {
            int i;
            for (i = 0; i < stacksHandler.getSlots(); ++i) {
                stacksHandler.getStacks().method_5447(i, class_1799.field_8037);
            }
            for (i = 0; i < stacksHandler.getSlots(); ++i) {
                stacksHandler.getCosmeticStacks().method_5447(i, class_1799.field_8037);
            }
        }));
    }

    @Override
    public List<class_1799> toStackList(Object inventory) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        if (!(inventory instanceof Map)) {
            return stacks;
        }
        Map modInv = (Map)inventory;
        modInv.forEach((s, slot) -> slot.forEach((stack, itemStacks) -> stacks.addAll((Collection<class_1799>)itemStacks)));
        return stacks;
    }

    @Override
    public class_2487 writeNbt(Object o) {
        class_2487 nbt = new class_2487();
        if (!(o instanceof Map)) {
            return nbt;
        }
        Map modInv = (Map)o;
        modInv.forEach((slotName, slot) -> {
            class_2487 slotNbt = new class_2487();
            slot.forEach((type, stacks) -> {
                class_2487 stacksNbt = class_1262.method_5426((class_2487)new class_2487(), (class_2371)stacks);
                stacksNbt.method_10569("size", stacks.size());
                slotNbt.method_10566(type, (class_2520)stacksNbt);
            });
            nbt.method_10566(slotName, (class_2520)slotNbt);
        });
        return nbt;
    }

    @Override
    public Object readNbt(class_2487 nbt) {
        HashMap inventory = new HashMap();
        Set slotNames = nbt.method_10541();
        for (String slotName : slotNames) {
            HashMap<String, class_2371> slotsMap = new HashMap<String, class_2371>();
            class_2487 slotNbt = nbt.method_10562(slotName);
            for (String slotType : slotNbt.method_10541()) {
                class_2487 itemsNbt = slotNbt.method_10562(slotType);
                int stacksSize = itemsNbt.method_10550("size");
                class_2371 itemStacks = class_2371.method_10213((int)stacksSize, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)itemsNbt, (class_2371)itemStacks);
                slotsMap.put(slotType, itemStacks);
            }
            inventory.put(slotName, slotsMap);
        }
        return inventory;
    }

    private boolean isDefaultSoulbound(class_1657 player, class_1792 item) {
        class_2960 tagId = new class_2960("yigd", "soulbound_item");
        class_3494 tag = player.field_6002.method_8514().method_30218().method_30210(tagId);
        return tag != null && tag.method_15141((Object)item);
    }
}

