/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.core;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.api.YigdApi;
import com.b1n_ry.yigd.core.DeathInfoManager;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class DeadPlayerData {
    public class_2371<class_1799> inventory;
    public List<Object> modInventories;
    public class_2338 gravePos;
    public GameProfile graveOwner;
    public int xp;
    public class_2960 worldId;
    public String dimensionName;
    public class_1282 deathSource;

    public static DeadPlayerData create(class_2371<class_1799> inventory, List<Object> modInventories, class_2338 gravePos, GameProfile graveOwner, int xp, class_1937 world, class_1282 deathSource) {
        class_2960 dimId = world.method_30349().method_30530(class_2378.field_25095).method_10221((Object)world.method_8597());
        String dimName = dimId != null ? dimId.method_12832() : "void";
        return new DeadPlayerData(inventory, modInventories, gravePos, graveOwner, xp, world.method_27983().method_29177(), dimName, deathSource);
    }

    public DeadPlayerData(class_2371<class_1799> inventory, List<Object> modInventories, class_2338 gravePos, GameProfile graveOwner, int xp, class_2960 worldId, String dimensionName, class_1282 deathSource) {
        this.inventory = inventory;
        this.modInventories = modInventories;
        this.gravePos = gravePos;
        this.graveOwner = graveOwner;
        this.xp = xp;
        this.worldId = worldId;
        this.deathSource = deathSource;
        this.dimensionName = dimensionName;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2487 invNbt = class_1262.method_5426((class_2487)new class_2487(), this.inventory);
        class_2487 modNbt = new class_2487();
        for (int i = 0; i < this.modInventories.size(); ++i) {
            YigdApi yigdApi = Yigd.apiMods.get(i);
            modNbt.method_10566(yigdApi.getModName(), (class_2520)yigdApi.writeNbt(this.modInventories.get(i)));
        }
        class_2487 posNbt = class_2512.method_10692((class_2338)this.gravePos);
        class_2487 graveOwnerNbt = class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.graveOwner);
        String worldId = this.worldId.toString();
        class_2487 dsNbt = new class_2487();
        dsNbt.method_10582("name", this.deathSource.field_5841);
        if (this.deathSource.method_5526() != null) {
            dsNbt.method_25927("sourceUuid", this.deathSource.method_5526().method_5667());
        }
        if (this.deathSource.method_5529() != null) {
            dsNbt.method_25927("attackerUuid", this.deathSource.method_5529().method_5667());
        }
        nbt.method_10566("inventory", (class_2520)invNbt);
        nbt.method_10569("inventorySize", this.inventory.size());
        nbt.method_10566("modInventory", (class_2520)modNbt);
        nbt.method_10566("gravePos", (class_2520)posNbt);
        nbt.method_10566("owner", (class_2520)graveOwnerNbt);
        nbt.method_10569("xp", this.xp);
        nbt.method_10582("world", worldId);
        nbt.method_10582("dimension", this.dimensionName);
        nbt.method_10566("causeOfDeath", (class_2520)dsNbt);
        return nbt;
    }

    public static DeadPlayerData fromNbt(class_2487 nbt) {
        return DeadPlayerData.fromNbt(nbt, null);
    }

    public static DeadPlayerData fromNbt(class_2487 nbt, @Nullable class_3218 world) {
        Object deathSource;
        GameProfile graveOwner;
        class_2338 pos;
        class_2520 blockPosNbt;
        class_2520 itemNbt = nbt.method_10580("inventory");
        int invSize = nbt.method_10550("inventorySize");
        class_2371 items = class_2371.method_10213((int)invSize, (Object)class_1799.field_8037);
        if (itemNbt instanceof class_2487) {
            class_2487 itemNbtCompound = (class_2487)itemNbt;
            class_1262.method_5429((class_2487)itemNbtCompound, (class_2371)items);
        }
        class_2520 modNbt = nbt.method_10580("modInventory");
        ArrayList<Object> modInventories = new ArrayList<Object>();
        if (modNbt instanceof class_2487) {
            class_2487 modNbtCompound = (class_2487)modNbt;
            for (int i = 0; i < Yigd.apiMods.size(); ++i) {
                YigdApi yigdApi = Yigd.apiMods.get(i);
                class_2520 e = modNbtCompound.method_10580(yigdApi.getModName());
                if (!(e instanceof class_2487)) continue;
                class_2487 c = (class_2487)e;
                modInventories.add(yigdApi.readNbt(c));
            }
        }
        if ((blockPosNbt = nbt.method_10580("gravePos")) instanceof class_2487) {
            class_2487 c = (class_2487)blockPosNbt;
            pos = class_2512.method_10691((class_2487)c);
        } else {
            pos = null;
        }
        class_2520 ownerElement = nbt.method_10580("owner");
        if (ownerElement instanceof class_2487) {
            class_2487 ownerNbt = (class_2487)ownerElement;
            graveOwner = class_2512.method_10683((class_2487)ownerNbt);
        } else {
            graveOwner = null;
        }
        int xp = nbt.method_10550("xp");
        String worldId = nbt.method_10558("world");
        class_2960 worldIdentifier = new class_2960(worldId);
        String dimName = nbt.method_10558("dimension");
        class_2520 damageSourceNbt = nbt.method_10580("causeOfDeath");
        if (damageSourceNbt instanceof class_2487) {
            class_1297 attacker;
            class_1297 source;
            class_2487 dsNbt = (class_2487)damageSourceNbt;
            String sourceName = dsNbt.method_10558("name");
            if (world != null) {
                source = world.method_14190(dsNbt.method_25926("sourceUuid"));
                attacker = world.method_14190(dsNbt.method_25926("attackerUuid"));
            } else {
                source = null;
                attacker = null;
            }
            if (source != null) {
                deathSource = source.equals(attacker) ? new class_1285(sourceName, source) : new class_1284(sourceName, source, attacker);
            } else {
                switch (sourceName) {
                    case "inFire": {
                        deathSource = class_1282.field_5867;
                        break;
                    }
                    case "lightningBolt": {
                        deathSource = class_1282.field_5861;
                        break;
                    }
                    case "onFire": {
                        deathSource = class_1282.field_5854;
                        break;
                    }
                    case "lava": {
                        deathSource = class_1282.field_5863;
                        break;
                    }
                    case "hotFloor": {
                        deathSource = class_1282.field_5858;
                        break;
                    }
                    case "inWall": {
                        deathSource = class_1282.field_5855;
                        break;
                    }
                    case "cramming": {
                        deathSource = class_1282.field_5844;
                        break;
                    }
                    case "drown": {
                        deathSource = class_1282.field_5859;
                        break;
                    }
                    case "starve": {
                        deathSource = class_1282.field_5852;
                        break;
                    }
                    case "cactus": {
                        deathSource = class_1282.field_5848;
                        break;
                    }
                    case "fall": {
                        deathSource = class_1282.field_5868;
                        break;
                    }
                    case "flyIntoWall": {
                        deathSource = class_1282.field_5843;
                        break;
                    }
                    case "outOfWorld": {
                        deathSource = class_1282.field_5849;
                        break;
                    }
                    case "magic": {
                        deathSource = class_1282.field_5846;
                        break;
                    }
                    case "wither": {
                        deathSource = class_1282.field_5850;
                        break;
                    }
                    case "anvil": {
                        deathSource = class_1282.field_5865;
                        break;
                    }
                    case "fallingBlock": {
                        deathSource = class_1282.field_5847;
                        break;
                    }
                    case "dragonBreath": {
                        deathSource = class_1282.field_5856;
                        break;
                    }
                    case "dryout": {
                        deathSource = class_1282.field_5842;
                        break;
                    }
                    case "sweetBerryBush": {
                        deathSource = class_1282.field_16992;
                        break;
                    }
                    default: {
                        deathSource = class_1282.field_5869;
                    }
                }
            }
        } else {
            deathSource = null;
        }
        return new DeadPlayerData((class_2371<class_1799>)items, (List<Object>)modInventories, pos, graveOwner, xp, worldIdentifier, dimName, (class_1282)deathSource);
    }

    public static class Soulbound {
        private static final Map<UUID, class_2371<class_1799>> soulboundInventories = new HashMap<UUID, class_2371<class_1799>>();
        private static final Map<UUID, List<Object>> moddedSoulbound = new HashMap<UUID, List<Object>>();

        public static class_2371<class_1799> getSoulboundInventory(UUID userId) {
            return soulboundInventories.get(userId);
        }

        public static List<Object> getModdedSoulbound(UUID userId) {
            return moddedSoulbound.get(userId);
        }

        public static void setSoulboundInventories(UUID userId, class_2371<class_1799> soulboundItems) {
            Soulbound.dropSoulbound(userId);
            soulboundInventories.put(userId, soulboundItems);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void addModdedSoulbound(UUID userId, Object modInventory) {
            if (!moddedSoulbound.containsKey(userId)) {
                moddedSoulbound.put(userId, new ArrayList());
            }
            moddedSoulbound.get(userId).add(modInventory);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void dropSoulbound(UUID userId) {
            soulboundInventories.remove(userId);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static void dropModdedSoulbound(UUID userId) {
            moddedSoulbound.remove(userId);
            DeathInfoManager.INSTANCE.method_80();
        }

        public static class_2487 getNbt() {
            class_2487 nbt = new class_2487();
            class_2499 vanillaList = new class_2499();
            soulboundInventories.forEach((uuid, itemStacks) -> {
                class_2487 playerNbt = class_1262.method_5426((class_2487)new class_2487(), (class_2371)itemStacks);
                playerNbt.method_10569("inventorySize", itemStacks.size());
                playerNbt.method_25927("user", uuid);
                vanillaList.add((Object)playerNbt);
            });
            class_2499 modList = new class_2499();
            moddedSoulbound.forEach((uuid, objects) -> {
                class_2487 playerNbt = new class_2487();
                class_2487 inventories = new class_2487();
                for (int i = 0; i < objects.size(); ++i) {
                    YigdApi yigdApi = Yigd.apiMods.get(i);
                    inventories.method_10566(yigdApi.getModName(), (class_2520)yigdApi.writeNbt(objects.get(i)));
                }
                playerNbt.method_10566("Inventories", (class_2520)inventories);
                playerNbt.method_25927("user", uuid);
                modList.add((Object)playerNbt);
            });
            nbt.method_10566("vanilla", (class_2520)vanillaList);
            nbt.method_10566("mods", (class_2520)modList);
            return nbt;
        }

        public static void fromNbt(class_2487 nbt) {
            soulboundInventories.clear();
            moddedSoulbound.clear();
            class_2499 vanillaList = nbt.method_10554("vanilla", 10);
            class_2499 modList = nbt.method_10554("mods", 10);
            for (class_2520 e : vanillaList) {
                if (!(e instanceof class_2487)) continue;
                class_2487 cVanilla = (class_2487)e;
                int itemSize = cVanilla.method_10550("inventorySize");
                class_2371 items = class_2371.method_10213((int)itemSize, (Object)class_1799.field_8037);
                UUID userId = cVanilla.method_25926("user");
                class_1262.method_5429((class_2487)cVanilla, (class_2371)items);
                soulboundInventories.put(userId, (class_2371<class_1799>)items);
            }
            for (class_2520 e : modList) {
                if (!(e instanceof class_2487)) continue;
                class_2487 cMods = (class_2487)e;
                class_2487 modsNbt = cMods.method_10562("Inventories");
                UUID userId = cMods.method_25926("user");
                for (YigdApi yigdApi : Yigd.apiMods) {
                    class_2487 modNbt = modsNbt.method_10562(yigdApi.getModName());
                    Object modInventory = yigdApi.readNbt(modNbt);
                    Soulbound.addModdedSoulbound(userId, modInventory);
                }
            }
        }
    }
}

